/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cms;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1ConstructedInputStream;
import oracle.security.crypto.asn1.ASN1Integer;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.asn1.ASN1SetInputStream;
import oracle.security.crypto.cert.CRL;
import oracle.security.crypto.cert.IssuerAndSerialNo;
import oracle.security.crypto.cert.X509;
import oracle.security.crypto.cms.CIInputStream;
import oracle.security.crypto.cms.CMS;
import oracle.security.crypto.cms.CMSInputConnector;
import oracle.security.crypto.cms.CMSInputStream;
import oracle.security.crypto.cms.CMSSignerInfo;
import oracle.security.crypto.cms.CMSUtils;
import oracle.security.crypto.cms.UnknownSignerException;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.AuthenticationException;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.crypto.util.Utils;
import oracle.security.crypto.util.VersionException;

public class CMSSignedDataInputStream
extends CMSInputStream {
    private ASN1Integer version;
    private Hashtable sigTable;
    private Hashtable digestTable;
    private Vector certificates;
    private Vector crls;
    private boolean readingFromConnector;
    private ASN1ObjectID encapContentType;
    private Datacontent originaldata;
    private boolean readInitial = false;
    private boolean terminated = false;
    private ASN1ConstructedInputStream ci_in;
    private ASN1ConstructedInputStream cic_in;
    private ASN1ConstructedInputStream dd_in;
    private CIInputStream content_in;

    public CMSSignedDataInputStream(InputStream in) {
        super(in);
        this.readingFromConnector = false;
        this.originaldata = new Datacontent();
    }

    public CMSSignedDataInputStream(CMSInputConnector conn) {
        super(conn.getInputStream());
        this.readingFromConnector = true;
        this.originaldata = new Datacontent();
    }

    private void ensureReadInitial() throws IOException {
        if (!this.readInitial) {
            if (!this.readingFromConnector) {
                this.ci_in = new ASN1SequenceInputStream(this.in);
                if (!CMS.id_signedData.equals((Object)new ASN1ObjectID((InputStream)this.ci_in))) {
                    throw new InvalidInputException("Content-type 'id-signedData' expected.");
                }
                this.cic_in = new ASN1ConstructedInputStream((InputStream)this.ci_in, 0);
                this.dd_in = new ASN1SequenceInputStream((InputStream)this.cic_in);
            } else {
                this.dd_in = new ASN1SequenceInputStream(this.in);
            }
            this.version = new ASN1Integer((InputStream)this.dd_in);
            if (!this.version.equals(1) && !this.version.equals(3)) {
                throw new VersionException("Expected Version 1 or 3 but got " + this.version.getValue());
            }
            this.digestTable = new Hashtable();
            try {
                ASN1SetInputStream digestAlgIDs = new ASN1SetInputStream((InputStream)this.dd_in);
                while (digestAlgIDs.hasMoreData()) {
                    AlgorithmIdentifier digestAlgID = new AlgorithmIdentifier((InputStream)digestAlgIDs);
                    if (this.digestTable.get(digestAlgID) != null) continue;
                    this.digestTable.put(digestAlgID, MessageDigest.getInstance(CMSUtils.getAlgoName(digestAlgID)));
                }
                digestAlgIDs.terminate();
            }
            catch (NoSuchAlgorithmException ex) {
                throw new InvalidInputException("Unrecognized algorithm identifier or invalid parameters");
            }
            this.content_in = new CIInputStream((InputStream)this.dd_in);
            this.encapContentType = this.content_in.getContentType();
            this.readInitial = true;
        }
    }

    private void ensureTerminated() throws IOException {
        if (!this.terminated) {
            if (this.dd_in.getCurrentTag() == 0) {
                this.dd_in.setCurrentTag(17);
                this.certificates = new Vector();
                ASN1SetInputStream certs = new ASN1SetInputStream((InputStream)this.dd_in);
                try {
                    while (certs.hasMoreData()) {
                        this.certificates.addElement(CMSUtils.toX509JCECertificate(new X509((InputStream)certs)));
                    }
                    certs.terminate();
                }
                catch (CertificateException ex) {
                    throw new IOException(ex.toString());
                }
            }
            if (this.dd_in.getCurrentTag() == 1) {
                this.dd_in.setCurrentTag(17);
                this.crls = new Vector();
                ASN1SetInputStream cs = new ASN1SetInputStream((InputStream)this.dd_in);
                while (cs.hasMoreData()) {
                    this.crls.addElement(new CRL((InputStream)cs));
                }
                cs.terminate();
            }
            if (!this.dd_in.hasMoreData()) {
                throw new InvalidInputException("Unexpected end of stream");
            }
            this.sigTable = new Hashtable();
            ASN1SetInputStream sis = new ASN1SetInputStream((InputStream)this.dd_in);
            while (sis.hasMoreData()) {
                CMSSignerInfo si = new CMSSignerInfo((InputStream)sis);
                if (si.getSPKI() != null) {
                    this.sigTable.put(Utils.toHexString((byte[])si.getSPKI()), si);
                    continue;
                }
                if (si.getIASN() != null) {
                    this.sigTable.put(si.getIASN(), si);
                    continue;
                }
                throw new InvalidInputException("Signer Identifier must be IASN or SPKI");
            }
            sis.terminate();
            this.dd_in.terminate();
            if (!this.readingFromConnector) {
                this.cic_in.terminate();
                this.ci_in.terminate();
            }
            Enumeration e = this.digestTable.elements();
            while (e.hasMoreElements()) {
                MessageDigest md = (MessageDigest)e.nextElement();
                md.digest();
            }
            this.terminated = true;
        }
    }

    @Override
    public ASN1ObjectID getEnclosedContentType() throws IOException {
        this.ensureReadInitial();
        return this.encapContentType;
    }

    public Enumeration signers() throws IOException {
        this.ensureTerminated();
        return this.sigTable.elements();
    }

    public Vector getCertificates() throws IOException {
        this.ensureTerminated();
        return this.certificates;
    }

    public Vector getCRLs() throws IOException {
        this.ensureTerminated();
        return this.crls;
    }

    public CMSSignerInfo getSignerInfo(X509Certificate signerCert) throws UnknownSignerException, IOException, CertificateEncodingException, NoSuchAlgorithmException {
        CMSSignerInfo si = (CMSSignerInfo)this.sigTable.get(new IssuerAndSerialNo(new X509(signerCert.getEncoded())));
        if (si == null) {
            si = (CMSSignerInfo)this.sigTable.get(Utils.toHexString((byte[])CMSUtils.generateSPKI64(signerCert)));
        }
        if (si == null) {
            si = (CMSSignerInfo)this.sigTable.get(Utils.toHexString((byte[])CMSUtils.generateSPKI160(signerCert)));
        }
        if (si == null) {
            throw new UnknownSignerException("Specified signer could not be found");
        }
        return si;
    }

    public void verifySignature(X509Certificate signerCert) throws AuthenticationException, UnknownSignerException {
        if (!this.readInitial) {
            throw new AuthenticationException("No input read");
        }
        try {
            this.ensureTerminated();
            CMSSignerInfo si = this.getSignerInfo(signerCert);
            MessageDigest md = (MessageDigest)this.digestTable.get(si.getDigestAlgID());
            if (md == null) {
                throw new AuthenticationException("Message digest algorithm was not declared.");
            }
            si.verifySignature(this.originaldata.buffer, this.encapContentType, signerCert.getPublicKey());
        }
        catch (IOException ex) {
            throw new AuthenticationException("Not at end of stream");
        }
        catch (CertificateEncodingException ex) {
            throw new AuthenticationException(ex.toString());
        }
        catch (NoSuchAlgorithmException ex) {
            throw new AuthenticationException(ex.toString());
        }
        catch (SignatureException ex) {
            throw new AuthenticationException(ex.toString());
        }
    }

    @Override
    public int read() throws IOException {
        this.ensureReadInitial();
        int ch = this.content_in.read();
        if (ch == -1) {
            this.ensureTerminated();
        } else {
            Enumeration e = this.digestTable.elements();
            while (e.hasMoreElements()) {
                MessageDigest md = (MessageDigest)e.nextElement();
                md.update((byte)ch);
                this.originaldata.update((byte)ch);
            }
        }
        return ch;
    }

    @Override
    public int read(byte[] buffer, int offset, int len) throws IOException {
        this.ensureReadInitial();
        int efflen = this.content_in.read(buffer, offset, len);
        if (efflen == -1) {
            this.ensureTerminated();
        } else {
            Enumeration e = this.digestTable.elements();
            while (e.hasMoreElements()) {
                MessageDigest md = (MessageDigest)e.nextElement();
                md.update(buffer, offset, efflen);
                this.originaldata.update(buffer, offset, efflen);
            }
        }
        return efflen;
    }

    @Override
    public int available() throws IOException {
        this.ensureReadInitial();
        return this.content_in.available();
    }

    @Override
    public long skip(long n) throws IOException {
        throw new IOException("Skip not implemented.");
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void mark(int readlimit) {
    }

    @Override
    public void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }

    @Override
    public void terminate() throws IOException {
        if (!this.terminated) {
            this.content_in.ensureTerminated();
            this.ensureTerminated();
        }
    }

    public BigInteger getVersionNumber() throws IOException {
        this.ensureReadInitial();
        return this.version.getValue();
    }

    public ASN1Integer getVersion() throws IOException {
        this.ensureReadInitial();
        return this.version;
    }

    public Enumeration getDigestAlgIDs() throws IOException {
        this.ensureReadInitial();
        return this.digestTable.elements();
    }

    final class Datacontent {
        int len = 0;
        byte[] buffer = null;

        public void update(byte ch) {
            int length = this.len + 1;
            byte[] buffertemp = new byte[length];
            if (this.len != 0) {
                System.arraycopy(this.buffer, 0, buffertemp, 0, this.len);
            }
            buffertemp[this.len] = ch;
            this.buffer = null;
            this.buffer = buffertemp;
            buffertemp = null;
            this.len = length;
        }

        public void update(byte[] buff, int offset, int leng) {
            int length = this.len + leng;
            byte[] buffertemp = new byte[length];
            if (this.len != 0) {
                System.arraycopy(this.buffer, 0, buffertemp, 0, this.len);
            }
            System.arraycopy(buff, offset, buffertemp, this.len, leng);
            this.buffer = null;
            this.buffer = buffertemp;
            buffertemp = null;
            this.len = length;
        }
    }
}

