/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cms;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1GenericConstructed;
import oracle.security.crypto.asn1.ASN1Integer;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.asn1.ASN1Set;
import oracle.security.crypto.asn1.ASN1SetInputStream;
import oracle.security.crypto.cert.AttributeSet;
import oracle.security.crypto.cert.CRL;
import oracle.security.crypto.cert.CertificateTrustPolicy;
import oracle.security.crypto.cert.CertificateVerifier;
import oracle.security.crypto.cert.IssuerAndSerialNo;
import oracle.security.crypto.cert.X509;
import oracle.security.crypto.cms.CMS;
import oracle.security.crypto.cms.CMSContentInfo;
import oracle.security.crypto.cms.CMSSignerInfo;
import oracle.security.crypto.cms.CMSUtils;
import oracle.security.crypto.cms.EncapsulatedContentInfo;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.AuthenticationException;
import oracle.security.crypto.util.FixedByteArrayOutputStream;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.StreamableOutputException;
import oracle.security.crypto.util.UnsyncByteArrayOutputStream;
import oracle.security.crypto.util.Utils;
import oracle.security.crypto.util.VersionException;

public class CMSSignedDataContentInfo
extends CMSContentInfo {
    private ASN1Integer version;
    private CMSContentInfo contentInfo;
    private Vector certificates;
    private Vector crls;
    private Hashtable sigTable;
    private boolean createExternalSignature = false;
    private byte[] exposedContent = null;

    public CMSSignedDataContentInfo() {
        super(CMS.id_signedData);
    }

    public CMSSignedDataContentInfo(CMSContentInfo contentInfo) {
        super(CMS.id_signedData);
        if (contentInfo == null) {
            throw new IllegalArgumentException("Null Content Info");
        }
        this.contentInfo = contentInfo;
        this.sigTable = new Hashtable();
    }

    public CMSSignedDataContentInfo(InputStream is) throws IOException {
        super(CMS.id_signedData);
        this.input(is);
    }

    @Override
    protected void setExposedContent(byte[] expContent) {
        this.exposedContent = expContent;
    }

    @Override
    protected byte[] getExposedContent() {
        if (this.exposedContent == null) {
            if (this.contentInfo == null) {
                return null;
            }
            try {
                UnsyncByteArrayOutputStream sdStore = new UnsyncByteArrayOutputStream();
                boolean version1 = true;
                if (this.sigTable != null) {
                    Enumeration e = this.sigTable.elements();
                    while (e.hasMoreElements() && version1) {
                        if (!((CMSSignerInfo)e.nextElement()).isSPKI()) continue;
                        version1 = false;
                    }
                }
                if (this.certificates != null && version1) {
                    Enumeration k = this.certificates.elements();
                    while (k.hasMoreElements() && version1) {
                        Certificate cert = (Certificate)k.nextElement();
                        if (cert instanceof X509Certificate) continue;
                        version1 = false;
                    }
                }
                if (version1 && !this.contentInfo.getContentType().equals((Object)CMS.id_data)) {
                    version1 = false;
                }
                this.version = version1 ? new ASN1Integer(1L) : new ASN1Integer(3L);
                this.version.output((OutputStream)sdStore);
                Hashtable<AlgorithmIdentifier, String> digestAlgIDs = new Hashtable<AlgorithmIdentifier, String>();
                Enumeration e = this.sigTable.elements();
                while (e.hasMoreElements()) {
                    digestAlgIDs.put(((CMSSignerInfo)e.nextElement()).getDigestAlgID(), "NOTHING");
                }
                new ASN1Set(digestAlgIDs.keys()).output((OutputStream)sdStore);
                new EncapsulatedContentInfo(this.contentInfo, !this.createExternalSignature).output((OutputStream)sdStore);
                Vector certificatesX509 = null;
                if (this.certificates != null) {
                    certificatesX509 = CMSUtils.toX509Vector(this.certificates);
                }
                if (certificatesX509 != null) {
                    ASN1GenericConstructed.outputValue((OutputStream)sdStore, (Vector)new ASN1Set(certificatesX509).elements(), (int)0);
                }
                if (this.crls != null) {
                    ASN1GenericConstructed.outputValue((OutputStream)sdStore, (Vector)new ASN1Set(this.crls).elements(), (int)1);
                }
                new ASN1Set(this.sigTable.elements()).output((OutputStream)sdStore);
                byte[] buf = sdStore.toByteArray();
                byte[] hdrbuf = Utils.toBytes((Streamable)ASN1Sequence.makeHeader((int)buf.length));
                FixedByteArrayOutputStream bos = new FixedByteArrayOutputStream(hdrbuf.length + buf.length);
                bos.write(hdrbuf, 0, hdrbuf.length);
                bos.write(buf, 0, buf.length);
                this.exposedContent = bos.toByteArray();
            }
            catch (IOException ex) {
                throw new StreamableOutputException(ex.toString());
            }
            catch (NullPointerException ex) {
                throw new StreamableOutputException("CMS Object is not initialized: " + ex.toString());
            }
            catch (CertificateEncodingException ex) {
                throw new StreamableOutputException("Error while encoding the Certificate");
            }
        }
        return this.exposedContent;
    }

    @Override
    public boolean isDegenerate() {
        if (this.contentInfo == null) {
            return false;
        }
        return this.sigTable.size() == 0;
    }

    public boolean isExternalSignature() {
        if (this.contentInfo == null) {
            return false;
        }
        if (this.sigTable.size() == 0) {
            return false;
        }
        return this.contentInfo.isDetached();
    }

    public void writeExternalSignature(boolean createExternalSignature) {
        this.createExternalSignature = createExternalSignature;
        this.update();
    }

    @Override
    public boolean isDetached() {
        if (this.contentInfo == null) {
            return true;
        }
        ASN1ObjectID cType = this.contentInfo.getContentType();
        if (cType.equals((Object)CMS.id_digestedData) || cType.equals((Object)CMS.id_signedData) || cType.equals((Object)CMS.id_ct_authData) || cType.equals((Object)CMS.id_encryptedData) || cType.equals((Object)CMS.id_envelopedData)) {
            return false;
        }
        return this.contentInfo.isDetached();
    }

    public void setEnclosed(CMSContentInfo content) {
        if (this.contentInfo == null) {
            throw new IllegalArgumentException("Null Content Info");
        }
        this.contentInfo = content;
        this.update();
    }

    public CMSContentInfo getEnclosed() {
        return this.contentInfo;
    }

    public ASN1ObjectID getEnclosedContentType() {
        return this.contentInfo.getContentType();
    }

    public BigInteger getVersionNumber() {
        return this.version.getValue();
    }

    public ASN1Integer getVersion() {
        return this.version;
    }

    public Enumeration signers() {
        return this.sigTable.elements();
    }

    public String toString() {
        if (this.isDegenerate()) {
            return "degenerate CMS 'signed-data' object";
        }
        String st = this.isDetached() ? " Detached " : "";
        String st1 = this.isDegenerate() ? " Degenerate " : "";
        String st2 = this.isExternalSignature() ? " ExternalSignature " : "";
        StringBuffer sb = new StringBuffer(st + st1 + st2 + "CMS 'signedData' object, encloses \n");
        sb.append(this.contentInfo.toString());
        sb.append("Version: " + this.version.intValue() + "\n");
        sb.append(", " + Utils.plural((int)this.sigTable.size(), (String)"signature"));
        if (this.certificates != null) {
            sb.append(", " + Utils.plural((int)this.certificates.size(), (String)"certificate"));
        }
        if (this.crls != null) {
            sb.append(", " + Utils.plural((int)this.crls.size(), (String)"CRL"));
        }
        return sb.toString();
    }

    public Vector getCertificates() {
        return this.certificates;
    }

    public Vector getCRLs() {
        return this.crls;
    }

    public CMSSignerInfo getSignerInfo(X509Certificate signerCert) throws NoSuchAlgorithmException, SignatureException, IOException, CertificateEncodingException {
        CMSSignerInfo si = (CMSSignerInfo)this.sigTable.get(new IssuerAndSerialNo(new X509(signerCert.getEncoded())));
        if (si == null) {
            si = (CMSSignerInfo)this.sigTable.get(Utils.toHexString((byte[])CMSUtils.generateSPKI160(signerCert)));
        }
        if (si == null) {
            si = (CMSSignerInfo)this.sigTable.get(Utils.toHexString((byte[])CMSUtils.generateSPKI64(signerCert)));
        }
        if (si == null) {
            throw new SignatureException("Signer is not present");
        }
        return si;
    }

    public int hashCode() {
        try {
            UnsyncByteArrayOutputStream bos = new UnsyncByteArrayOutputStream();
            this.output((OutputStream)bos);
            return new String(bos.toByteArray()).hashCode();
        }
        catch (IOException ex) {
            throw new StreamableOutputException(ex.toString());
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CMSSignedDataContentInfo)) {
            return false;
        }
        return this.hashCode() == ((CMSSignedDataContentInfo)obj).hashCode();
    }

    public void addCertificate(X509Certificate cert) {
        if (this.certificates == null) {
            this.certificates = new Vector();
        }
        this.certificates.addElement(cert);
        this.update();
    }

    public void addCRL(CRL crl) {
        if (this.crls == null) {
            this.crls = new Vector();
        }
        this.crls.addElement(crl);
        this.update();
    }

    public void addCertificates(Vector certs) {
        if (certs != null) {
            if (this.certificates == null) {
                this.certificates = new Vector();
            }
            int j = certs.size();
            for (int i = 0; i < j; ++i) {
                this.certificates.addElement(certs.elementAt(i));
            }
            this.update();
        }
    }

    public void addCRLs(Vector crls) {
        if (crls != null) {
            if (this.crls == null) {
                this.crls = new Vector();
            }
            int j = crls.size();
            for (int i = 0; i < j; ++i) {
                this.crls.addElement(crls.elementAt(i));
            }
            this.update();
        }
    }

    public void addSignature(AttributeSet authenticatedAttributes, PrivateKey signerKey, X509Certificate signerCert, AlgorithmIdentifier digestAlgID, AlgorithmIdentifier digestEncryptionAlgID, AttributeSet unauthenticatedAttributes) throws InvalidKeyException, SignatureException, NoSuchAlgorithmException, IOException, CertificateEncodingException {
        this.addSignerInfo(signerCert, new CMSSignerInfo(this.contentInfo, authenticatedAttributes, signerKey, signerCert, digestAlgID, digestEncryptionAlgID, unauthenticatedAttributes));
    }

    public void addSignature(AttributeSet authenticatedAttributes, PrivateKey signerKey, X509Certificate signerCert, AlgorithmIdentifier digestAlgID, AlgorithmIdentifier digestEncryptionAlgID, AttributeSet unauthenticatedAttributes, boolean useSPKI64) throws InvalidKeyException, SignatureException, NoSuchAlgorithmException {
        this.addSignerInfo(signerCert, new CMSSignerInfo(this.contentInfo, authenticatedAttributes, signerKey, signerCert, digestAlgID, digestEncryptionAlgID, unauthenticatedAttributes, useSPKI64));
    }

    public void addSignerInfo(X509Certificate signerCert, CMSSignerInfo signerInfo) throws NoSuchAlgorithmException {
        if (signerInfo.isSPKI()) {
            this.sigTable.put(Utils.toHexString((byte[])signerInfo.getSPKI()), signerInfo);
        } else {
            this.sigTable.put(signerInfo.getIASN(), signerInfo);
        }
        this.update();
    }

    public void verifySignature(X509Certificate signerCert) throws AuthenticationException, NoSuchAlgorithmException, CertificateEncodingException, IOException, SignatureException {
        this.verifySignature(signerCert, this.contentInfo);
    }

    public void verifySignature(X509Certificate signerCert, CMSContentInfo contentInfo) throws AuthenticationException, NoSuchAlgorithmException, IOException, CertificateEncodingException, SignatureException {
        CMSSignerInfo si = this.getSignerInfo(signerCert);
        si.verifySignature(contentInfo, signerCert.getPublicKey());
    }

    public void verify(CertificateTrustPolicy trustPolicy) throws AuthenticationException {
        this.verify(trustPolicy, this.contentInfo);
    }

    public void verify(CertificateTrustPolicy trustPolicy, CMSContentInfo contentInfo) throws AuthenticationException {
        AuthenticationException finalException = null;
        CertificateVerifier cv = null;
        try {
            cv = trustPolicy.makeCertificateVerifier(CMSUtils.toX509Vector(this.certificates), this.crls);
        }
        catch (CertificateEncodingException ed) {
            throw new AuthenticationException(ed.toString());
        }
        Enumeration e = this.signers();
        while (e.hasMoreElements()) {
            CMSSignerInfo si = (CMSSignerInfo)e.nextElement();
            try {
                X509 cert = cv.getValidCertificate(si.getIASN());
                if (cert == null) continue;
                oracle.security.crypto.core.PublicKey phaoskey = cert.getPublicKey();
                PublicKey key = CMSUtils.toJCEPublicKey(cert.getPublicKey());
                si.verifySignature(contentInfo, key);
                return;
            }
            catch (NoSuchAlgorithmException ex) {
                throw new AuthenticationException(ex.toString());
            }
            catch (SignatureException ex) {
                throw new AuthenticationException(ex.toString());
            }
            catch (InvalidKeySpecException ex) {
                throw new AuthenticationException(ex.toString());
            }
            catch (AuthenticationException ex) {
                finalException = ex;
            }
        }
        if (finalException == null) {
            throw new AuthenticationException("Contains no signatures for which a certification path could be found.");
        }
        throw finalException;
    }

    @Override
    protected void inputContent(InputStream is) throws IOException {
        ASN1SequenceInputStream sd = new ASN1SequenceInputStream(is);
        this.version = new ASN1Integer((InputStream)sd);
        if (!this.version.equals(1) && !this.version.equals(3)) {
            throw new VersionException("Expected Version 1 or 3 But Got " + this.version.getValue());
        }
        ASN1SetInputStream da = new ASN1SetInputStream((InputStream)sd);
        da.terminate(true);
        EncapsulatedContentInfo encap_info = new EncapsulatedContentInfo((InputStream)sd);
        this.contentInfo = encap_info.getCMSContentInfo();
        if (sd.getCurrentTag() == 0) {
            sd.setCurrentTag(17);
            this.certificates = new Vector();
            ASN1SetInputStream certs = new ASN1SetInputStream((InputStream)sd);
            try {
                while (certs.hasMoreData()) {
                    this.certificates.addElement(CMSUtils.toX509JCECertificate(new X509((InputStream)certs)));
                }
                certs.terminate();
            }
            catch (CertificateException ex) {
                throw new IOException(ex.toString());
            }
        } else {
            this.certificates = null;
        }
        if (sd.getCurrentTag() == 1) {
            sd.setCurrentTag(17);
            this.crls = new Vector();
            ASN1SetInputStream cs = new ASN1SetInputStream((InputStream)sd);
            while (cs.hasMoreData()) {
                this.crls.addElement(new CRL((InputStream)cs));
            }
            cs.terminate();
        } else {
            this.crls = null;
        }
        this.sigTable = new Hashtable();
        ASN1SetInputStream sis = new ASN1SetInputStream((InputStream)sd);
        while (sis.hasMoreData()) {
            CMSSignerInfo si = new CMSSignerInfo((InputStream)sis);
            if (new ASN1Integer(si.getVersionNumber()).equals(1)) {
                if (si.getIASN() == null) {
                    throw new InvalidInputException("signed-data Version 1 must contain IASN as signer identifier");
                }
                this.sigTable.put(si.getIASN(), si);
                continue;
            }
            if (si.getSPKI() == null) {
                throw new InvalidInputException("signed-data Version 3 must contain SPKI as signer identifier");
            }
            this.sigTable.put(Utils.toHexString((byte[])si.getSPKI()), si);
        }
        sis.terminate();
        sd.terminate();
        if (this.contentInfo.isDetached()) {
            this.createExternalSignature = true;
        }
    }

    @Override
    protected void update() {
        super.update();
        this.exposedContent = null;
    }
}

