/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cms;

import java.util.Date;
import javax.crypto.SecretKey;
import oracle.security.crypto.asn1.ASN1Date;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1OctetString;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.cms.CMSRecipientInfoSpec;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.Utils;

public class CMSKEKRecipientInfoSpec
implements CMSRecipientInfoSpec {
    private AlgorithmIdentifier keyEncryptionAlgID;
    private SecretKey symmetricKey;
    private byte[] keyIdentifier;
    private Date keyDate;
    private ASN1Sequence otherKeyAttribute;
    private byte[] encryptedKey;
    private String encryptedKeyAlgo = null;

    public CMSKEKRecipientInfoSpec(AlgorithmIdentifier keyEncryptionAlgID, SecretKey symmetricKey, byte[] keyIdentifier) {
        this.keyEncryptionAlgID = keyEncryptionAlgID;
        this.symmetricKey = symmetricKey;
        this.keyIdentifier = keyIdentifier;
    }

    public CMSKEKRecipientInfoSpec(AlgorithmIdentifier keyEncryptionAlgID, SecretKey symmetricKey, byte[] keyIdentifier, Date keyDate) {
        this.keyEncryptionAlgID = keyEncryptionAlgID;
        this.symmetricKey = symmetricKey;
        this.keyIdentifier = keyIdentifier;
        this.keyDate = keyDate;
    }

    public CMSKEKRecipientInfoSpec(AlgorithmIdentifier keyEncryptionAlgID, SecretKey symmetricKey, byte[] keyIdentifier, Date keyDate, ASN1Sequence otherKeyAttribute) throws InvalidInputException {
        this.keyEncryptionAlgID = keyEncryptionAlgID;
        this.symmetricKey = symmetricKey;
        this.keyIdentifier = keyIdentifier;
        this.keyDate = keyDate;
        this.otherKeyAttribute = otherKeyAttribute;
        if (otherKeyAttribute != null) {
            if (otherKeyAttribute.size() < 1) {
                throw new InvalidInputException("otherKeyAttribute MUST contains atleast 1 element");
            }
            if (!(otherKeyAttribute.elementAt(0) instanceof ASN1ObjectID)) {
                throw new InvalidInputException("first element of otherKeyAttribute MUST be an OBJECT IDENTIFIER");
            }
        }
    }

    CMSKEKRecipientInfoSpec(AlgorithmIdentifier keyEncryptionAlgID, byte[] encryptedKey) {
        this(keyEncryptionAlgID, encryptedKey, null);
    }

    CMSKEKRecipientInfoSpec(AlgorithmIdentifier keyEncryptionAlgID, byte[] encryptedKey, String AlgoName) {
        this.keyEncryptionAlgID = keyEncryptionAlgID;
        this.encryptedKey = encryptedKey;
        this.encryptedKeyAlgo = AlgoName;
    }

    public void setKeyIdentifier(byte[] keyIdentifier) {
        this.keyIdentifier = keyIdentifier;
    }

    public byte[] getKeyIdentifier() {
        return this.keyIdentifier;
    }

    public void setKeyDate(Date keyDate) {
        this.keyDate = keyDate;
    }

    public Date getKeyDate() {
        return this.keyDate;
    }

    public void setOtherKeyAttribute(ASN1Sequence otherKeyAttribute) throws InvalidInputException {
        if (otherKeyAttribute.size() < 1) {
            throw new InvalidInputException("otherKeyAttribute MUST contains atleast 1 element");
        }
        if (!(otherKeyAttribute.elementAt(0) instanceof ASN1ObjectID)) {
            throw new InvalidInputException("first element of otherKeyAttribute MUST be an OBJECT IDENTIFIER");
        }
        this.otherKeyAttribute = otherKeyAttribute;
    }

    public ASN1Sequence getOtherKeyAttribute() {
        return this.otherKeyAttribute;
    }

    public AlgorithmIdentifier getKeyEncryptionAlgID() {
        return this.keyEncryptionAlgID;
    }

    public SecretKey getSymmetricKey() {
        return this.symmetricKey;
    }

    byte[] getEncryptedKey() {
        return this.encryptedKey;
    }

    String getAlgoName() {
        return this.encryptedKeyAlgo;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof CMSKEKRecipientInfoSpec)) {
            return false;
        }
        return obj.hashCode() == this.hashCode();
    }

    public int hashCode() {
        ASN1Sequence kekId = new ASN1Sequence();
        kekId.addElement((ASN1Object)new ASN1OctetString(this.keyIdentifier));
        if (this.keyDate != null) {
            kekId.addElement((ASN1Object)new ASN1Date(this.keyDate, true));
        }
        if (this.otherKeyAttribute != null) {
            kekId.addElement((ASN1Object)this.otherKeyAttribute);
        }
        return new String(Utils.toBytes((Streamable)kekId)).hashCode();
    }
}

