/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cms;

import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.cert.AttributeSet;
import oracle.security.crypto.cms.CMS;
import oracle.security.crypto.cms.CMSEnvelopedDataOutputStream;
import oracle.security.crypto.cms.CMSOutputConnector;
import oracle.security.crypto.cms.OriginatorInfo;
import oracle.security.crypto.core.AlgorithmIdentifier;

public class CMSEnvelopedDataOutputConnector
implements CMSOutputConnector {
    private CMSEnvelopedDataOutputStream edOut;

    public CMSEnvelopedDataOutputConnector(OutputStream out, ASN1ObjectID enclosedContentType, AlgorithmIdentifier contentEncryptionAlgID, Vector recipients) throws NoSuchAlgorithmException {
        this.edOut = new CMSEnvelopedDataOutputStream(out, enclosedContentType, contentEncryptionAlgID, recipients);
    }

    public CMSEnvelopedDataOutputConnector(OutputStream out, ASN1ObjectID enclosedContentType, AlgorithmIdentifier contentEncryptionAlgID, Vector recipients, boolean writeContent, OriginatorInfo origInfo, AttributeSet unprotectedAttribs) throws NoSuchAlgorithmException {
        this.edOut = new CMSEnvelopedDataOutputStream(out, enclosedContentType, contentEncryptionAlgID, recipients, writeContent, origInfo, unprotectedAttribs);
    }

    public CMSEnvelopedDataOutputConnector(CMSOutputConnector conn, ASN1ObjectID enclosedContentType, AlgorithmIdentifier contentEncryptionAlgID, Vector recipients, boolean writeContent) throws NoSuchAlgorithmException {
        this.edOut = new CMSEnvelopedDataOutputStream(conn, enclosedContentType, contentEncryptionAlgID, recipients, writeContent);
    }

    public CMSEnvelopedDataOutputConnector(CMSOutputConnector conn, ASN1ObjectID enclosedContentType, AlgorithmIdentifier contentEncryptionAlgID, Vector recipients, boolean writeContent, OriginatorInfo origInfo, AttributeSet unprotectedAttribs) throws NoSuchAlgorithmException {
        this.edOut = new CMSEnvelopedDataOutputStream(conn, enclosedContentType, contentEncryptionAlgID, recipients, writeContent, origInfo, unprotectedAttribs);
    }

    @Override
    public ASN1ObjectID getExposedContentType() {
        return CMS.id_envelopedData;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.edOut;
    }
}

