/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cms;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import oracle.security.crypto.asn1.ASN1ConstructedInputStream;
import oracle.security.crypto.asn1.ASN1Integer;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.asn1.ASN1SetInputStream;
import oracle.security.crypto.cert.AttributeSet;
import oracle.security.crypto.cert.IssuerAndSerialNo;
import oracle.security.crypto.cert.X509;
import oracle.security.crypto.cms.CMS;
import oracle.security.crypto.cms.CMSInputConnector;
import oracle.security.crypto.cms.CMSInputStream;
import oracle.security.crypto.cms.CMSKEKRecipientInfo;
import oracle.security.crypto.cms.CMSKeyTransRecipientInfo;
import oracle.security.crypto.cms.CMSRecipientInfo;
import oracle.security.crypto.cms.CMSUtils;
import oracle.security.crypto.cms.ECIInputStream;
import oracle.security.crypto.cms.OriginatorInfo;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.crypto.util.Utils;
import oracle.security.crypto.util.VersionException;

public class CMSEnvelopedDataInputStream
extends CMSInputStream {
    private final boolean readingFromConnector;
    private PrivateKey recipientPrivateKey;
    private SecretKey keyEncryptionKey;
    private IssuerAndSerialNo recipientIASN;
    private ASN1ObjectID enclosedContentType = CMS.id_data;
    private OriginatorInfo origInfo;
    private AttributeSet unprotectedAttribs;
    private ASN1Integer version;
    private byte[] recipientSPKI64;
    private byte[] recipientSPKI160;
    private boolean readInitial = false;
    private boolean terminated = false;
    private ASN1ConstructedInputStream ci_in;
    private ASN1ConstructedInputStream cic_in;
    private ASN1ConstructedInputStream ed_in;
    private ECIInputStream eci_in;
    private ASN1SequenceInputStream i_in;
    private ASN1ObjectID contentType;
    private AlgorithmIdentifier cEncryptionAlgID;

    public CMSEnvelopedDataInputStream(InputStream in, PrivateKey recipientPrivateKey, X509Certificate recipientCert) throws NoSuchAlgorithmException, CertificateEncodingException, IOException {
        super(in);
        this.recipientPrivateKey = recipientPrivateKey;
        this.recipientIASN = new IssuerAndSerialNo(new X509(recipientCert.getEncoded()));
        this.recipientSPKI64 = CMSUtils.generateSPKI64(recipientCert);
        this.recipientSPKI160 = CMSUtils.generateSPKI160(recipientCert);
        this.readingFromConnector = false;
    }

    public CMSEnvelopedDataInputStream(CMSInputConnector conn, PrivateKey recipientPrivateKey, X509Certificate recipientCert) throws IOException, NoSuchAlgorithmException, CertificateEncodingException {
        super(conn.getInputStream());
        this.recipientPrivateKey = recipientPrivateKey;
        this.recipientIASN = new IssuerAndSerialNo(new X509(recipientCert.getEncoded()));
        this.recipientSPKI64 = CMSUtils.generateSPKI64(recipientCert);
        this.recipientSPKI160 = CMSUtils.generateSPKI160(recipientCert);
        this.readingFromConnector = true;
    }

    public CMSEnvelopedDataInputStream(InputStream in, SecretKey keyEncryptionKey) {
        super(in);
        this.keyEncryptionKey = keyEncryptionKey;
        this.readingFromConnector = false;
    }

    public CMSEnvelopedDataInputStream(CMSInputConnector conn, SecretKey keyEncryptionKey) {
        super(conn.getInputStream());
        this.keyEncryptionKey = keyEncryptionKey;
        this.readingFromConnector = true;
    }

    private void ensureReadInitial() throws IOException {
        if (!this.readInitial) {
            if (!this.readingFromConnector) {
                this.ci_in = new ASN1SequenceInputStream(this.in);
                if (!CMS.id_envelopedData.equals((Object)new ASN1ObjectID((InputStream)this.ci_in))) {
                    throw new InvalidInputException("Content-type 'envelopedData' expected.");
                }
                this.cic_in = new ASN1ConstructedInputStream((InputStream)this.ci_in, 0);
                this.ed_in = new ASN1SequenceInputStream((InputStream)this.cic_in);
            } else {
                this.ed_in = new ASN1SequenceInputStream(this.in);
            }
            this.version = new ASN1Integer((InputStream)this.ed_in);
            if (!this.version.equals(0) && !this.version.equals(2)) {
                throw new VersionException("Expected Version 0 or 2 but Got " + this.version.getValue());
            }
            if (this.ed_in.getCurrentTag() == 0) {
                this.ed_in.setCurrentTag(16);
                this.origInfo = new OriginatorInfo((InputStream)this.ed_in);
            }
            byte[] contentEncryptionKeyBytes = null;
            try {
                boolean foundRecipient = false;
                ASN1SetInputStream ris = new ASN1SetInputStream((InputStream)this.ed_in);
                do {
                    if (!ris.hasMoreData()) {
                        throw new InvalidInputException("Recipient not found.");
                    }
                    CMSRecipientInfo ri = CMSRecipientInfo.inputInstance((InputStream)ris);
                    if (ri instanceof CMSKeyTransRecipientInfo) {
                        CMSKeyTransRecipientInfo ktri = (CMSKeyTransRecipientInfo)ri;
                        if (ktri.getSPKI() == null) {
                            if (ktri.getIASN().equals((Object)this.recipientIASN) && this.recipientPrivateKey != null) {
                                ris.terminate(true);
                                this.i_in = new ASN1SequenceInputStream((InputStream)this.ed_in);
                                this.contentType = new ASN1ObjectID((InputStream)this.i_in);
                                this.cEncryptionAlgID = new AlgorithmIdentifier((InputStream)this.i_in);
                                contentEncryptionKeyBytes = ktri.getContentEncryptionKey(this.recipientPrivateKey, CMSUtils.getAlgoName(this.cEncryptionAlgID, true));
                                foundRecipient = true;
                            }
                        } else if (Utils.toHexString((byte[])ktri.getSPKI()).equals(Utils.toHexString((byte[])this.recipientSPKI64))) {
                            if (this.recipientPrivateKey != null) {
                                ris.terminate(true);
                                this.i_in = new ASN1SequenceInputStream((InputStream)this.ed_in);
                                this.contentType = new ASN1ObjectID((InputStream)this.i_in);
                                this.cEncryptionAlgID = new AlgorithmIdentifier((InputStream)this.i_in);
                                contentEncryptionKeyBytes = ktri.getContentEncryptionKey(this.recipientPrivateKey, CMSUtils.getAlgoName(this.cEncryptionAlgID, true));
                                foundRecipient = true;
                            }
                        } else if (Utils.toHexString((byte[])ktri.getSPKI()).equals(Utils.toHexString((byte[])this.recipientSPKI160)) && this.recipientPrivateKey != null) {
                            ris.terminate(true);
                            this.i_in = new ASN1SequenceInputStream((InputStream)this.ed_in);
                            this.contentType = new ASN1ObjectID((InputStream)this.i_in);
                            this.cEncryptionAlgID = new AlgorithmIdentifier((InputStream)this.i_in);
                            contentEncryptionKeyBytes = ktri.getContentEncryptionKey(this.recipientPrivateKey, CMSUtils.getAlgoName(this.cEncryptionAlgID, true));
                            foundRecipient = true;
                        }
                        if (!foundRecipient) continue;
                        this.eci_in = new ECIInputStream(this.i_in, contentEncryptionKeyBytes, this.contentType, this.cEncryptionAlgID);
                        continue;
                    }
                    if (!(ri instanceof CMSKEKRecipientInfo)) continue;
                    CMSKEKRecipientInfo kekri = (CMSKEKRecipientInfo)ri;
                    if (this.keyEncryptionKey != null) {
                        SecretKey contentEncryptionKey = null;
                        contentEncryptionKey = kekri.getContentEncryptionKey(this.keyEncryptionKey);
                        contentEncryptionKeyBytes = contentEncryptionKey.getEncoded();
                        foundRecipient = true;
                        ris.terminate(true);
                    }
                    this.eci_in = new ECIInputStream((InputStream)this.ed_in, contentEncryptionKeyBytes);
                } while (!foundRecipient);
            }
            catch (InvalidKeyException ex) {
                throw new InvalidInputException((Exception)ex);
            }
            catch (NoSuchPaddingException ex) {
                throw new InvalidInputException((Exception)ex);
            }
            catch (NoSuchAlgorithmException ex) {
                throw new InvalidInputException((Exception)ex);
            }
            catch (IllegalBlockSizeException ex) {
                throw new InvalidInputException((Exception)ex);
            }
            catch (BadPaddingException ex) {
                throw new InvalidInputException((Exception)ex);
            }
            catch (InvalidAlgorithmParameterException ex) {
                throw new InvalidInputException((Exception)ex);
            }
            catch (InvalidKeySpecException ex) {
                throw new InvalidInputException((Exception)ex);
            }
            this.readInitial = true;
        }
    }

    private void ensureTerminated() throws IOException {
        if (!this.terminated) {
            if (this.ed_in.hasMoreData()) {
                if (this.ed_in.getCurrentTag() == 1) {
                    this.ed_in.setCurrentTag(17);
                    this.unprotectedAttribs = new AttributeSet((InputStream)this.ed_in);
                } else {
                    throw new InvalidInputException("Expected Unauthenticated Attributes[1] but got " + this.ed_in.getCurrentTag());
                }
            }
            this.ed_in.terminate();
            if (!this.readingFromConnector) {
                this.cic_in.terminate();
                this.ci_in.terminate();
            }
            this.terminated = true;
        }
    }

    @Override
    public void terminate() throws IOException {
        this.ensureTerminated();
    }

    @Override
    public int read() throws IOException {
        this.ensureReadInitial();
        int ch = this.eci_in.read();
        if (ch == -1) {
            this.ensureTerminated();
        }
        return ch;
    }

    @Override
    public int read(byte[] buffer, int offset, int len) throws IOException {
        this.ensureReadInitial();
        int efflen = this.eci_in.read(buffer, offset, len);
        if (efflen == -1) {
            this.ensureTerminated();
        }
        return efflen;
    }

    @Override
    public int available() throws IOException {
        this.ensureReadInitial();
        return this.eci_in.available();
    }

    @Override
    public long skip(long n) throws IOException {
        this.ensureReadInitial();
        return this.eci_in.skip(n);
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void mark(int readlimit) {
    }

    @Override
    public void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }

    public BigInteger getVersionNumber() throws IOException {
        this.ensureReadInitial();
        return this.version.getValue();
    }

    public ASN1Integer getVersion() throws IOException {
        this.ensureReadInitial();
        return this.version;
    }

    public OriginatorInfo getOrginatorInfo() throws IOException {
        this.ensureReadInitial();
        return this.origInfo;
    }

    public AttributeSet getUnprotectedAttribs() throws IOException {
        this.ensureTerminated();
        return this.unprotectedAttribs;
    }

    @Override
    public ASN1ObjectID getEnclosedContentType() throws IOException {
        this.ensureReadInitial();
        return this.eci_in.getContentType();
    }

    public AlgorithmIdentifier getContentEncryptionAlgID() throws IOException {
        this.ensureReadInitial();
        return this.eci_in.getContentEncryptionAlgID();
    }
}

