/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cms;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import oracle.security.crypto.asn1.ASN1Integer;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1OctetString;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.cms.CMS;
import oracle.security.crypto.cms.CMSContentInfo;
import oracle.security.crypto.cms.CMSUtils;
import oracle.security.crypto.cms.EncapsulatedContentInfo;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.AuthenticationException;
import oracle.security.crypto.util.FixedByteArrayOutputStream;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.StreamableOutputException;
import oracle.security.crypto.util.UnsyncByteArrayOutputStream;
import oracle.security.crypto.util.Utils;
import oracle.security.crypto.util.VersionException;

public class CMSDigestedDataContentInfo
extends CMSContentInfo {
    private AlgorithmIdentifier digestAlgID;
    private CMSContentInfo contentInfo;
    private byte[] digest;
    private ASN1Integer version;
    private boolean writeDetached = false;
    private byte[] exposedContent = null;

    public CMSDigestedDataContentInfo() {
        super(CMS.id_digestedData);
    }

    public CMSDigestedDataContentInfo(CMSContentInfo contentInfo, AlgorithmIdentifier digestAlgID) throws NoSuchAlgorithmException {
        super(CMS.id_digestedData);
        if (contentInfo == null) {
            throw new IllegalArgumentException("Null Content Info");
        }
        this.contentInfo = contentInfo;
        this.digestAlgID = digestAlgID;
        MessageDigest md = MessageDigest.getInstance(CMSUtils.getAlgoName(digestAlgID));
        this.digest = contentInfo.computeDigest(md);
        this.version = contentInfo.getContentType().equals((Object)CMS.id_data) ? new ASN1Integer(0L) : new ASN1Integer(2L);
    }

    public CMSDigestedDataContentInfo(CMSContentInfo contentInfo, AlgorithmIdentifier digestAlgID, byte[] digest) {
        super(CMS.id_digestedData);
        if (contentInfo == null) {
            throw new IllegalArgumentException("Null Content Info");
        }
        this.contentInfo = contentInfo;
        this.digestAlgID = digestAlgID;
        if (digest == null) {
            throw new IllegalArgumentException("Null Pre-Computed Digest Value");
        }
        this.digest = digest;
        this.version = contentInfo.getContentType().equals((Object)CMS.id_data) ? new ASN1Integer(0L) : new ASN1Integer(2L);
    }

    public CMSDigestedDataContentInfo(InputStream is) throws IOException {
        super(CMS.id_digestedData);
        this.input(is);
    }

    @Override
    protected void setExposedContent(byte[] expContent) {
        this.exposedContent = expContent;
    }

    @Override
    protected byte[] getExposedContent() {
        if (this.exposedContent == null) {
            if (this.contentInfo == null) {
                return null;
            }
            try {
                UnsyncByteArrayOutputStream ddStore = new UnsyncByteArrayOutputStream();
                this.version.output((OutputStream)ddStore);
                this.digestAlgID.output((OutputStream)ddStore);
                new EncapsulatedContentInfo(this.contentInfo, !this.writeDetached).output((OutputStream)ddStore);
                ASN1OctetString.outputValue((OutputStream)ddStore, (byte[])this.digest);
                byte[] buf = ddStore.toByteArray();
                byte[] hdrbuf = Utils.toBytes((Streamable)ASN1Sequence.makeHeader((int)buf.length));
                FixedByteArrayOutputStream bos = new FixedByteArrayOutputStream(hdrbuf.length + buf.length);
                bos.write(hdrbuf, 0, hdrbuf.length);
                bos.write(buf, 0, buf.length);
                this.exposedContent = bos.toByteArray();
            }
            catch (IOException ex) {
                throw new StreamableOutputException(ex.toString());
            }
            catch (NullPointerException ex) {
                throw new StreamableOutputException("CMS Object is not initialized: " + ex.toString());
            }
        }
        return this.exposedContent;
    }

    public void writeDetached(boolean writeDetached) {
        this.writeDetached = writeDetached;
        this.update();
    }

    public void setEnclosed(CMSContentInfo content) {
        if (this.contentInfo == null) {
            throw new IllegalArgumentException("Null Content Info");
        }
        this.contentInfo = content;
        this.update();
    }

    public CMSContentInfo getEnclosed() {
        return this.contentInfo;
    }

    public ASN1ObjectID getEnclosedContentType() {
        return this.contentInfo.getContentType();
    }

    public AlgorithmIdentifier getDigestAlgID() {
        return this.digestAlgID;
    }

    public byte[] getDigest() {
        return this.digest;
    }

    public BigInteger getVersionNumber() {
        return this.version.getValue();
    }

    public ASN1Integer getVersion() {
        return this.version;
    }

    @Override
    public boolean isDetached() {
        if (this.contentInfo == null) {
            return true;
        }
        ASN1ObjectID cType = this.contentInfo.getContentType();
        if (cType.equals((Object)CMS.id_digestedData) || cType.equals((Object)CMS.id_signedData) || cType.equals((Object)CMS.id_ct_authData) || cType.equals((Object)CMS.id_encryptedData) || cType.equals((Object)CMS.id_envelopedData)) {
            return false;
        }
        return this.contentInfo.isDetached();
    }

    public String toString() {
        StringBuffer stbuf = new StringBuffer(32);
        stbuf.append("Version: " + this.version.intValue() + "\n");
        stbuf.append("DigestAlgID: " + this.digestAlgID.toString() + "\n");
        stbuf.append("Encapsulated Content-Type: " + this.contentInfo.getContentType() + "\n");
        if (this.isDetached()) {
            stbuf.append("detached CMS 'digestedData' object \n");
        } else {
            stbuf.append("CMS 'digestedData' object, encloses " + this.contentInfo.toString() + "\n");
        }
        stbuf.append("Digest: " + Utils.toHexString((byte[])this.digest));
        return stbuf.toString();
    }

    public int hashCode() {
        try {
            UnsyncByteArrayOutputStream bos = new UnsyncByteArrayOutputStream();
            this.output((OutputStream)bos);
            return new String(bos.toByteArray()).hashCode();
        }
        catch (IOException ex) {
            throw new StreamableOutputException(ex.toString());
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CMSDigestedDataContentInfo)) {
            return false;
        }
        return this.hashCode() == ((CMSDigestedDataContentInfo)obj).hashCode();
    }

    public void verify() throws AuthenticationException, NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance(CMSUtils.getAlgoName(this.digestAlgID));
        byte[] cDigest = this.contentInfo.computeDigest(md);
        if (!Utils.areEqual((byte[])cDigest, (byte[])this.digest)) {
            throw new AuthenticationException("Message digest is incorrect.");
        }
    }

    @Override
    protected void inputContent(InputStream is) throws IOException {
        ASN1SequenceInputStream dd = new ASN1SequenceInputStream(is);
        this.version = new ASN1Integer((InputStream)dd);
        if (this.version.equals(0) || this.version.equals(2)) {
            this.digestAlgID = new AlgorithmIdentifier((InputStream)dd);
            EncapsulatedContentInfo encap_info = new EncapsulatedContentInfo((InputStream)dd);
            this.contentInfo = encap_info.getCMSContentInfo();
            this.digest = new ASN1OctetString((InputStream)dd).getValue();
            dd.terminate();
            if (this.contentInfo.getContentType().equals((Object)CMS.id_data) && !this.version.equals(0)) {
                throw new VersionException("Expected Version 0 for id-data content type but got Version " + this.version.getValue());
            }
            if (!this.contentInfo.getContentType().equals((Object)CMS.id_data) && !this.version.equals(2)) {
                throw new VersionException("Expected Version 2 for non id-data content type but got Version " + this.version.getValue());
            }
            if (this.contentInfo.isDetached()) {
                this.writeDetached = true;
            }
        } else {
            throw new VersionException("Expected Version 0 or 2 but got Version " + this.version.getValue());
        }
    }

    @Override
    protected void update() {
        super.update();
        this.exposedContent = null;
    }
}

