/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cms;

import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.util.Vector;
import javax.crypto.SecretKey;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.cert.AttributeSet;
import oracle.security.crypto.cms.CMS;
import oracle.security.crypto.cms.CMSAuthenticatedDataOutputStream;
import oracle.security.crypto.cms.CMSOutputConnector;
import oracle.security.crypto.cms.OriginatorInfo;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.util.InvalidInputException;

public class CMSAuthenticatedDataOutputConnector
implements CMSOutputConnector {
    private CMSAuthenticatedDataOutputStream authOut;

    public CMSAuthenticatedDataOutputConnector(OutputStream out, Vector recipients, AlgorithmIdentifier macAlgorithm, ASN1ObjectID encapContentType, SecretKey hmacKey, boolean detachEncapContent) throws NoSuchAlgorithmException, InvalidInputException {
        this(out, null, recipients, macAlgorithm, null, encapContentType, null, null, hmacKey, detachEncapContent);
    }

    public CMSAuthenticatedDataOutputConnector(OutputStream out, OriginatorInfo origInfo, Vector recipients, AlgorithmIdentifier macAlgorithm, AlgorithmIdentifier digestAlgID, ASN1ObjectID encapContentType, AttributeSet authenticatedAttribs, AttributeSet unauthenticatedAttribs, SecretKey hmacKey, boolean detachEncapContent) throws NoSuchAlgorithmException, InvalidInputException {
        this.authOut = new CMSAuthenticatedDataOutputStream(out, origInfo, recipients, macAlgorithm, digestAlgID, encapContentType, authenticatedAttribs, unauthenticatedAttribs, hmacKey, detachEncapContent);
    }

    public CMSAuthenticatedDataOutputConnector(CMSOutputConnector conn, Vector recipients, AlgorithmIdentifier macAlgorithm, ASN1ObjectID encapContentType, SecretKey hmacKey, boolean detachEncapContent) throws NoSuchAlgorithmException, InvalidInputException {
        this(conn, null, recipients, macAlgorithm, null, encapContentType, null, null, hmacKey, detachEncapContent);
    }

    public CMSAuthenticatedDataOutputConnector(CMSOutputConnector conn, OriginatorInfo origInfo, Vector recipients, AlgorithmIdentifier macAlgorithm, AlgorithmIdentifier digestAlgID, ASN1ObjectID encapContentType, AttributeSet authenticatedAttribs, AttributeSet unauthenticatedAttribs, SecretKey hmacKey, boolean detachEncapContent) throws NoSuchAlgorithmException, InvalidInputException {
        this.authOut = new CMSAuthenticatedDataOutputStream(conn, origInfo, recipients, macAlgorithm, digestAlgID, encapContentType, authenticatedAttribs, unauthenticatedAttribs, hmacKey, detachEncapContent);
    }

    @Override
    public ASN1ObjectID getExposedContentType() {
        return CMS.id_ct_authData;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.authOut;
    }
}

