/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cms;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import oracle.security.crypto.asn1.ASN1GenericConstructed;
import oracle.security.crypto.asn1.ASN1Integer;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1OctetString;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.asn1.ASN1Set;
import oracle.security.crypto.asn1.ASN1SetInputStream;
import oracle.security.crypto.asn1.ASN1Utils;
import oracle.security.crypto.cert.AttributeSet;
import oracle.security.crypto.cert.IssuerAndSerialNo;
import oracle.security.crypto.cert.X509;
import oracle.security.crypto.cms.CMS;
import oracle.security.crypto.cms.CMSContentInfo;
import oracle.security.crypto.cms.CMSKEKRecipientInfo;
import oracle.security.crypto.cms.CMSKEKRecipientInfoSpec;
import oracle.security.crypto.cms.CMSKeyTransRecipientInfo;
import oracle.security.crypto.cms.CMSKeyTransRecipientInfoSpec;
import oracle.security.crypto.cms.CMSRecipientInfo;
import oracle.security.crypto.cms.CMSRecipientInfoSpec;
import oracle.security.crypto.cms.CMSUtils;
import oracle.security.crypto.cms.EncapsulatedContentInfo;
import oracle.security.crypto.cms.EncryptedContentInfo;
import oracle.security.crypto.cms.OriginatorInfo;
import oracle.security.crypto.cms.UnknownRecipientException;
import oracle.security.crypto.core.AlgID;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.AuthenticationException;
import oracle.security.crypto.util.FixedByteArrayOutputStream;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.StreamableOutputException;
import oracle.security.crypto.util.UnsyncByteArrayOutputStream;
import oracle.security.crypto.util.Utils;
import oracle.security.crypto.util.VersionException;

public class CMSAuthenticatedDataContentInfo
extends CMSContentInfo {
    private EncryptedContentInfo eci;
    private Hashtable recipTable;
    private byte[] contentAuthenticationKeyBytes;
    private String contentAuthenticationAlgoName;
    private byte[] exposedContent = null;
    private ASN1Integer version;
    private OriginatorInfo originatorInfo;
    private AlgorithmIdentifier digestAlgID;
    private AlgorithmIdentifier macAlgID;
    private CMSContentInfo contentInfo;
    private AttributeSet authenticatedAttributes;
    private byte[] mac;
    private AttributeSet unauthenticatedAttributes;
    private boolean writeDetachedObject = false;

    public CMSAuthenticatedDataContentInfo() {
        super(CMS.id_ct_authData);
    }

    public CMSAuthenticatedDataContentInfo(CMSContentInfo contentInfo, SecretKey hmacKey, AlgorithmIdentifier macAlgorithm) throws InvalidInputException, NoSuchAlgorithmException, InvalidKeySpecException, InvalidKeyException {
        this(contentInfo, hmacKey, null, macAlgorithm, null, null, null);
    }

    public CMSAuthenticatedDataContentInfo(CMSContentInfo contentInfo, SecretKey hmacKey, OriginatorInfo originatorInfo, AlgorithmIdentifier macAlgorithm, AlgorithmIdentifier digestAlgorithm, AttributeSet authenticatedAttributes, AttributeSet unauthenticatedAttributes) throws InvalidInputException, NoSuchAlgorithmException, InvalidKeySpecException, InvalidKeyException {
        this(contentInfo, hmacKey, hmacKey.getAlgorithm(), originatorInfo, macAlgorithm, digestAlgorithm, authenticatedAttributes, unauthenticatedAttributes);
    }

    public CMSAuthenticatedDataContentInfo(CMSContentInfo contentInfo, SecretKey hmacKey, String hmacKeyAlgo, OriginatorInfo originatorInfo, AlgorithmIdentifier macAlgorithm, AlgorithmIdentifier digestAlgorithm, AttributeSet authenticatedAttributes, AttributeSet unauthenticatedAttributes) throws InvalidInputException, NoSuchAlgorithmException, InvalidKeySpecException, InvalidKeyException {
        super(CMS.id_ct_authData);
        this.version = new ASN1Integer(0L);
        this.originatorInfo = originatorInfo;
        this.macAlgID = macAlgorithm;
        this.digestAlgID = digestAlgorithm;
        this.authenticatedAttributes = authenticatedAttributes;
        this.unauthenticatedAttributes = unauthenticatedAttributes;
        this.contentInfo = contentInfo;
        if (this.digestAlgID != null && authenticatedAttributes == null || authenticatedAttributes != null && this.digestAlgID == null) {
            throw new InvalidInputException("Expected both Digest Algorithm and AuthenticatedAttributes");
        }
        if (!contentInfo.getContentType().equals((Object)CMS.id_data) && authenticatedAttributes == null) {
            throw new InvalidInputException("Authenticated Content is not id-data: AuthenticatedAttributes MUST be present");
        }
        if (hmacKeyAlgo.equals("DESede/CBC/NoPadding")) {
            CMSUtils.setKeyParity(hmacKey, 1);
        }
        this.contentAuthenticationKeyBytes = hmacKey.getEncoded();
        this.contentAuthenticationAlgoName = hmacKeyAlgo;
        if (authenticatedAttributes != null) {
            MessageDigest md = MessageDigest.getInstance(CMSUtils.getAlgoName(this.digestAlgID));
            byte[] dig = contentInfo.computeDigest(md);
            authenticatedAttributes.addAttribute(CMS.id_contentType, (ASN1Object)contentInfo.getContentType());
            authenticatedAttributes.addAttribute(CMS.id_messageDigest, (ASN1Object)new ASN1OctetString(dig));
        }
        this.recipTable = new Hashtable();
        try {
            this.mac = this.calculateMAC();
        }
        catch (AuthenticationException ex) {
            throw new InvalidInputException(ex.toString());
        }
    }

    public CMSAuthenticatedDataContentInfo(InputStream is) throws IOException {
        super(CMS.id_ct_authData);
        this.input(is);
    }

    private byte[] calculateMAC() throws AuthenticationException, NoSuchAlgorithmException, InvalidKeyException, InvalidKeySpecException {
        byte[] digest;
        if (this.digestAlgID != null) {
            MessageDigest md = MessageDigest.getInstance(CMSUtils.getAlgoName(this.digestAlgID));
            digest = this.contentInfo.computeDigest(md);
            AttributeSet aA = this.authenticatedAttributes;
            if (aA != null) {
                byte[] digest0;
                ASN1ObjectID announcedContentType;
                try {
                    Vector vals = this.authenticatedAttributes.getAttributeValues(CMS.id_contentType);
                    if (vals == null) {
                        throw new AuthenticationException("The 'contentType' attribute is missing");
                    }
                    if (vals.size() != 1) {
                        throw new AuthenticationException("The 'contentType' attribute is not single valued");
                    }
                    announcedContentType = (ASN1ObjectID)vals.elementAt(0);
                }
                catch (ClassCastException ex) {
                    throw new AuthenticationException("The value of the 'contentType' attribute has the wrong type");
                }
                if (!announcedContentType.equals((Object)this.contentInfo.getContentType())) {
                    throw new AuthenticationException("The value of the 'contentType' attribute is incorrect");
                }
                try {
                    Vector vals = this.authenticatedAttributes.getAttributeValues(CMS.id_messageDigest);
                    if (vals == null) {
                        throw new AuthenticationException("The 'messageDigest' attribute is missing");
                    }
                    if (vals.size() != 1) {
                        throw new AuthenticationException("The 'messageDigest' attribute is not single valued");
                    }
                    digest0 = ((ASN1OctetString)vals.elementAt(0)).getValue();
                }
                catch (ClassCastException ex) {
                    throw new AuthenticationException("The value of the 'messageDigest' attribute has the wrong type");
                }
                if (!Utils.areEqual((byte[])digest, (byte[])digest0)) {
                    throw new AuthenticationException("The value of the 'messageDigest' attribute is incorrect");
                }
                digest = MessageDigest.getInstance(CMSUtils.getAlgoName(this.digestAlgID)).digest(Utils.toBytes((Streamable)aA));
            }
        } else {
            digest = this.contentInfo.getExposedContent();
            if (digest == null) {
                digest = new byte[]{};
            }
        }
        AlgorithmIdentifier hmacDigest = null;
        if (this.macAlgID.equals((Object)CMS.hmac_SHA_1)) {
            hmacDigest = AlgID.sha_1;
        } else {
            new NoSuchAlgorithmException("unsupported HMAC Algorithm: " + this.macAlgID);
        }
        SecretKeySpec secretKey = new SecretKeySpec(this.contentAuthenticationKeyBytes, CMSUtils.getAlgoName(this.macAlgID));
        Mac mac = Mac.getInstance("Hmac" + CMSUtils.getAlgoName(hmacDigest));
        mac.init(secretKey);
        byte[] hashedMac = mac.doFinal(digest);
        return hashedMac;
    }

    @Override
    public boolean isDetached() {
        if (this.contentInfo == null) {
            return true;
        }
        ASN1ObjectID cType = this.contentInfo.getContentType();
        if (cType.equals((Object)CMS.id_digestedData) || cType.equals((Object)CMS.id_signedData) || cType.equals((Object)CMS.id_ct_authData) || cType.equals((Object)CMS.id_encryptedData) || cType.equals((Object)CMS.id_envelopedData)) {
            return false;
        }
        return this.contentInfo.isDetached();
    }

    public void writeDetached(boolean writeDetachedObject) {
        this.writeDetachedObject = writeDetachedObject;
        this.update();
    }

    @Override
    protected void setExposedContent(byte[] expContent) {
        this.exposedContent = expContent;
    }

    @Override
    protected byte[] getExposedContent() {
        if (this.exposedContent == null) {
            if (this.contentInfo == null) {
                return null;
            }
            try {
                UnsyncByteArrayOutputStream adStore = new UnsyncByteArrayOutputStream();
                this.version.output((OutputStream)adStore);
                if (this.originatorInfo != null) {
                    ((ASN1GenericConstructed)ASN1Utils.addImplicitTag((ASN1Object)this.originatorInfo, (int)0)).output((OutputStream)adStore);
                }
                ASN1Set recipInfoSet = new ASN1Set();
                Enumeration enr = this.recipTable.elements();
                while (enr != null && enr.hasMoreElements()) {
                    ASN1Integer ver;
                    CMSRecipientInfo rcp = (CMSRecipientInfo)enr.nextElement();
                    if (rcp instanceof CMSKeyTransRecipientInfo) {
                        ver = new ASN1Integer(((CMSKeyTransRecipientInfo)rcp).getVersionNumber());
                        if (ver.equals(0) || ver.equals(2)) {
                            recipInfoSet.addElement((ASN1Object)((CMSKeyTransRecipientInfo)rcp));
                            continue;
                        }
                        throw new IOException("Version 0/2 but Not KeyTransportRecipientInfo");
                    }
                    if (rcp instanceof CMSKEKRecipientInfo) {
                        ver = new ASN1Integer(((CMSKEKRecipientInfo)rcp).getVersionNumber());
                        if (ver.equals(4)) {
                            recipInfoSet.addElement((ASN1Object)((ASN1GenericConstructed)ASN1Utils.addImplicitTag((ASN1Object)((CMSKEKRecipientInfo)rcp), (int)2)));
                            continue;
                        }
                        throw new IOException("Version 4 but Not KEKRecipientInfo");
                    }
                    throw new IOException("Unknown/Invalid RecipientInfo ");
                }
                recipInfoSet.output((OutputStream)adStore);
                this.macAlgID.output((OutputStream)adStore);
                if (this.digestAlgID != null) {
                    ((ASN1GenericConstructed)ASN1Utils.addImplicitTag((ASN1Object)this.digestAlgID, (int)1)).output((OutputStream)adStore);
                }
                new EncapsulatedContentInfo(this.contentInfo, !this.writeDetachedObject).output((OutputStream)adStore);
                if (this.authenticatedAttributes != null) {
                    ((ASN1GenericConstructed)ASN1Utils.addImplicitTag((ASN1Object)this.authenticatedAttributes, (int)2)).output((OutputStream)adStore);
                }
                new ASN1OctetString(this.mac).output((OutputStream)adStore);
                if (this.unauthenticatedAttributes != null) {
                    ((ASN1GenericConstructed)ASN1Utils.addImplicitTag((ASN1Object)this.unauthenticatedAttributes, (int)3)).output((OutputStream)adStore);
                }
                byte[] buf = adStore.toByteArray();
                byte[] hdrbuf = Utils.toBytes((Streamable)ASN1Sequence.makeHeader((int)buf.length));
                FixedByteArrayOutputStream bos = new FixedByteArrayOutputStream(hdrbuf.length + buf.length);
                bos.write(hdrbuf, 0, hdrbuf.length);
                bos.write(buf, 0, buf.length);
                this.exposedContent = bos.toByteArray();
            }
            catch (IOException ex) {
                throw new StreamableOutputException(ex.toString());
            }
        }
        return this.exposedContent;
    }

    public BigInteger getVersionNumber() {
        return this.version.getValue();
    }

    public ASN1Integer getVersion() {
        return this.version;
    }

    public OriginatorInfo getOriginatorInfo() {
        return this.originatorInfo;
    }

    public AlgorithmIdentifier getMACAlgID() {
        return this.macAlgID;
    }

    public AlgorithmIdentifier getDigestAlgID() {
        return this.digestAlgID;
    }

    public ASN1ObjectID getEnclosedContentType() {
        return this.contentInfo.getContentType();
    }

    public CMSContentInfo getEnclosed() {
        return this.contentInfo;
    }

    public void setEnclosed(CMSContentInfo content) {
        this.contentInfo = content;
        this.update();
    }

    public byte[] getMAC() {
        return this.mac;
    }

    public AttributeSet getAuthenticatedAttributes() {
        return this.authenticatedAttributes;
    }

    public AttributeSet getUnauthenticatedAttributes() {
        return this.unauthenticatedAttributes;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Version: " + this.version.intValue() + "\n");
        sb.append("OriginatorInfo: " + (this.originatorInfo == null ? "Missing\n" : "Present\n"));
        if (this.isDetached()) {
            sb.append("degenerate CMS 'authenticatedData' object\n");
        } else {
            sb.append("CMS 'authenticatededData' object, encloses " + this.contentInfo + ", " + Utils.plural((int)this.recipTable.size(), (String)"recipient") + "\n");
        }
        Enumeration e = this.recipTable.elements();
        while (e.hasMoreElements()) {
            CMSRecipientInfo r = (CMSRecipientInfo)e.nextElement();
            sb.append("RecipientInfo: " + r.toString() + "\n");
        }
        sb.append("MAC Algorithm:" + this.macAlgID + "\n");
        sb.append("Digest Algorithm: " + (this.digestAlgID == null ? "Missing\n" : this.digestAlgID + "\n"));
        sb.append("AuthenticatedAttributes: " + (this.authenticatedAttributes == null ? "Missing\n" : this.authenticatedAttributes + "\n"));
        sb.append("MAC:" + Utils.toHexString((byte[])this.mac) + "\n");
        sb.append("UnauthenticatedAttributes: " + (this.unauthenticatedAttributes == null ? "Missing\n" : this.unauthenticatedAttributes + "\n"));
        return sb.toString();
    }

    public Enumeration recipients() {
        return this.recipTable.elements();
    }

    public void addRecipient(X509Certificate recipientCert, AlgorithmIdentifier keyEncryptionAlgID) throws InvalidKeyException, NoSuchPaddingException, NoSuchAlgorithmException, BadPaddingException, IllegalBlockSizeException, CertificateEncodingException, IOException {
        if (recipientCert == null) {
            throw new IllegalArgumentException("Null Recipient Certificate");
        }
        IssuerAndSerialNo iasn = new IssuerAndSerialNo(new X509(recipientCert.getEncoded()));
        this.recipTable.put(iasn, new CMSKeyTransRecipientInfo(this.contentAuthenticationKeyBytes, this.contentAuthenticationAlgoName, recipientCert.getPublicKey(), iasn, keyEncryptionAlgID));
        this.update();
    }

    public void addRecipient(X509Certificate recipientCert, AlgorithmIdentifier keyEncryptionAlgID, boolean useSPKI64) throws NoSuchAlgorithmException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException, NoSuchPaddingException {
        if (recipientCert == null) {
            throw new IllegalArgumentException("Null Recipient Certificate");
        }
        byte[] spki = null;
        spki = useSPKI64 ? CMSUtils.generateSPKI64(recipientCert) : CMSUtils.generateSPKI160(recipientCert);
        this.recipTable.put(Utils.toHexString((byte[])spki), new CMSKeyTransRecipientInfo(this.contentAuthenticationKeyBytes, this.contentAuthenticationAlgoName, recipientCert.getPublicKey(), spki, keyEncryptionAlgID));
        this.update();
    }

    public void addRecipient(CMSRecipientInfoSpec ris) throws InvalidInputException, InvalidKeyException, NoSuchPaddingException, NoSuchAlgorithmException, BadPaddingException, IllegalBlockSizeException, InvalidAlgorithmParameterException, InvalidKeySpecException {
        if (ris instanceof CMSKeyTransRecipientInfoSpec) {
            CMSKeyTransRecipientInfoSpec kt = (CMSKeyTransRecipientInfoSpec)ris;
            if (kt.getSPKI() == null) {
                this.recipTable.put(kt.getIASN(), new CMSKeyTransRecipientInfo(this.contentAuthenticationKeyBytes, this.contentAuthenticationAlgoName, kt.getRecipientKey(), kt.getIASN(), kt.getKeyEncryptionAlgID()));
            } else {
                this.recipTable.put(Utils.toHexString((byte[])kt.getSPKI()), new CMSKeyTransRecipientInfo(this.contentAuthenticationKeyBytes, this.contentAuthenticationAlgoName, kt.getRecipientKey(), kt.getSPKI(), kt.getKeyEncryptionAlgID()));
            }
        } else if (ris instanceof CMSKEKRecipientInfoSpec) {
            CMSKEKRecipientInfoSpec kek = (CMSKEKRecipientInfoSpec)ris;
            this.recipTable.put(kek, new CMSKEKRecipientInfo(this.contentAuthenticationKeyBytes, CMSUtils.getAlgoID(this.contentAuthenticationAlgoName), kek));
        } else {
            throw new InvalidInputException("Unrecognized CMSRecipientInfo Type");
        }
        this.update();
    }

    public void addRecipient(AlgorithmIdentifier keyEncryptionAlgID, SecretKey keyEncryptionKey, byte[] keyIdentifier, Date keyDate, ASN1Sequence otherKeyAttribute) throws InvalidKeyException, InvalidInputException, NoSuchAlgorithmException, BadPaddingException, IllegalBlockSizeException, NoSuchPaddingException, InvalidAlgorithmParameterException, InvalidKeySpecException {
        CMSKEKRecipientInfoSpec ri = new CMSKEKRecipientInfoSpec(keyEncryptionAlgID, keyEncryptionKey, keyIdentifier, keyDate, otherKeyAttribute);
        AlgorithmIdentifier contentAuthenticationAlgID = CMSUtils.getAlgoID(this.contentAuthenticationAlgoName);
        this.recipTable.put(ri, new CMSKEKRecipientInfo(this.contentAuthenticationKeyBytes, contentAuthenticationAlgID, ri));
        this.update();
    }

    public void verifyMAC(PrivateKey privateKey, X509Certificate recipientCert) throws InvalidKeyException, UnknownRecipientException, InvalidInputException, AuthenticationException, NoSuchAlgorithmException, NoSuchPaddingException, BadPaddingException, IllegalBlockSizeException, CertificateEncodingException, IOException, InvalidKeySpecException {
        CMSKeyTransRecipientInfo recip = (CMSKeyTransRecipientInfo)this.recipTable.get(new IssuerAndSerialNo(new X509(recipientCert.getEncoded())));
        if (recip == null) {
            recip = (CMSKeyTransRecipientInfo)this.recipTable.get(Utils.toHexString((byte[])CMSUtils.generateSPKI64(recipientCert)));
        }
        if (recip == null) {
            recip = (CMSKeyTransRecipientInfo)this.recipTable.get(Utils.toHexString((byte[])CMSUtils.generateSPKI160(recipientCert)));
        }
        if (recip == null) {
            throw new UnknownRecipientException("No matching RecipientInfo found");
        }
        this.contentAuthenticationKeyBytes = recip.getContentEncryptionKey(privateKey, CMSUtils.getAlgoName(this.getMACAlgID(), true));
        this.contentAuthenticationAlgoName = recip.getKeyAlgo();
        byte[] cmac = this.calculateMAC();
        if (!Utils.areEqual((byte[])this.mac, (byte[])cmac)) {
            throw new AuthenticationException("MAC Verification Failed");
        }
    }

    public void verifyMAC(SecretKey symmetricKey, byte[] keyIdentifier) throws InvalidKeyException, UnknownRecipientException, InvalidInputException, AuthenticationException, NoSuchAlgorithmException, BadPaddingException, IllegalBlockSizeException, NoSuchPaddingException, InvalidAlgorithmParameterException, InvalidKeySpecException {
        this.verifyMAC(symmetricKey, keyIdentifier, null);
    }

    public void verifyMAC(SecretKey symmetricKey, byte[] keyIdentifier, Date keyDate) throws InvalidKeyException, UnknownRecipientException, InvalidInputException, AuthenticationException, NoSuchAlgorithmException, BadPaddingException, IllegalBlockSizeException, NoSuchPaddingException, InvalidAlgorithmParameterException, InvalidKeySpecException {
        this.verifyMAC(symmetricKey, keyIdentifier, keyDate, null);
    }

    public void verifyMAC(SecretKey symmetricKey, byte[] keyIdentifier, Date keyDate, ASN1Sequence otherKeyAttribute) throws InvalidKeyException, UnknownRecipientException, InvalidInputException, AuthenticationException, NoSuchAlgorithmException, BadPaddingException, IllegalBlockSizeException, NoSuchPaddingException, InvalidAlgorithmParameterException, InvalidKeySpecException {
        CMSRecipientInfo recip;
        CMSKEKRecipientInfoSpec spec = new CMSKEKRecipientInfoSpec(CMS.id_alg_CMS3DESwrap, symmetricKey, keyIdentifier);
        if (keyDate != null) {
            spec.setKeyDate(keyDate);
        }
        if (otherKeyAttribute != null) {
            spec.setOtherKeyAttribute(otherKeyAttribute);
        }
        if ((recip = (CMSRecipientInfo)this.recipTable.get(spec)) == null) {
            throw new UnknownRecipientException("No matching RecipientInfo Found");
        }
        CMSKEKRecipientInfo recipient = null;
        if (!(recip instanceof CMSKEKRecipientInfo)) {
            throw new UnknownRecipientException("RecipientInfo is not of type Key Encipherment");
        }
        recipient = (CMSKEKRecipientInfo)recip;
        this.contentAuthenticationKeyBytes = recipient.getContentEncryptionKey(symmetricKey).getEncoded();
        this.contentAuthenticationAlgoName = recipient.getContentEncryptionKey(symmetricKey).getAlgorithm();
        byte[] cmac = this.calculateMAC();
        if (!Utils.areEqual((byte[])this.mac, (byte[])cmac)) {
            throw new AuthenticationException("MAC Verification Failed");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void inputContent(InputStream is) throws IOException {
        ASN1SequenceInputStream ad = new ASN1SequenceInputStream(is);
        this.version = new ASN1Integer((InputStream)ad);
        if (!this.version.equals(0)) {
            throw new VersionException("Expected Version 0 But Got " + this.version.getValue());
        }
        if (ad.getCurrentTag() == 0) {
            ad.setCurrentTag(16);
            this.originatorInfo = new OriginatorInfo((InputStream)ad);
        } else {
            this.originatorInfo = null;
        }
        this.recipTable = new Hashtable();
        ASN1SetInputStream ris = new ASN1SetInputStream((InputStream)ad);
        while (ris.hasMoreData()) {
            CMSRecipientInfo rii;
            CMSRecipientInfo ri = CMSRecipientInfo.inputInstance((InputStream)ris);
            if (ri instanceof CMSKeyTransRecipientInfo) {
                rii = (CMSKeyTransRecipientInfo)ri;
                if (((CMSKeyTransRecipientInfo)rii).getSPKI() == null) {
                    this.recipTable.put(((CMSKeyTransRecipientInfo)rii).getIASN(), rii);
                    continue;
                }
                this.recipTable.put(Utils.toHexString((byte[])((CMSKeyTransRecipientInfo)rii).getSPKI()), rii);
                continue;
            }
            if (!(ri instanceof CMSKEKRecipientInfo)) throw new IOException("Unknown CMSRecipientInfo Type");
            rii = (CMSKEKRecipientInfo)ri;
            this.recipTable.put(((CMSKEKRecipientInfo)rii).getRecipientInfoSpec(), rii);
        }
        ris.terminate();
        this.macAlgID = new AlgorithmIdentifier((InputStream)ad);
        if (ad.getCurrentTag() == 1) {
            ad.setCurrentTag(16);
            this.digestAlgID = new AlgorithmIdentifier((InputStream)ad);
        } else {
            this.digestAlgID = null;
        }
        EncapsulatedContentInfo encap_info = new EncapsulatedContentInfo((InputStream)ad);
        this.contentInfo = encap_info.getCMSContentInfo();
        if (ad.getCurrentTag() == 2) {
            ad.setCurrentTag(17);
            this.authenticatedAttributes = new AttributeSet((InputStream)ad);
        } else {
            this.authenticatedAttributes = null;
        }
        this.mac = new ASN1OctetString((InputStream)ad).getValue();
        if (ad.hasMoreData()) {
            if (ad.getCurrentTag() != 3) throw new IOException("Expected Unauthenticated Attributes");
            ad.setCurrentTag(17);
            this.unauthenticatedAttributes = new AttributeSet((InputStream)ad);
        } else {
            this.unauthenticatedAttributes = null;
        }
        ad.terminate();
        if (!this.contentInfo.getContentType().equals((Object)CMS.id_data) && this.authenticatedAttributes == null) {
            throw new IOException("Content-Type is not CMS.id_data: AuthenticatedAttributes MUST be present");
        }
        if (this.digestAlgID == null && this.authenticatedAttributes != null || this.digestAlgID != null && this.authenticatedAttributes == null) {
            throw new InvalidInputException("Digest Algorithm and AuthenticatedAttributes  MUST Both be present or Not at all");
        }
        if (!this.contentInfo.isDetached()) return;
        this.writeDetachedObject = true;
    }

    public void setOriginatorInfo(OriginatorInfo originatorInfo) {
        this.originatorInfo = originatorInfo;
        this.update();
    }

    public void setUnauthenticatedAttributes(AttributeSet unauthenticatedAttributes) {
        this.unauthenticatedAttributes = unauthenticatedAttributes;
        this.update();
    }

    public void setAuthenticatedAttributes(AttributeSet authenticatedAttributes, AlgorithmIdentifier digestAlgorithm) throws InvalidInputException {
        this.authenticatedAttributes = authenticatedAttributes;
        this.digestAlgID = digestAlgorithm;
        if (this.digestAlgID != null && this.authenticatedAttributes == null || this.authenticatedAttributes != null && this.digestAlgID == null) {
            throw new InvalidInputException("Expected both Digest Algorithm and AuthenticatedAttributes");
        }
        if (!this.contentInfo.getContentType().equals((Object)CMS.id_data) && this.authenticatedAttributes == null) {
            throw new InvalidInputException("Authenticated Content is not id-data: AuthenticatedAttributes MUST be present");
        }
        this.update();
    }

    @Override
    protected void update() {
        super.update();
        this.exposedContent = null;
    }
}

