/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xsql;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import oracle.xml.xsql.XSQLConfigManager;
import oracle.xml.xsql.XSQLConnection;
import oracle.xml.xsql.XSQLPageRequest;
import oracle.xml.xsql.XSQLUtil;

final class XSQLConnectionPool {
    private Hashtable connections;
    private String driver;
    private String dbURL;
    private String username;
    private String poolName;
    private String password;
    Boolean autocommit = null;
    private long lastCleanup = -1L;
    private int POOL_TIMEOUT = 60000;
    private int POOL_INCREMENT = 1;
    private int POOL_INITIAL = 1;

    public XSQLConnectionPool(XSQLPageRequest xSQLPageRequest, String string, String string2, String string3, String string4, String string5, Boolean bl) throws SQLException {
        XSQLConfigManager xSQLConfigManager = XSQLConfigManager.getManager();
        this.POOL_TIMEOUT = xSQLConfigManager.getConnectionPoolTimeout();
        this.POOL_INCREMENT = xSQLConfigManager.getConnectionPoolIncrement();
        if (xSQLPageRequest.useConnectionPooling()) {
            this.POOL_INITIAL = xSQLConfigManager.getConnectionPoolInitial();
        }
        this.driver = string2;
        this.dbURL = string3;
        this.poolName = string;
        this.username = string4;
        this.password = string5;
        this.autocommit = bl;
        this.connections = new Hashtable(this.POOL_INITIAL * 2);
        for (int i = 0; i < this.POOL_INITIAL; ++i) {
            XSQLConnection xSQLConnection = this.newConnection(string2, string3, string4, string5, bl);
            if (xSQLConnection == null) {
                throw new SQLException("Error Establishing the Database Connection");
            }
            this.connections.put(xSQLConnection, Boolean.FALSE);
            continue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpPool(XSQLPageRequest xSQLPageRequest) {
        PrintWriter printWriter = xSQLPageRequest.getWriter();
        if (xSQLPageRequest.useHTMLErrors()) {
            printWriter.println("<h2>Pool (" + this.poolName + ")</h2><table><tr><td>Conn#</td><td>In Use?</td></tr>");
        } else {
            printWriter.println("Pool (" + this.poolName + ")");
        }
        Enumeration enumeration = this.connections.keys();
        int n = 0;
        Hashtable hashtable = this.connections;
        synchronized (hashtable) {
            while (enumeration.hasMoreElements()) {
                ++n;
                XSQLConnection xSQLConnection = (XSQLConnection)enumeration.nextElement();
                Boolean bl = (Boolean)this.connections.get(xSQLConnection);
                if (xSQLPageRequest.useHTMLErrors()) {
                    printWriter.println("<tr><td>" + n + "</td><td>" + bl.toString() + "</td></tr>");
                    continue;
                }
                printWriter.println(n + "     " + bl.toString());
            }
        }
        if (xSQLPageRequest.useHTMLErrors()) {
            printWriter.println("</table>");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XSQLConnection getConnection() throws SQLException {
        XSQLConnection xSQLConnection = null;
        XSQLConnection xSQLConnection2 = null;
        Enumeration enumeration = this.connections.keys();
        if (enumeration == null) {
            throw new SQLException("Couldn't get connection. DB Down?");
        }
        int n = 0;
        long l = System.currentTimeMillis();
        boolean bl = false;
        if (l - this.lastCleanup > (long)this.POOL_TIMEOUT) {
            bl = true;
            this.lastCleanup = l;
        }
        Hashtable hashtable = this.connections;
        synchronized (hashtable) {
            while (enumeration.hasMoreElements()) {
                xSQLConnection = (XSQLConnection)enumeration.nextElement();
                ++n;
                Boolean bl2 = (Boolean)this.connections.get(xSQLConnection);
                if (bl2 != Boolean.FALSE) continue;
                if (xSQLConnection2 == null) {
                    try {
                        xSQLConnection.getJDBCConnection().rollback();
                    }
                    catch (SQLException sQLException) {
                        this.connections.remove(xSQLConnection);
                        xSQLConnection = this.newConnection(this.driver, this.dbURL, this.username, this.password, this.autocommit);
                    }
                    this.connections.put(xSQLConnection, Boolean.TRUE);
                    xSQLConnection2 = xSQLConnection;
                    continue;
                }
                if (!bl || l - xSQLConnection.getLastUsed() <= (long)this.POOL_TIMEOUT || n <= this.POOL_INITIAL) continue;
                xSQLConnection.close();
                this.connections.remove(xSQLConnection);
            }
        }
        if (xSQLConnection2 != null) {
            return xSQLConnection2;
        }
        for (int i = 0; i < this.POOL_INCREMENT; ++i) {
            this.connections.put(this.newConnection(this.driver, this.dbURL, this.username, this.password, this.autocommit), Boolean.FALSE);
        }
        return this.getConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseConnection(XSQLConnection xSQLConnection) {
        Enumeration enumeration = this.connections.keys();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            ++n;
            XSQLConnection xSQLConnection2 = (XSQLConnection)enumeration.nextElement();
            if (xSQLConnection2 != xSQLConnection) continue;
            this.resetPackageStateIfUsingOracleDriver(xSQLConnection2);
            Hashtable hashtable = this.connections;
            synchronized (hashtable) {
                long l = System.currentTimeMillis();
                xSQLConnection2.updateLastUsed();
                this.connections.put(xSQLConnection2, Boolean.FALSE);
                break;
            }
        }
    }

    private void resetPackageStateIfUsingOracleDriver(XSQLConnection xSQLConnection) {
        Connection connection = xSQLConnection.getJDBCConnection();
        if (xSQLConnection.isOracleDriver()) {
            PreparedStatement preparedStatement = null;
            try {
                preparedStatement = connection.prepareStatement("begin dbms_session.reset_package; end;");
                int n = preparedStatement.executeUpdate();
                preparedStatement.close();
            }
            catch (SQLException sQLException) {
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private XSQLConnection newConnection(String string, String string2, String string3, String string4, Boolean bl) throws SQLException {
        Connection connection = null;
        String string5 = "oracle.jdbc.OracleDriver";
        String string6 = "";
        String string7 = "";
        String string8 = "";
        if (string != null) {
            string5 = string;
        }
        if (string3 != null) {
            string6 = string3;
        }
        if (string4 != null) {
            string8 = string4;
        }
        if (string2 != null) {
            string7 = string2;
        }
        try {
            Class clazz = XSQLUtil.classForName(string5);
            Driver driver = (Driver)clazz.newInstance();
            DriverManager.registerDriver(driver);
            connection = DriverManager.getConnection(string7, string6, string8);
            if (connection != null && bl != null) {
                if (bl.equals(Boolean.FALSE)) {
                    if (connection.getAutoCommit()) {
                        try {
                            connection.setAutoCommit(false);
                        }
                        catch (Throwable throwable) {}
                    }
                } else if (!connection.getAutoCommit()) {
                    try {
                        connection.setAutoCommit(true);
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw new SQLException(exception.toString());
        }
        return new XSQLConnection(connection, this.poolName);
    }

    synchronized void cleanup() {
        if (this.connections != null) {
            Enumeration enumeration = this.connections.keys();
            if (enumeration != null) {
                while (enumeration.hasMoreElements()) {
                    XSQLConnection xSQLConnection = (XSQLConnection)enumeration.nextElement();
                    Connection connection = xSQLConnection.getJDBCConnection();
                    if (connection == null) continue;
                    try {
                        connection.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
            this.connections.clear();
        }
    }
}

