/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.pipeline.controller;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.pipeline.controller.PipelineConstants;
import oracle.xml.pipeline.controller.PipelineDoc;
import oracle.xml.pipeline.controller.PipelineErrorHandler;
import oracle.xml.pipeline.controller.PipelineException;
import oracle.xml.pipeline.controller.PipelineProcessor;
import oracle.xml.util.FastVector;

public class orapipe
implements PipelineErrorHandler,
PipelineConstants {
    private static final String newline = System.getProperty("line.separator");
    private static final String usageMessage = "usage: orapipe options* <pipedoc>" + newline + "where the options are: " + newline + "    -help                   Prints the help message" + newline + "    -version                Prints the release version" + newline + "    -sequential             Executes the pipeline in a sequential mode," + newline + "                            default is parallel" + newline + "    -validate               Validates the pipedoc with the pipeline" + newline + "                            schema, by default does not validate" + newline + "                            If 'outparam' feature is used, then validate" + newline + "                            will fail with the current pipeline schema " + newline + "                            because this is an additional feature." + newline + "    -log <logfile>          Writes the errors/logs to the output file" + newline + "                            by default writes to pipe.log" + newline + "    -noinfo                 Don't log any info items, default is on" + newline + "    -nowarning              Don't log any warnings, default is on" + newline + "    -force                  Executes pipeline even if target is up-to-date," + newline + "                            by default no force is specified" + newline;
    String pipedoc;
    PrintWriter log;
    FastVector procDefNames;
    FastVector procDefs;
    FastVector attrNames;
    FastVector attrVals;
    static boolean versionFlag = false;
    static boolean validateFlag = false;
    static boolean infoFlag = true;
    static boolean warningFlag = true;
    static boolean logFlag = false;
    static boolean pipeFlag = true;
    static boolean isFile = false;
    static boolean procDefFlag = false;
    static boolean attrFlag = false;
    static boolean forceFlag = false;
    static int mode = 2;
    static int errCount;
    static int warnCount;

    public static void main(String[] stringArray) {
        orapipe orapipe2 = new orapipe();
        orapipe2.process(stringArray);
        if (pipeFlag) {
            orapipe2.pipe();
        }
    }

    private void process(String[] stringArray) {
        File file;
        int n = stringArray.length;
        int n2 = stringArray.length;
        if (n == 0) {
            this.printUsage("\nError: At least one argument (file name) is required.  \n");
        } else {
            try {
                file = new File(stringArray[n - 1]);
                if (file.exists()) {
                    this.pipedoc = stringArray[n - 1];
                    isFile = true;
                    n2 = n - 1;
                } else {
                    isFile = false;
                }
            }
            catch (Exception exception) {
                ++errCount;
                this.exitWithError("Error opening input file: " + exception.getMessage());
            }
        }
        for (int i = 0; i < n2; ++i) {
            if (stringArray[i].equals("-help")) {
                this.printUsage("");
                System.exit(0);
                continue;
            }
            if (stringArray[i].equals("-version")) {
                pipeFlag = false;
                versionFlag = true;
                file = new DOMParser();
                System.out.println("XDK version: " + DOMParser.getReleaseVersion());
                continue;
            }
            if (stringArray[i].equals("-sequential")) {
                if (isFile) {
                    mode = 1;
                    continue;
                }
                this.printUsage("\nError: Input pipedoc is required\n");
                continue;
            }
            if (stringArray[i].equals("-validate")) {
                if (isFile) {
                    pipeFlag = true;
                    validateFlag = true;
                    continue;
                }
                this.printUsage("\nError: Input pipedoc is required\n");
                continue;
            }
            if (stringArray[i].equals("-log")) {
                if (++i > n - 1) {
                    this.printUsage("\nError: Missing <logfile> after -log\n");
                }
                try {
                    logFlag = true;
                    this.log = new PrintWriter(new FileWriter(stringArray[i]));
                }
                catch (IOException iOException) {
                    this.printUsage("The specified error log " + stringArray[i] + " could not be opened for writing: " + iOException.getMessage());
                }
                continue;
            }
            if (stringArray[i].equals("-noinfo")) {
                if (isFile) {
                    infoFlag = false;
                    continue;
                }
                this.printUsage("\nError: Input pipedoc is required\n");
                continue;
            }
            if (stringArray[i].equals("-nowarning")) {
                if (isFile) {
                    warningFlag = true;
                    continue;
                }
                this.printUsage("\nError: Input pipedoc is required\n");
                continue;
            }
            if (stringArray[i].equals("-force")) {
                if (isFile) {
                    forceFlag = true;
                    continue;
                }
                this.printUsage("\nError: Input pipedoc is required\n");
                continue;
            }
            if (stringArray[i].equals("-procdef")) {
                if (i + 2 > n - 1) {
                    this.printUsage("\nError: Missing <name> <def> after -procdef\n");
                }
                if (this.procDefNames == null) {
                    this.procDefNames = new FastVector();
                    this.procDefs = new FastVector();
                }
                procDefFlag = true;
                this.procDefNames.addElement((Object)stringArray[++i]);
                this.procDefs.addElement((Object)stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("-attr")) {
                if (i + 2 > n - 1) {
                    this.printUsage("\nError: Missing <name> <val> after -attr\n");
                }
                if (this.attrNames == null) {
                    this.attrNames = new FastVector();
                    this.attrVals = new FastVector();
                }
                attrFlag = true;
                this.attrNames.addElement((Object)stringArray[++i]);
                this.attrVals.addElement((Object)stringArray[++i]);
                continue;
            }
            this.printUsage("\nError: Unknown option\n");
            System.exit(1);
        }
    }

    private void pipe() {
        try {
            if (!logFlag) {
                this.log = new PrintWriter(new FileWriter("pipe.log"));
            }
            FileReader fileReader = new FileReader(this.pipedoc);
            PipelineDoc pipelineDoc = new PipelineDoc(fileReader, validateFlag);
            PipelineProcessor pipelineProcessor = new PipelineProcessor();
            pipelineProcessor.setPipelineDoc(pipelineDoc);
            pipelineProcessor.setExecutionMode(mode);
            pipelineProcessor.setErrorHandler(this);
            pipelineProcessor.setForce(forceFlag);
            if (procDefFlag) {
                while (this.procDefNames.size() > 0) {
                    pipelineProcessor.addProcessDef((String)this.procDefNames.popElement(), (String)this.procDefs.popElement());
                }
            }
            if (attrFlag) {
                while (this.attrNames.size() > 0) {
                    pipelineProcessor.setAttribute((String)this.attrNames.popElement(), (String)this.attrVals.popElement());
                }
            }
            pipelineProcessor.executePipeline();
        }
        catch (Exception exception) {
            this.exitWithError("Error executing: " + this.pipedoc + "(" + exception.getMessage() + ")");
        }
        this.closeLog();
    }

    private void printUsage(String string) {
        System.out.println(string + newline + usageMessage);
        System.exit(0);
    }

    private void exitWithError(String string) {
        System.err.println(string);
        this.closeLog();
        System.exit(1);
    }

    @Override
    public void error(String string, PipelineException pipelineException) throws PipelineException {
        this.log.println("\nError in: " + pipelineException.getProcessId());
        this.log.println("Type: " + pipelineException.getExceptionType());
        this.log.println("Exception message: " + pipelineException.getMessage());
        this.log.println("Error message: " + string);
        this.log.flush();
        ++errCount;
    }

    @Override
    public void fatalError(String string, PipelineException pipelineException) throws PipelineException {
        this.log.println("\nFatalError in: " + pipelineException.getProcessId());
        this.log.println("Type: " + pipelineException.getExceptionType());
        this.log.println("Exception Message: " + pipelineException.getMessage());
        this.log.println("Error message: " + string);
        this.log.flush();
        ++errCount;
    }

    @Override
    public void warning(String string, PipelineException pipelineException) throws PipelineException {
        if (warningFlag) {
            this.log.println("\nWarning in: " + pipelineException.getProcessId());
            this.log.println("Exception Message: " + pipelineException.getMessage());
            this.log.println("Error message: " + string);
            this.log.flush();
            ++warnCount;
        }
    }

    @Override
    public void info(String string) {
        if (infoFlag) {
            this.log.println("\nInfo : " + string);
            this.log.flush();
            ++warnCount;
        }
    }

    private void closeLog() {
        if (this.log == null) {
            return;
        }
        this.log.println("\nTotal Errors: " + errCount + "\nTotal Warnings: " + warnCount);
        this.log.flush();
        this.log.close();
    }
}

