/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.pipeline.controller;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import oracle.xml.pipeline.controller.PipelineConstants;

public class Util
implements PipelineConstants {
    public static final URL createURL(String string) throws MalformedURLException {
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            File file = new File(string);
            String string2 = file.getAbsolutePath();
            String string3 = System.getProperty("file.separator");
            if (string3.length() == 1) {
                char c = string3.charAt(0);
                if (c != '/') {
                    string2 = string2.replace(c, '/');
                }
                if (string2.charAt(0) != '/') {
                    string2 = '/' + string2;
                }
            }
            string2 = "file://" + string2;
            uRL = new URL(string2);
        }
        return uRL;
    }

    static final OutputStream createOutStream(URL uRL) throws FileNotFoundException, IOException {
        OutputStream outputStream;
        if (uRL.getProtocol().compareTo("file") == 0) {
            outputStream = new BufferedOutputStream(new FileOutputStream(uRL.getFile()));
        } else {
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setDoOutput(true);
            outputStream = uRLConnection.getOutputStream();
        }
        return outputStream;
    }

    static final Writer createWriter(URL uRL) throws FileNotFoundException, IOException {
        Writer writer;
        if (uRL.getProtocol().compareTo("file") == 0) {
            writer = new BufferedWriter(new FileWriter(uRL.getFile()));
        } else {
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setDoOutput(true);
            OutputStream outputStream = uRLConnection.getOutputStream();
            writer = new OutputStreamWriter(outputStream);
        }
        return writer;
    }

    static final InputStream createInStream(URL uRL) throws IOException {
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.setDoInput(true);
        InputStream inputStream = uRLConnection.getInputStream();
        return inputStream;
    }
}

