/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.pipeline.controller;

import oracle.xml.pipeline.controller.PipelineConstants;
import oracle.xml.pipeline.controller.PipelineErrorHandler;
import oracle.xml.pipeline.controller.PipelineException;
import oracle.xml.pipeline.controller.Process;
import oracle.xml.util.XMLError;

class PipeError
implements PipelineConstants {
    private Process process;
    private String processId;
    private PipelineErrorHandler hdlr;
    private XMLError xmlErr = new XMLError();

    PipeError() {
    }

    void setErrorHandler(PipelineErrorHandler pipelineErrorHandler) {
        this.hdlr = pipelineErrorHandler;
    }

    void setProcess(Process process) {
        this.process = process;
    }

    void setProcessId(String string) {
        this.processId = string;
    }

    public synchronized void error(int n, int n2, Exception exception) throws PipelineException {
        String string = new String("XML-" + n + ": (" + this.typeToString(n2) + ") " + this.getMessage(n));
        this.error(n2, string, exception);
    }

    public synchronized void error(int n, int n2) throws PipelineException {
        String string = this.getMessage(n);
        String string2 = new String("XML-" + n + ": (" + this.typeToString(n2) + ") " + string);
        this.error(n2, string2, (Exception)new PipelineException(string));
    }

    public synchronized void error(int n, int n2, String[] stringArray) throws PipelineException {
        String string = this.xmlErr.getMessage(n, stringArray);
        String string2 = new String("XML-" + n + ": (" + this.typeToString(n2) + ") " + string);
        this.error(n2, string2, (Exception)new PipelineException(string));
    }

    public synchronized void info(String string) {
        this.hdlr.info(string);
    }

    public synchronized void info(int n, String[] stringArray) {
        String string = this.xmlErr.getMessage(n, stringArray);
        String string2 = new String("XML-" + n + ": " + string);
        this.hdlr.info(string2);
    }

    String typeToString(int n) {
        switch (n) {
            case 17: {
                return "Fatal Error";
            }
            case 16: {
                return "Error";
            }
            case 18: {
                return "Warning";
            }
        }
        return "";
    }

    void error(int n, String string, Exception exception) throws PipelineException {
        PipelineException pipelineException = new PipelineException(exception);
        if (this.processId != null) {
            pipelineException.setProcessId(this.processId);
        } else if (this.process != null) {
            pipelineException.setProcessId(this.process.getId());
        } else {
            pipelineException.setProcessId("");
        }
        switch (n) {
            case 17: {
                this.reportFatalError(string, pipelineException);
                break;
            }
            case 16: {
                this.reportError(string, pipelineException);
                break;
            }
            case 18: {
                this.reportWarning(string, pipelineException);
            }
        }
    }

    String getMessage(int n) {
        String string = this.xmlErr.getMessage0(n);
        return string;
    }

    void reportFatalError(String string, PipelineException pipelineException) throws PipelineException {
        try {
            try {
                this.hdlr.fatalError(string, pipelineException);
                throw pipelineException;
            }
            catch (Exception exception) {
                throw new PipelineException(exception);
            }
        }
        catch (Throwable throwable) {
            if (this.process != null && this.process.isMultiThreaded()) {
                this.process.getProcessor().stopPipeline();
            }
            throw throwable;
        }
    }

    void reportError(String string, PipelineException pipelineException) throws PipelineException {
        try {
            this.hdlr.error(string, pipelineException);
        }
        catch (Exception exception) {
            throw new PipelineException(exception);
        }
    }

    void reportWarning(String string, PipelineException pipelineException) throws PipelineException {
        try {
            this.hdlr.warning(string, pipelineException);
        }
        catch (Exception exception) {
            throw new PipelineException(exception);
        }
    }
}

