/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.differ;

import java.awt.Color;
import java.io.BufferedWriter;
import java.io.IOException;
import oracle.xml.differ.DiffTreeNode;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class SameDiffTreeNode
extends DiffTreeNode {
    private int position = 0;

    protected SameDiffTreeNode(Node node) {
        super(node);
        this.diffType = 0;
    }

    protected SameDiffTreeNode(Node node, boolean bl) {
        super(node);
        this.buildTree();
    }

    @Override
    public Color getColor() {
        return Color.black;
    }

    @Override
    protected void createTree() {
    }

    protected void buildTree() {
        Node node = this.getNodeObject();
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap != null) {
            this.setAttrNum(namedNodeMap.getLength());
            for (int i = 0; i < this.getAttrNum(); ++i) {
                this.addXMLNode(namedNodeMap.item(i), true);
            }
        }
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            this.addXMLNode(nodeList.item(i), true);
        }
    }

    protected void addXMLNode(Node node, boolean bl) {
        this.insert(new SameDiffTreeNode(node, bl), this.position++);
    }

    @Override
    protected void printNode(BufferedWriter bufferedWriter) throws IOException {
        bufferedWriter.write("            " + this.toString());
        bufferedWriter.newLine();
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            ((DiffTreeNode)this.getChildAt(i)).printNode(bufferedWriter);
        }
    }
}

