/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.differ;

import java.awt.Color;
import java.io.BufferedWriter;
import java.io.IOException;
import javax.swing.tree.DefaultMutableTreeNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

class DiffTreeNode
extends DefaultMutableTreeNode {
    protected short diffType;
    private Node treeNode;
    private int position = 0;
    private int attrNodes = 0;

    public DiffTreeNode(Node node) {
        super(node);
        this.treeNode = node;
        this.diffType = 0;
    }

    public Node getNodeObject() {
        return this.treeNode;
    }

    public short getDiffType() {
        return this.diffType;
    }

    public void insert(DiffTreeNode diffTreeNode, int n) {
        if (this.getChildCount() <= n) {
            super.add(diffTreeNode);
        } else {
            super.insert(diffTreeNode, n);
        }
    }

    protected void addXMLNode(Node node) {
        this.insert(new DiffTreeNode(node), this.position++);
    }

    protected void createTree() {
        Node node = this.getNodeObject();
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap != null) {
            this.setAttrNum(namedNodeMap.getLength());
            for (int i = 0; i < this.getAttrNum(); ++i) {
                this.addXMLNode(namedNodeMap.item(i));
            }
        }
        if (node.getNodeType() != 2) {
            NodeList nodeList = node.getChildNodes();
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                this.addXMLNode(nodeList.item(i));
            }
        }
    }

    @Override
    public String toString() {
        Node node = (Node)this.getUserObject();
        switch (node.getNodeType()) {
            case 8: {
                return this.stripLF(((Comment)node).getNodeValue());
            }
            case 3: {
                return "\"" + this.stripLF(((Text)node).getNodeValue()) + "\"";
            }
            case 1: {
                return ((Element)node).getTagName();
            }
            case 9: {
                return "[DOCUMENT]";
            }
            case 7: {
                return ((ProcessingInstruction)node).getData();
            }
            case 2: {
                return ((Attr)node).getName() + "=\"" + ((Attr)node).getValue() + "\"";
            }
        }
        return node.getNodeValue();
    }

    public Color getColor() {
        return Color.black;
    }

    protected void setAttrNum(int n) {
        this.attrNodes = n;
    }

    protected int getAttrNum() {
        return this.attrNodes;
    }

    protected void printNode(BufferedWriter bufferedWriter) throws IOException {
    }

    private String stripLF(String string) {
        int n = 1000;
        StringBuffer stringBuffer = new StringBuffer(string);
        int n2 = stringBuffer.length();
        char[] cArray = new char[n2];
        stringBuffer.getChars(0, n2, cArray, 0);
        for (int i = 0; i < n2; ++i) {
            if (cArray[i] != '\n') continue;
            stringBuffer.setCharAt(i, ' ');
        }
        if (stringBuffer.length() > n) {
            stringBuffer.setLength(n);
            stringBuffer.append("... (string truncated)");
        }
        return stringBuffer.toString();
    }
}

