/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.diff;

import java.io.File;
import java.io.StringBufferInputStream;
import java.io.StringWriter;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import oracle.xml.diff.DiffOpReceiver;
import oracle.xml.diff.DiffOpsToDOM;
import oracle.xml.diff.Options;
import oracle.xml.diff.XmlInternalUtils;
import oracle.xml.diff.XmlMapper;
import oracle.xml.diff.XmlOutputBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.InputSource;

public class XmlUtils {
    DocumentBuilderFactory dbFactory;
    DocumentBuilder docBuilder;

    private void instantiateDocBuilder() throws Exception {
        if (this.docBuilder == null) {
            this.dbFactory = DocumentBuilderFactory.newInstance();
            this.dbFactory.setNamespaceAware(true);
            this.docBuilder = this.dbFactory.newDocumentBuilder();
        }
    }

    public Document diffToDoc(Node node, Node node2, Options options) throws Exception {
        if (!(options = this.getOptions(options)).ignorePrefixDifferences()) {
            throw new Exception(XmlInternalUtils.getMessageFetcher().getMessage0("XMLDIFF-0015"));
        }
        options.textualOutput(true);
        this.instantiateDocBuilder();
        DiffOpsToDOM diffOpsToDOM = new DiffOpsToDOM(this.docBuilder);
        this.diff(node, node2, (DiffOpReceiver)diffOpsToDOM, options);
        return diffOpsToDOM.getDOM();
    }

    public Document diffToDoc(File file, File file2, Options options) throws Exception {
        if (!(options = this.getOptions(options)).ignorePrefixDifferences()) {
            throw new Exception(XmlInternalUtils.getMessageFetcher().getMessage0("XMLDIFF-0015"));
        }
        options.textualOutput(true);
        this.instantiateDocBuilder();
        DiffOpsToDOM diffOpsToDOM = new DiffOpsToDOM(this.docBuilder);
        Document document = this.docBuilder.parse(file);
        Document document2 = this.docBuilder.parse(file2);
        this.diff(document, document2, (DiffOpReceiver)diffOpsToDOM, options);
        return diffOpsToDOM.getDOM();
    }

    public Document diffToDoc(InputSource inputSource, InputSource inputSource2, Options options) throws Exception {
        if (!(options = this.getOptions(options)).ignorePrefixDifferences()) {
            throw new Exception(XmlInternalUtils.getMessageFetcher().getMessage0("XMLDIFF-0015"));
        }
        options.textualOutput(true);
        this.instantiateDocBuilder();
        DiffOpsToDOM diffOpsToDOM = new DiffOpsToDOM(this.docBuilder);
        Document document = this.docBuilder.parse(inputSource);
        Document document2 = this.docBuilder.parse(inputSource2);
        this.diff(document, document2, (DiffOpReceiver)diffOpsToDOM, options);
        return diffOpsToDOM.getDOM();
    }

    public void diff(Node node, Node node2, DiffOpReceiver diffOpReceiver, Options options) throws Exception {
        if (options == null) {
            options = new Options();
        } else if (options.includeXPaths() && !options.ignorePrefixDifferences()) {
            throw new Exception(XmlInternalUtils.getMessageFetcher().getMessage0("XMLDIFF-0016"));
        }
        if (node == null) {
            throw new Exception(XmlInternalUtils.getMessageFetcher().getMessage0("XMLDIFF-0006"));
        }
        if (node2 == null) {
            throw new Exception(XmlInternalUtils.getMessageFetcher().getMessage0("XMLDIFF-0007"));
        }
        if (diffOpReceiver == null) {
            throw new Exception(XmlInternalUtils.getMessageFetcher().getMessage0("XMLDIFF-0009"));
        }
        if (options.normalizeTextNodes()) {
            this.instantiateDocBuilder();
        }
        if (XmlInternalUtils.ignoreNode(node)) {
            throw new Exception(XmlInternalUtils.getMessageFetcher().getMessage0("XMLDIFF-0018"));
        }
        if (XmlInternalUtils.ignoreNode(node2)) {
            throw new Exception(XmlInternalUtils.getMessageFetcher().getMessage0("XMLDIFF-0019"));
        }
        XmlMapper xmlMapper = new XmlMapper(node, node2, options, this.docBuilder);
        if (options.debug() == Options.DebugLevel.MAPPER || options.debug() == Options.DebugLevel.ALL) {
            xmlMapper.printDiffData();
        }
        xmlMapper.computeMapping();
        if (options.debug() == Options.DebugLevel.MAPPER || options.debug() == Options.DebugLevel.ALL) {
            System.err.println("AFTER COMPUTE MAPPING");
            xmlMapper.printDiffData();
        }
        xmlMapper.optimizeChildrenMappings();
        if (options.debug() == Options.DebugLevel.MAPPER || options.debug() == Options.DebugLevel.ALL) {
            System.err.println("AFTER OPTIMIZATION");
            xmlMapper.printDiffData();
        }
        XmlOutputBuilder xmlOutputBuilder = new XmlOutputBuilder(xmlMapper, diffOpReceiver, options, this.docBuilder);
        xmlOutputBuilder.determineDeletesAndInserts();
        if (options.debug() == Options.DebugLevel.BUILDER || options.debug() == Options.DebugLevel.ALL) {
            System.err.println("AFTER DELETES AND INSERTS");
            xmlMapper.printDiffData();
        }
        xmlOutputBuilder.determineDeletesAndInsertsForNodesMovedUnderSameParent();
        if (options.debug() == Options.DebugLevel.BUILDER || options.debug() == Options.DebugLevel.ALL) {
            System.err.println("AFTER DELETES AND INSERTS FOR SAME PARENT MOVES");
            xmlMapper.printDiffData();
        }
        xmlOutputBuilder.generateDeleteOperations();
        xmlOutputBuilder.generateInsertAndAppendOperations();
        xmlOutputBuilder.putDiffOpsInDocumentOrder();
        xmlOutputBuilder.computeXPathsAndNamespaces();
        if (options.debug() == Options.DebugLevel.BUILDER || options.debug() == Options.DebugLevel.ALL) {
            System.err.println("DIFF OUTPUT");
            xmlOutputBuilder.printDiffOut();
        }
        xmlOutputBuilder.returnDiffOpReceiver();
    }

    public void diff(File file, File file2, DiffOpReceiver diffOpReceiver, Options options) throws Exception {
        if (file == null) {
            throw new Exception(XmlInternalUtils.getMessageFetcher().getMessage0("XMLDIFF-0006"));
        }
        if (file2 == null) {
            throw new Exception(XmlInternalUtils.getMessageFetcher().getMessage0("XMLDIFF-0007"));
        }
        this.instantiateDocBuilder();
        Document document = this.docBuilder.parse(file);
        Document document2 = this.docBuilder.parse(file2);
        this.diff(document, document2, diffOpReceiver, options);
    }

    public void diff(InputSource inputSource, InputSource inputSource2, DiffOpReceiver diffOpReceiver, Options options) throws Exception {
        if (inputSource == null) {
            throw new Exception(XmlInternalUtils.getMessageFetcher().getMessage0("XMLDIFF-0006"));
        }
        if (inputSource2 == null) {
            throw new Exception(XmlInternalUtils.getMessageFetcher().getMessage0("XMLDIFF-0007"));
        }
        this.instantiateDocBuilder();
        Document document = this.docBuilder.parse(inputSource);
        Document document2 = this.docBuilder.parse(inputSource2);
        this.diff(document, document2, diffOpReceiver, options);
    }

    public boolean equal(Node node, Node node2, Options options) throws Exception {
        if (node == null) {
            throw new Exception(XmlInternalUtils.getMessageFetcher().getMessage0("XMLDIFF-0006"));
        }
        if (node2 == null) {
            throw new Exception(XmlInternalUtils.getMessageFetcher().getMessage0("XMLDIFF-0007"));
        }
        if (options == null) {
            options = new Options();
        }
        return XmlInternalUtils.equal(node, node2, true, options);
    }

    public boolean equal(File file, File file2, Options options) throws Exception {
        if (file == null) {
            throw new Exception(XmlInternalUtils.getMessageFetcher().getMessage0("XMLDIFF-0006"));
        }
        if (file2 == null) {
            throw new Exception(XmlInternalUtils.getMessageFetcher().getMessage0("XMLDIFF-0007"));
        }
        if (options == null) {
            options = new Options();
        }
        this.instantiateDocBuilder();
        Document document = this.docBuilder.parse(file);
        Document document2 = this.docBuilder.parse(file2);
        return XmlInternalUtils.equal(document, document2, true, options);
    }

    public boolean equal(InputSource inputSource, InputSource inputSource2, Options options) throws Exception {
        if (inputSource == null) {
            throw new Exception(XmlInternalUtils.getMessageFetcher().getMessage0("XMLDIFF-0006"));
        }
        if (inputSource2 == null) {
            throw new Exception(XmlInternalUtils.getMessageFetcher().getMessage0("XMLDIFF-0007"));
        }
        if (options == null) {
            options = new Options();
        }
        this.instantiateDocBuilder();
        Document document = this.docBuilder.parse(inputSource);
        Document document2 = this.docBuilder.parse(inputSource2);
        return XmlInternalUtils.equal(document, document2, true, options);
    }

    public byte[] hash(File file, Options options) throws Exception {
        if (file == null) {
            throw new Exception(XmlInternalUtils.getMessageFetcher().getMessage0("XMLDIFF-0006"));
        }
        if (options == null) {
            options = new Options();
        }
        this.instantiateDocBuilder();
        Document document = this.docBuilder.parse(file);
        return this.hash(document, options);
    }

    public byte[] hash(InputSource inputSource, Options options) throws Exception {
        if (inputSource == null) {
            throw new Exception(XmlInternalUtils.getMessageFetcher().getMessage0("XMLDIFF-0006"));
        }
        if (options == null) {
            options = new Options();
        }
        this.instantiateDocBuilder();
        Document document = this.docBuilder.parse(inputSource);
        return this.hash(document, options);
    }

    public byte[] hash(Node node, Options options) throws Exception {
        if (node == null) {
            throw new Exception(XmlInternalUtils.getMessageFetcher().getMessage0("XMLDIFF-0006"));
        }
        if (options == null) {
            options = new Options();
        }
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        if (node.getNodeType() == 2 || node.getNodeType() == 1) {
            messageDigest.update(XmlInternalUtils.constructElemOrAttrHashString(node, options).getBytes());
            if (node.hasAttributes()) {
                NamedNodeMap namedNodeMap = node.getAttributes();
                int n = namedNodeMap.getLength();
                ArrayList<String> arrayList = new ArrayList<String>();
                for (int i = 0; i < n; ++i) {
                    Node node2 = namedNodeMap.item(i);
                    if (XmlInternalUtils.isXmlns(node2)) continue;
                    arrayList.add(XmlInternalUtils.constructElemOrAttrHashString(node2, options));
                }
                Collections.sort(arrayList);
                for (String string : arrayList) {
                    messageDigest.update(string.getBytes());
                }
            }
            this.processChildren(node, messageDigest, options);
            return messageDigest.digest();
        }
        if (node.getNodeType() == 4 || node.getNodeType() == 8 || node.getNodeType() == 7) {
            return messageDigest.digest((node.getNodeName() + " " + node.getNodeValue()).getBytes());
        }
        if (node.getNodeType() == 3) {
            if (options.normalizeTextNodes()) {
                return messageDigest.digest((node.getNodeName() + " " + XmlInternalUtils.getWholeText(node).trim()).getBytes());
            }
            return messageDigest.digest((node.getNodeName() + " " + node.getNodeValue()).getBytes());
        }
        if (node.getNodeType() == 9 || node.getNodeType() == 11) {
            messageDigest.update(node.getNodeName().getBytes());
            this.processChildren(node, messageDigest, options);
            return messageDigest.digest();
        }
        return null;
    }

    void processChildren(Node node, MessageDigest messageDigest, Options options) throws Exception {
        Node node2 = node.getFirstChild();
        while (node2 != null) {
            if (node2.getNodeType() == 3 && options.normalizeTextNodes()) {
                String string = XmlInternalUtils.getWholeText(node2).trim();
                if (string.length() > 0) {
                    messageDigest.update(MessageDigest.getInstance("MD5").digest((node2.getNodeName() + " " + string).getBytes()));
                }
                node2 = XmlInternalUtils.skipToNextNonTextNode(node2);
                continue;
            }
            messageDigest.update(this.hash(node2, options));
            node2 = node2.getNextSibling();
        }
    }

    Options getOptions(Options options) {
        if (options == null) {
            return new Options();
        }
        return new Options(options);
    }

    public static String nodeToString(Node node, boolean bl) throws Exception {
        if (node == null) {
            throw new Exception(XmlInternalUtils.getMessageFetcher().getMessage0("XMLDIFF-0008"));
        }
        DOMImplementationRegistry dOMImplementationRegistry = DOMImplementationRegistry.newInstance();
        DOMImplementationLS dOMImplementationLS = (DOMImplementationLS)((Object)dOMImplementationRegistry.getDOMImplementation("LS"));
        LSSerializer lSSerializer = dOMImplementationLS.createLSSerializer();
        lSSerializer.getDomConfig().setParameter("format-pretty-print", Boolean.TRUE);
        if (bl) {
            lSSerializer.getDomConfig().setParameter("xml-declaration", Boolean.TRUE);
        } else {
            lSSerializer.getDomConfig().setParameter("xml-declaration", Boolean.FALSE);
        }
        LSOutput lSOutput = dOMImplementationLS.createLSOutput();
        StringWriter stringWriter = new StringWriter();
        lSOutput.setCharacterStream(stringWriter);
        if (bl) {
            lSOutput.setEncoding("UTF-8");
        }
        if (node instanceof Document) {
            Document document = (Document)node;
            lSSerializer.write(document, lSOutput);
            return ((Object)stringWriter).toString();
        }
        return lSSerializer.writeToString(node);
    }

    static Node removeWhitespace(Node node) throws TransformerException {
        String string = "<xsl:stylesheet version=\"1.0\" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\"><xsd:element minOccurs=\"0\" ref=\"Internal-Properties\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"/><xsl:output method=\"xml\" omit-xml-declaration=\"yes\"/><xsl:strip-space elements=\"*\"/><xsl:template match=\"@*|node()\"><xsl:copy><xsl:apply-templates select=\"@*|node()\"/></xsl:copy></xsl:template></xsl:stylesheet>";
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer(new StreamSource(new StringBufferInputStream(string)));
        DOMSource dOMSource = new DOMSource(node);
        DOMResult dOMResult = new DOMResult();
        transformer.transform(dOMSource, dOMResult);
        return dOMResult.getNode();
    }
}

