/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import java.awt.Shape;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import oracle.sdovis.util.ShapeUtil;

public class LiveFeature
implements Serializable {
    private int id;
    private String label = null;
    private String labelStyleName = null;
    private String renderStyleName = null;
    private int markerStyleSize = 0;
    private double[] radius = null;
    private double cx;
    private double cy;
    private Shape shape;
    private int geomType;
    String[] attrs;

    public LiveFeature() {
    }

    public LiveFeature(double d, double d2) {
        this.cx = d;
        this.cy = d2;
    }

    public Point2D getCenterAsPoint2D() {
        return new Point2D.Double(this.cx, this.cy);
    }

    public double getCenterX() {
        return this.cx;
    }

    public double getCenterY() {
        return this.cy;
    }

    public int getGeomType() {
        return this.geomType;
    }

    public void setGeomType(int n) {
        this.geomType = n;
    }

    public Shape getShape() {
        return this.shape;
    }

    public void setShape(Shape shape) {
        this.shape = shape;
    }

    public String[] getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String[] stringArray) {
        this.attrs = stringArray;
    }

    public int getID() {
        return this.id;
    }

    public void setID(int n) {
        this.id = n;
    }

    public String getRenderStyleName() {
        return this.renderStyleName;
    }

    public void setRenderStyleName(String string) {
        this.renderStyleName = string;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public String getLabelStyleName() {
        return this.labelStyleName;
    }

    public void setLabelStyleName(String string) {
        this.labelStyleName = string;
    }

    public int getMarkerStyleSize() {
        return this.markerStyleSize;
    }

    public void setMarkerStyleSize(int n) {
        this.markerStyleSize = n;
    }

    public void setCenter(double d, double d2) {
        this.cx = d;
        this.cy = d2;
    }

    public double[] getRadius() {
        return this.radius;
    }

    public void setRadius(double[] dArray) {
        this.radius = dArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("GeoFeature:\n");
        stringBuffer.append("  id=" + this.id);
        stringBuffer.append("\n  label=" + this.label);
        stringBuffer.append("\n  labelStyleName=" + this.labelStyleName);
        stringBuffer.append("\n  renderStyleName=" + this.renderStyleName);
        stringBuffer.append("\n  markerStyleSize=" + this.markerStyleSize);
        stringBuffer.append("\n  radius=" + this.radius);
        stringBuffer.append("\n  x=" + this.cx + ", y=" + this.cy);
        return stringBuffer.toString();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(this.id);
        objectOutputStream.writeObject(this.label);
        objectOutputStream.writeObject(this.labelStyleName);
        objectOutputStream.writeObject(this.renderStyleName);
        objectOutputStream.writeInt(this.markerStyleSize);
        objectOutputStream.writeObject(this.radius);
        objectOutputStream.writeDouble(this.cx);
        objectOutputStream.writeDouble(this.cy);
        objectOutputStream.writeInt(this.geomType);
        objectOutputStream.writeObject(this.attrs);
        boolean bl = this.shape != null;
        objectOutputStream.writeBoolean(bl);
        if (this.shape != null) {
            ShapeUtil.store(this.shape, objectOutputStream);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.id = objectInputStream.readInt();
        this.label = (String)objectInputStream.readObject();
        this.labelStyleName = (String)objectInputStream.readObject();
        this.renderStyleName = (String)objectInputStream.readObject();
        this.markerStyleSize = objectInputStream.readInt();
        this.radius = (double[])objectInputStream.readObject();
        this.cx = objectInputStream.readDouble();
        this.cy = objectInputStream.readDouble();
        this.geomType = objectInputStream.readInt();
        this.attrs = (String[])objectInputStream.readObject();
        boolean bl = objectInputStream.readBoolean();
        if (bl) {
            this.shape = ShapeUtil.load(objectInputStream);
        }
    }
}

