/*
 * Decompiled with CFR 0.152.
 */
package oracle.mapviewer.share.stylex;

import java.util.ArrayList;
import oracle.mapviewer.share.stylex.AbstractBucketStyleModel;
import oracle.mapviewer.share.stylex.Bucket;
import oracle.mapviewer.share.stylex.BucketSeries;

public class BucketStyleModel
extends AbstractBucketStyleModel {
    static final long serialVersionUID = -9141046439918195333L;

    public BucketStyleModel() {
        this.type = 9;
        this.bucketSeries = new BucketSeries();
    }

    public BucketStyleModel(BucketSeries bucketSeries) {
        this.type = 9;
        this.bucketSeries = bucketSeries;
    }

    @Override
    public Object clone() {
        BucketStyleModel bucketStyleModel = (BucketStyleModel)super.clone();
        return bucketStyleModel;
    }

    @Override
    public String getTypeName() {
        return "ADVANCED";
    }

    @Override
    public String toXMLString() {
        String string = "<?xml version=\"1.0\" ?>\n";
        string = string + "<AdvancedStyle>\n   <BucketStyle>\n";
        string = string + this.bucketSeries.toXMLString();
        string = string + "\n   </BucketStyle>\n</AdvancedStyle>\n";
        return string;
    }

    @Override
    public String[] getStyleDependency() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.bucketSeries == null) {
            return null;
        }
        if (this.bucketSeries.getDefaultRenderStyleName() != null) {
            arrayList.add(this.bucketSeries.getDefaultRenderStyleName());
        }
        if (this.bucketSeries.getDefaultLabelStyleName() != null) {
            arrayList.add(this.bucketSeries.getDefaultLabelStyleName());
        }
        for (int i = 0; i < this.bucketSeries.size(); ++i) {
            Bucket bucket = this.bucketSeries.getBucket(i);
            if (bucket.getRenderStyleName() != null && !arrayList.contains(bucket.getRenderStyleName())) {
                arrayList.add(bucket.getRenderStyleName());
            }
            if (bucket.getLabelStyleName() == null || arrayList.contains(bucket.getLabelStyleName())) continue;
            arrayList.add(bucket.getLabelStyleName());
        }
        if (arrayList.size() == 0) {
            return null;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }
}

