/*
 * Decompiled with CFR 0.152.
 */
package oracle.mapviewer.share;

import java.util.Vector;
import oracle.mapviewer.share.Field;
import oracle.mapviewer.share.TopoChildFeatureDescriptor;
import oracle.mapviewer.share.TopoPrimitiveDescriptor;

public class TopoFeatureDescriptor {
    private String topology = null;
    private String featureTable = null;
    private String topoColumn = null;
    private int layerId = 0;
    private int featureId = 0;
    private int topoType = 0;
    private Vector<TopoChildFeatureDescriptor> childFeatures = new Vector();
    private Vector<TopoPrimitiveDescriptor> primitives = new Vector();
    private Vector<Field> attributes = new Vector();

    public String getTopology() {
        return this.topology;
    }

    public void setTopology(String string) {
        this.topology = string;
    }

    public String getFeatureTable() {
        return this.featureTable;
    }

    public void setFeatureTable(String string) {
        this.featureTable = string;
    }

    public String getTopoColumn() {
        return this.topoColumn;
    }

    public void setTopoColumn(String string) {
        this.topoColumn = string;
    }

    public int getLayerId() {
        return this.layerId;
    }

    public void setLayerId(int n) {
        this.layerId = n;
    }

    public int getFeatureId() {
        return this.featureId;
    }

    public void setFeatureId(int n) {
        this.featureId = n;
    }

    public int getTopoFeatureType() {
        return this.topoType;
    }

    public void setTopoFeatureType(int n) {
        this.topoType = n < 1 || n > 4 ? 0 : n;
    }

    public void addPrimitive(TopoPrimitiveDescriptor topoPrimitiveDescriptor) {
        if (topoPrimitiveDescriptor == null) {
            return;
        }
        this.primitives.add(topoPrimitiveDescriptor);
    }

    public boolean removePrimitive(TopoPrimitiveDescriptor topoPrimitiveDescriptor) {
        if (topoPrimitiveDescriptor == null) {
            return false;
        }
        return this.primitives.remove(topoPrimitiveDescriptor);
    }

    public TopoPrimitiveDescriptor[] getPrimitives() {
        if (this.primitives.size() == 0) {
            return null;
        }
        return this.primitives.toArray(new TopoPrimitiveDescriptor[this.primitives.size()]);
    }

    public void clearPrimitives() {
        this.primitives.clear();
    }

    public int getNumberOfPrimitives() {
        return this.primitives.size();
    }

    public void addChildFeature(TopoChildFeatureDescriptor topoChildFeatureDescriptor) {
        if (topoChildFeatureDescriptor == null) {
            return;
        }
        this.childFeatures.add(topoChildFeatureDescriptor);
    }

    public boolean removeChildFeature(TopoChildFeatureDescriptor topoChildFeatureDescriptor) {
        if (topoChildFeatureDescriptor == null) {
            return false;
        }
        return this.childFeatures.remove(topoChildFeatureDescriptor);
    }

    public TopoChildFeatureDescriptor[] getChildFeatures() {
        if (this.childFeatures.size() == 0) {
            return null;
        }
        return this.childFeatures.toArray(new TopoChildFeatureDescriptor[this.childFeatures.size()]);
    }

    public void clearChildFeatures() {
        this.childFeatures.clear();
    }

    public int getNumberOfChildFeatures() {
        return this.childFeatures.size();
    }

    public void addAttribute(Field field) {
        if (field == null) {
            return;
        }
        this.attributes.add(field);
    }

    public boolean removeAttribute(Field field) {
        if (field == null) {
            return false;
        }
        return this.attributes.remove(field);
    }

    public Field[] getAttributes() {
        if (this.attributes.size() == 0) {
            return null;
        }
        return this.attributes.toArray(new Field[this.attributes.size()]);
    }

    public void clearAttributes() {
        this.attributes.clear();
    }

    public int getNumberOfAttributes() {
        return this.attributes.size();
    }

    public String toXML() {
        TopoChildFeatureDescriptor[] topoChildFeatureDescriptorArray;
        TopoPrimitiveDescriptor[] topoPrimitiveDescriptorArray;
        String string = "<topo_geometry>\n";
        string = string + "  <tg_id>" + this.featureId + "</tg_id>\n";
        string = string + "  <tg_layer_id>" + this.layerId + "</tg_layer_id>\n";
        string = string + "  <tg_type>" + this.topoType + "</tg_type>\n";
        if (this.topology != null) {
            string = string + "  <topology>" + this.topoType + "</topology>\n";
        }
        if (this.featureTable != null) {
            string = string + "  <feature_table>" + this.topoType + "</feature_table>\n";
        }
        if (this.topoColumn != null) {
            string = string + "  <topo_column>" + this.topoType + "</topo_column>\n";
        }
        if ((topoPrimitiveDescriptorArray = this.getPrimitives()) != null && topoPrimitiveDescriptorArray.length > 0) {
            string = string + "   <topo_primitives>\n";
            for (int i = 0; i < topoPrimitiveDescriptorArray.length; ++i) {
                string = string + "      <topo_primitive topo_id=\"" + topoPrimitiveDescriptorArray[i].getTopoId() + "\" topo_type=\"" + topoPrimitiveDescriptorArray[i].getTopoType() + "\" />\n";
            }
            string = string + "   </topo_primitives>\n";
        }
        if ((topoChildFeatureDescriptorArray = this.getChildFeatures()) != null && topoChildFeatureDescriptorArray.length > 0) {
            string = string + "   <child_features>\n";
            for (int i = 0; i < topoChildFeatureDescriptorArray.length; ++i) {
                string = string + "      <child_feature layer_id=\"" + topoChildFeatureDescriptorArray[i].getLayerId() + "\" feature_id=\"" + topoChildFeatureDescriptorArray[i].getFeatureId() + "\" />\n";
            }
            string = string + "   </child_features>\n";
        }
        string = string + "</topo_geometry>";
        return string;
    }
}

