/*
 * Decompiled with CFR 0.152.
 */
package oracle.mapviewer.share;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import oracle.mapviewer.share.FeatureDescriptor;
import oracle.mapviewer.share.SimpleFeatureI;

public class FeatureGroup
implements Serializable {
    FeatureDescriptor type;
    List<SimpleFeatureI> features = null;
    String name;
    int srid = -1;
    boolean geodeticSrid = false;
    double[] mbr;

    public int getSrid() {
        return this.srid;
    }

    public void setSrid(int n) {
        this.srid = n;
    }

    public boolean isGeodeticSrid() {
        return this.geodeticSrid;
    }

    public void setIsGeodeticSrid(boolean bl) {
        this.geodeticSrid = bl;
    }

    public double[] getMbr() {
        return this.mbr;
    }

    public void setMbr(double[] dArray) {
        this.mbr = dArray;
    }

    public FeatureGroup(String string) {
        this.name = string;
        this.features = new ArrayList<SimpleFeatureI>();
    }

    public FeatureGroup(int n, String string) {
        this.name = string;
        this.features = new ArrayList<SimpleFeatureI>(n);
    }

    public void setType(FeatureDescriptor featureDescriptor) {
        this.type = featureDescriptor;
    }

    public FeatureDescriptor getType() {
        return this.type;
    }

    public List<SimpleFeatureI> getFeatures() {
        return this.features;
    }

    public void addFeature(SimpleFeatureI simpleFeatureI) {
        this.features.add(simpleFeatureI);
        this.updateMBR(simpleFeatureI);
        if (this.srid < 0) {
            this.srid = simpleFeatureI.getGeometry().srid;
        }
    }

    public String getName() {
        return this.name;
    }

    private void updateMBR(SimpleFeatureI simpleFeatureI) {
        if (this.mbr == null) {
            this.mbr = new double[4];
            this.mbr[0] = Double.POSITIVE_INFINITY;
            this.mbr[1] = Double.POSITIVE_INFINITY;
            this.mbr[2] = Double.NEGATIVE_INFINITY;
            this.mbr[3] = Double.NEGATIVE_INFINITY;
        }
        if (simpleFeatureI != null && simpleFeatureI.getGeometry() != null) {
            double[] dArray = simpleFeatureI.getGeometry().getMbr();
            if (dArray == null) {
                return;
            }
            if (this.mbr[0] > dArray[0]) {
                this.mbr[0] = dArray[0];
            }
            if (this.mbr[1] > dArray[1]) {
                this.mbr[1] = dArray[1];
            }
            if (dArray.length == 4) {
                if (this.mbr[2] < dArray[2]) {
                    this.mbr[2] = dArray[2];
                }
                if (this.mbr[3] < dArray[3]) {
                    this.mbr[3] = dArray[3];
                }
            } else {
                if (this.mbr[2] < dArray[3]) {
                    this.mbr[2] = dArray[3];
                }
                if (this.mbr[3] < dArray[4]) {
                    this.mbr[3] = dArray[4];
                }
            }
        }
    }
}

