/*
 * Decompiled with CFR 0.152.
 */
package oracle.lbs.mapclient;

import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

class GeoFeature
implements Serializable {
    static final long serialVersionUID = 1308025278521145831L;
    private Object id;
    private int srid = 0;
    private String label = null;
    private String labelStyleName = null;
    private String renderStyleName = null;
    private int markerStyleSize = 0;
    private double[] radius = null;
    private double cx;
    private double cy;
    private int geomType;
    private double[][] coords;
    Object[] attrs = null;
    private boolean forcedLabeling = false;
    private double orient_x = 0.0;
    private double orient_y = 0.0;
    private double orient_z = 0.0;
    private boolean selectableInSVG = false;
    private String hiddenInfo = null;
    private String onClick = null;

    public GeoFeature() {
    }

    public GeoFeature(double d, double d2) {
        this.cx = d;
        this.cy = d2;
        this.geomType = 1;
    }

    public void setLineString(double[] dArray) {
        this.geomType = 2;
        this.cx = 0.0;
        this.cy = 0.0;
        this.coords = new double[1][];
        this.coords[0] = dArray;
    }

    public void setPolygon(double[][] dArray) {
        this.geomType = 3;
        this.cx = 0.0;
        this.cy = 0.0;
        this.coords = dArray;
    }

    public Point2D getCenterAsPoint2D() {
        return new Point2D.Double(this.cx, this.cy);
    }

    double getCenterX() {
        return this.cx;
    }

    double getCenterY() {
        return this.cy;
    }

    public int getGeomType() {
        return this.geomType;
    }

    public void setGeomType(int n) {
        this.geomType = n;
    }

    public int getSrid() {
        return this.srid;
    }

    public void setSrid(int n) {
        this.srid = n;
    }

    public void setMarkerOrientation(double d, double d2, double d3) {
        this.orient_x = d;
        this.orient_y = d2;
        this.orient_z = d3;
    }

    public double getOrientationX() {
        return this.orient_x;
    }

    public double getOrientationY() {
        return this.orient_y;
    }

    public double getOrientationZ() {
        return this.orient_z;
    }

    public double[][] getCoordinates() {
        return this.coords;
    }

    public Object[] getAttrs() {
        return this.attrs;
    }

    public void setAttrs(Object[] objectArray) {
        this.attrs = objectArray;
    }

    public String getID() {
        return this.id == null ? null : this.id.toString();
    }

    public void setID(Object object) {
        this.id = object;
    }

    public String getRenderStyleName() {
        return this.renderStyleName;
    }

    public void setRenderStyleName(String string) {
        this.renderStyleName = string;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public String getLabelStyleName() {
        return this.labelStyleName;
    }

    public void setLabelStyleName(String string) {
        this.labelStyleName = string;
    }

    public int getMarkerStyleSize() {
        return this.markerStyleSize;
    }

    public void setMarkerStyleSize(int n) {
        this.markerStyleSize = n;
    }

    public void setCenter(double d, double d2) {
        this.cx = d;
        this.cy = d2;
        this.geomType = 1;
    }

    public double[] getRadius() {
        return this.radius;
    }

    public void setRadius(double[] dArray) {
        this.radius = dArray;
    }

    public void setLabelAlwaysOn(boolean bl) {
        this.forcedLabeling = bl;
    }

    public boolean labelAlwaysOn() {
        return this.forcedLabeling;
    }

    public void setHiddenInfo(String string) {
        this.hiddenInfo = string;
    }

    public String getHiddenInfo() {
        return this.hiddenInfo;
    }

    public void setSelectableInSVG(boolean bl) {
        this.selectableInSVG = bl;
    }

    public boolean selectableInSVG() {
        return this.selectableInSVG;
    }

    public void setOnClick(String string) {
        this.onClick = string;
    }

    public String getOnClick() {
        return this.onClick;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("GeoFeature:\n");
        stringBuffer.append("  id=" + this.id);
        stringBuffer.append("\n  srid=" + this.srid);
        stringBuffer.append("\n  label=" + this.label);
        stringBuffer.append("\n  labelStyleName=" + this.labelStyleName);
        stringBuffer.append("\n  renderStyleName=" + this.renderStyleName);
        stringBuffer.append("\n  markerStyleSize=" + this.markerStyleSize);
        stringBuffer.append("\n  radius=" + this.radius);
        stringBuffer.append("\n  x=" + this.cx + ", y=" + this.cy);
        stringBuffer.append("\n  orient_x=" + this.orient_x + ", orient_y=" + this.orient_y + ", orient_z=" + this.orient_z);
        return stringBuffer.toString();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.id);
        objectOutputStream.writeInt(this.srid);
        objectOutputStream.writeObject(this.label);
        objectOutputStream.writeObject(this.labelStyleName);
        objectOutputStream.writeObject(this.renderStyleName);
        objectOutputStream.writeInt(this.markerStyleSize);
        objectOutputStream.writeObject(this.radius);
        objectOutputStream.writeDouble(this.cx);
        objectOutputStream.writeDouble(this.cy);
        objectOutputStream.writeInt(this.geomType);
        objectOutputStream.writeObject(this.coords);
        objectOutputStream.writeDouble(this.orient_x);
        objectOutputStream.writeDouble(this.orient_y);
        objectOutputStream.writeDouble(this.orient_z);
        objectOutputStream.writeObject(this.attrs);
        objectOutputStream.writeObject(this.hiddenInfo);
        objectOutputStream.writeBoolean(this.selectableInSVG);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.id = (String)objectInputStream.readObject();
        this.srid = objectInputStream.readInt();
        this.label = (String)objectInputStream.readObject();
        this.labelStyleName = (String)objectInputStream.readObject();
        this.renderStyleName = (String)objectInputStream.readObject();
        this.markerStyleSize = objectInputStream.readInt();
        this.radius = (double[])objectInputStream.readObject();
        this.cx = objectInputStream.readDouble();
        this.cy = objectInputStream.readDouble();
        this.geomType = objectInputStream.readInt();
        this.coords = (double[][])objectInputStream.readObject();
        this.orient_x = objectInputStream.readDouble();
        this.orient_y = objectInputStream.readDouble();
        this.orient_z = objectInputStream.readDouble();
        this.attrs = (Object[])objectInputStream.readObject();
        this.hiddenInfo = (String)objectInputStream.readObject();
        this.selectableInSVG = objectInputStream.readBoolean();
    }

    public String toXMLString() {
        StringBuffer stringBuffer = new StringBuffer(512);
        this.toXMLString(stringBuffer);
        return stringBuffer.toString();
    }

    public void toXMLString(StringBuffer stringBuffer) {
        String string;
        String string2;
        stringBuffer.append("  <geoFeature\n     render_style=\"" + this.getRenderStyleName() + "\"\n");
        double[] dArray = this.getRadius();
        if (dArray != null && dArray.length > 0) {
            stringBuffer.append("     radius=\"");
            for (int i = 0; i < dArray.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(dArray[i]);
            }
            stringBuffer.append("\"\n");
        }
        if ((string2 = this.getLabel()) != null && string2.length() > 0) {
            stringBuffer.append("     label=\"" + string2 + "\"\n");
        }
        if ((string = this.getLabelStyleName()) != null && string.length() > 0) {
            stringBuffer.append("     text_style=\"" + string + "\"\n");
        }
        if (this.forcedLabeling) {
            stringBuffer.append("     label_always_on=\"true\"\n");
        }
        if (this.getMarkerStyleSize() > 0) {
            stringBuffer.append("     marker_size=\"" + this.getMarkerStyleSize() + "\"\n");
        }
        if (this.attrs != null) {
            stringBuffer.append("   attribute_values=\"");
            for (int i = 0; i < this.attrs.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(this.attrs[i].toString());
            }
            stringBuffer.append("\"");
        }
        if (this.geomType == 1 && (this.orient_x != 0.0 || this.orient_y != 0.0 || this.orient_z != 0.0)) {
            stringBuffer.append("     orient_x=\"" + this.getOrientationX() + "\"\n");
            stringBuffer.append("     orient_y=\"" + this.getOrientationY() + "\"\n");
            stringBuffer.append("     orient_z=\"" + this.getOrientationZ() + "\"\n");
        }
        if (this.id != null) {
            stringBuffer.append("     id=\"" + this.id.toString() + "\"\n");
        }
        if (this.hiddenInfo != null) {
            stringBuffer.append("     hidden_info=\"" + this.hiddenInfo + "\"\n");
        }
        if (this.selectableInSVG && this.id != null) {
            stringBuffer.append("     selectable_in_svg=\"" + this.selectableInSVG + "\"\n");
        }
        if (this.onClick != null) {
            stringBuffer.append("     onclick=\"" + this.onClick + "\"\n");
        }
        stringBuffer.append("  >\n");
        switch (this.geomType) {
            case 1: {
                if (this.coords != null && this.coords.length != 0) break;
                Point2D point2D = this.getCenterAsPoint2D();
                String string3 = this.srid <= 0 ? "<Point>\n" : "<Point srsName=\"sdo:" + this.srid + "\">\n";
                stringBuffer.append("    <geometricProperty>\n      " + string3 + "        <coordinates>" + point2D.getX() + "," + point2D.getY() + "</coordinates>\n" + "      </Point>\n" + "    </geometricProperty>\n");
                break;
            }
            case 2: {
                double[] dArray2 = this.coords[0];
                String string4 = this.srid <= 0 ? "<LineString>\n" : "<LineString srsName=\"sdo:" + this.srid + "\">\n";
                stringBuffer.append("    <geometricProperty>\n       " + string4 + "         <coordinates>\n");
                for (int i = 0; i < dArray2.length; ++i) {
                    stringBuffer.append(dArray2[i] + (i % 2 == 0 && i < dArray2.length - 1 ? "," : " "));
                }
                stringBuffer.append("\n        </coordinates>\n       </LineString>\n    </geometricProperty>\n");
                break;
            }
            case 3: {
                int n;
                String string5 = this.srid <= 0 ? "<Polygon>\n" : "<Polygon srsName=\"sdo:" + this.srid + "\">\n";
                double[] dArray3 = this.coords[0];
                stringBuffer.append("    <geometricProperty>\n       " + string5 + "       <outerBoundaryIs>\n" + "         <LinearRing>\n" + "         <coordinates>\n");
                for (n = 0; n < dArray3.length; ++n) {
                    stringBuffer.append(dArray3[n] + (n % 2 == 0 && n < dArray3.length - 1 ? "," : " "));
                }
                stringBuffer.append("\n        </coordinates>\n\n        </LinearRing>\n       </outerBoundaryIs>\n");
                for (n = 1; n < this.coords.length; ++n) {
                    stringBuffer.append("      <innerBoundaryIs>\n         <LinearRing>\n        <coordinates>\n");
                    double[] dArray4 = this.coords[n];
                    if (dArray4 == null) continue;
                    for (int i = 0; i < dArray4.length; ++i) {
                        stringBuffer.append(dArray4[i] + (i % 2 == 0 && i < dArray4.length - 1 ? "," : " "));
                    }
                    stringBuffer.append("\n        </coordinates>\n\n        </LinearRing>\n       </innerBoundaryIs>\n");
                }
                stringBuffer.append("     </Polygon>\n    </geometricProperty>\n");
            }
        }
        stringBuffer.append("  </geoFeature>\n");
    }
}

