/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.ui;

import java.awt.event.ActionEvent;
import javax.swing.JPanel;
import oracle.dbtools.rest.RestArb;
import oracle.dbtools.rest.ui.RestBaseDialog;
import oracle.dbtools.rest.ui.RestExportPanel;
import oracle.dbtools.rest.utils.RestUtils;

public class RestExportDialog
extends RestBaseDialog {
    private RestExportPanel _exportPanel;

    public RestExportDialog(String string, String string2) {
        super(RestExportDialog.getTitle(string), RestExportDialog.getHelpId(string), true);
        this.initPanel(string, string2);
    }

    private void initPanel(String string, String string2) {
        this._exportPanel = new RestExportPanel(string, string2);
        this.setPanel(this._exportPanel);
        this.setDialogDimension(500, 300);
    }

    private static String getTitle(String string) {
        return RestArb.format("EXPORT_TITLE", RestUtils.getNLSObjectType(string));
    }

    private static String getHelpId(String string) {
        switch (string) {
            case "REST_MODULE": {
                return "f1_rest_export_module_html";
            }
            case "REST_MODULE_FOLDER": {
                return "f1_rest_export_module_html";
            }
            case "REST_PRIVILEGE": {
                return "f1_rest_export_privilege_html";
            }
            case "REST_PRIVILEGE_FOLDER": {
                return "f1_rest_export_privilege_html";
            }
            case "REST_ROLE": {
                return "f1_rest_export_privilege_html";
            }
            case "REST_ROLE_FOLDER": {
                return "f1_rest_export_privilege_html";
            }
        }
        return "";
    }

    public boolean includeEnableSchema() {
        return this._exportPanel.isExportEnableSchema();
    }

    public boolean includePrivileges() {
        return this._exportPanel.isExportPrivileges();
    }

    public boolean includeModules() {
        return this._exportPanel.isExportModules();
    }

    public String getFileName() {
        return this._exportPanel.getFileName();
    }

    public String getEncoding() {
        return this._exportPanel.getEncoding();
    }

    @Override
    protected JPanel getPanel() {
        return this._exportPanel;
    }

    @Override
    public String getObject() {
        return this._exportPanel.getValues();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this._exportPanel.validInfo()) {
            this.getDialog().dispose();
        } else if (this._exportPanel.hasErrors()) {
            this.showError(this._exportPanel.getErrorMessage());
        }
    }

    @Override
    public void removeListeners() {
        this._exportPanel.removeListeners();
    }
}

