/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.navigator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.raptor.BaseRaptorFilter;
import oracle.ide.explorer.TNode;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.model.UpdateMessage;

public class RestNavFilter
extends BaseRaptorFilter {
    private List<Element> m_children;

    public TNode childrenAdded(UpdateMessage updateMessage, TNode tNode, TreeExplorer treeExplorer) {
        for (Object e : updateMessage.getAddObjects()) {
            Element element = (Element)e;
            TNode tNode2 = treeExplorer.addChild(element, tNode, treeExplorer.getTreeModel());
            this.cache(tNode2);
            this.add(element);
        }
        return null;
    }

    private void add(Element element) {
        if (this.m_children != null && !this.m_children.contains(element)) {
            this.m_children.add(element);
        }
    }

    public TNode childrenRemoved(UpdateMessage updateMessage, TNode tNode, TreeExplorer treeExplorer) {
        for (Object e : updateMessage.getRemoveObjects()) {
            Element element = (Element)e;
            TNode tNode2 = this.lookup(element);
            if (tNode2 != null) {
                treeExplorer.removeChild(tNode2, treeExplorer.getTreeModel());
                this.uncache(tNode2);
            }
            this.remove(element);
        }
        return null;
    }

    private void remove(Element element) {
        if (this.m_children != null && this.m_children.contains(element)) {
            this.m_children.remove(element);
        }
    }

    public void closeChildren() {
        this.m_children = null;
        this.clearCache();
    }

    public Iterator<Element> getChildren() {
        if (this.m_children == null) {
            this.m_children = this.loadChildren();
        }
        return this.m_children.iterator();
    }

    private List<Element> loadChildren() {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        return arrayList;
    }

    protected Object getKey(Object object) {
        if (object instanceof Locatable) {
            return ((Locatable)object).getURL();
        }
        return null;
    }
}

