/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.install.wizard;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Arrays;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import oracle.dbtools.common.util.Passwords;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.rest.RestArb;
import oracle.dbtools.rest.install.InstallUtils;
import oracle.dbtools.rest.install.InstallValidator;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;

public class InstallWizORDSUsersPanel
extends DefaultTraversablePanel {
    private JTextField m_adminUsername = new JTextField();
    private JPasswordField m_adminPassword = new JPasswordField();
    private JPasswordField m_adminConfirmPassword = new JPasswordField();
    private JTextField m_restUsername = new JTextField();
    private JPasswordField m_restPassword = new JPasswordField();
    private JPasswordField m_restConfirmPassword = new JPasswordField();
    private JCheckBox m_verifySSL = new JCheckBox();

    public InstallWizORDSUsersPanel() {
        this.buildPanel();
    }

    private void buildPanel() {
        this.setLayout(new GridBagLayout());
        this.m_verifySSL.setSelected(true);
        this.m_adminPassword.setEnabled(false);
        this.m_adminConfirmPassword.setEnabled(false);
        this.m_restPassword.setEnabled(false);
        this.m_restConfirmPassword.setEnabled(false);
        JLabel jLabel = new JLabel();
        JLabel jLabel2 = new JLabel();
        JLabel jLabel3 = new JLabel();
        JLabel jLabel4 = new JLabel();
        JLabel jLabel5 = new JLabel();
        JLabel jLabel6 = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.m_adminUsername, (String)RestArb.getString("USERNAME"));
        ResourceUtils.resLabel((JLabel)jLabel2, (Component)this.m_adminPassword, (String)RestArb.getString("PASSWORD"));
        ResourceUtils.resLabel((JLabel)jLabel3, (Component)this.m_adminConfirmPassword, (String)RestArb.getString("CONFIRM_PASSWORD"));
        ResourceUtils.resLabel((JLabel)jLabel4, (Component)this.m_restUsername, (String)RestArb.getString("USERNAME"));
        ResourceUtils.resLabel((JLabel)jLabel5, (Component)this.m_restPassword, (String)RestArb.getString("PASSWORD"));
        ResourceUtils.resLabel((JLabel)jLabel6, (Component)this.m_restConfirmPassword, (String)RestArb.getString("CONFIRM_PASSWORD"));
        ResourceUtils.resButton((AbstractButton)this.m_verifySSL, (String)RestArb.getString("WIZ_VERIFY_SSL"));
        JTextPane jTextPane = new JTextPane();
        jTextPane.setText(RestArb.getString("WIZ_ADMIN_USER_DESCRIP"));
        jTextPane.setEditable(false);
        jTextPane.setOpaque(false);
        jTextPane.setRequestFocusEnabled(false);
        jTextPane.setFocusable(false);
        int n = 0;
        JPanel jPanel = LayoutControl.GBC.createPanel();
        jPanel.add((Component)jTextPane, LayoutControl.GBC.gbc((int)0, (int)n, (int)2, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        jPanel.add((Component)jLabel, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP));
        jPanel.add((Component)this.m_adminUsername, LayoutControl.GBC.gbc((int)1, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        jPanel.add((Component)jLabel2, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP));
        jPanel.add((Component)this.m_adminPassword, LayoutControl.GBC.gbc((int)1, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        jPanel.add((Component)jLabel3, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP));
        jPanel.add((Component)this.m_adminConfirmPassword, LayoutControl.GBC.gbc((int)1, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        LayoutControl.GBC.addVSpring((JPanel)jPanel, (int)(++n));
        JPanel jPanel2 = LayoutControl.GBC.createTitledSubPanel((String)RestArb.getString("WIZ_TITLE_ORDS_ADMIN"), (Component)jPanel);
        JTextPane jTextPane2 = new JTextPane();
        jTextPane2.setText(RestArb.getString("WIZ_REST_USER_DESCRIP"));
        jTextPane2.setEditable(false);
        jTextPane2.setOpaque(false);
        jTextPane2.setRequestFocusEnabled(false);
        jTextPane2.setFocusable(false);
        n = 0;
        JPanel jPanel3 = LayoutControl.GBC.createPanel();
        jPanel3.add((Component)jTextPane2, LayoutControl.GBC.gbc((int)0, (int)n, (int)2, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        jPanel3.add((Component)jLabel4, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP));
        jPanel3.add((Component)this.m_restUsername, LayoutControl.GBC.gbc((int)1, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        jPanel3.add((Component)jLabel5, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP));
        jPanel3.add((Component)this.m_restPassword, LayoutControl.GBC.gbc((int)1, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        jPanel3.add((Component)jLabel6, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP));
        jPanel3.add((Component)this.m_restConfirmPassword, LayoutControl.GBC.gbc((int)1, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        LayoutControl.GBC.addVSpring((JPanel)jPanel3, (int)(++n));
        JPanel jPanel4 = LayoutControl.GBC.createTitledSubPanel((String)RestArb.getString("WIZ_TITLE_REST_USER"), (Component)jPanel3);
        n = 0;
        this.add(jPanel2, LayoutControl.GBC.gbc((int)0, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        this.add(jPanel4, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.SECTION_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        this.add(this.m_verifySSL, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.SECTION_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.NONE));
        LayoutControl.GBC.addVSpring((JPanel)((Object)this), (int)(++n));
        this.m_adminUsername.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                InstallWizORDSUsersPanel.this.enableDisablePasswords(InstallWizORDSUsersPanel.this.m_adminUsername, InstallWizORDSUsersPanel.this.m_adminPassword, InstallWizORDSUsersPanel.this.m_adminConfirmPassword);
            }
        });
        this.m_restUsername.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                InstallWizORDSUsersPanel.this.enableDisablePasswords(InstallWizORDSUsersPanel.this.m_restUsername, InstallWizORDSUsersPanel.this.m_restPassword, InstallWizORDSUsersPanel.this.m_restConfirmPassword);
            }
        });
    }

    private void enableDisablePasswords(JTextField jTextField, JPasswordField jPasswordField, JPasswordField jPasswordField2) {
        boolean bl;
        boolean bl2 = bl = jTextField.getText().length() > 0 && jTextField.getText().trim().length() > 0;
        if (jPasswordField.isEnabled() != bl) {
            jPasswordField.setEnabled(bl);
            jPasswordField2.setEnabled(bl);
        }
    }

    private void validateValues() throws TraversalException {
        if (!InstallUtils.nullOrEmpty(this.m_adminUsername.getText())) {
            InstallValidator.validatePasswords(this.m_adminUsername.getText(), this.m_adminPassword, this.m_adminConfirmPassword);
        }
        if (!InstallUtils.nullOrEmpty(this.m_restUsername.getText())) {
            InstallValidator.validatePasswords(this.m_restUsername.getText(), this.m_restPassword, this.m_restConfirmPassword);
        }
        if (!InstallUtils.nullOrEmpty(this.m_adminUsername.getText()) && !InstallUtils.nullOrEmpty(this.m_restUsername.getText()) && this.m_adminUsername.getText().equals(this.m_restUsername.getText()) && this.m_adminPassword.getPassword() != null && this.m_adminPassword.getPassword().length > 0 && this.m_restPassword != null && this.m_restPassword.getPassword().length > 0 && !Arrays.equals(this.m_adminPassword.getPassword(), this.m_restPassword.getPassword())) {
            this.m_adminPassword.requestFocus();
            throw new TraversalException(RestArb.getString("ERROR_PASSWORD_NOT_SAME"));
        }
    }

    public void onEntry(TraversableContext traversableContext) {
        traversableContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
        if (traversableContext.getDirection() == 1) {
            Map map = (Map)traversableContext.get("ORDS_PARAMS");
            Map map2 = (Map)map.get("INSTALL_KEY_PARAMS");
            if (map2.get("ords.admin.username") != null) {
                this.m_adminUsername.setText((String)map2.get("ords.admin.username"));
                this.enableDisablePasswords(this.m_adminUsername, this.m_adminPassword, this.m_adminConfirmPassword);
            }
            if (map2.get("ords.sqldev.username") != null) {
                this.m_restUsername.setText((String)map2.get("ords.sqldev.username"));
                this.enableDisablePasswords(this.m_restUsername, this.m_restPassword, this.m_restConfirmPassword);
            }
        }
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        if (traversableContext.getDirection() == 1) {
            String string;
            this.validateValues();
            Map map = (Map)traversableContext.get("ORDS_PARAMS");
            Map map2 = (Map)map.get("INSTALL_KEY_PARAMS");
            if (!InstallUtils.nullOrEmpty(this.m_adminUsername.getText())) {
                map2.put("ords.admin.username", this.m_adminUsername.getText());
                string = "@" + Passwords.goingOut((char[])this.m_adminPassword.getPassword());
                map2.put("ords.admin.password", string);
            } else {
                map2.remove("ords.admin.username");
                map2.remove("ords.admin.password");
            }
            if (!InstallUtils.nullOrEmpty(this.m_restUsername.getText())) {
                map2.put("ords.sqldev.username", this.m_restUsername.getText());
                string = "@" + Passwords.goingOut((char[])this.m_restPassword.getPassword());
                map2.put("ords.sqldev.password", string);
            } else {
                map2.remove("ords.sqldev.username");
                map2.remove("ords.sqldev.password");
            }
            if (!this.m_verifySSL.isSelected()) {
                map2.put("security.verifySSL", Boolean.toString(this.m_verifySSL.isSelected()));
            }
        }
    }

    public Object getExitTransition() {
        return "Transition.Finish";
    }
}

