/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.install.wizard;

import java.awt.Component;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Map;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.rest.RestArb;
import oracle.dbtools.rest.install.InstallDBUtils;
import oracle.dbtools.rest.install.InstallUtils;
import oracle.dbtools.rest.install.wizard.InstallDBAUserDialog;
import oracle.ide.controls.WaitCursor;

public class InstallVerifyUserDialog
extends InstallDBAUserDialog {
    private Map<String, String> m_userAccounts;
    private String m_url;
    private String[] m_usernames;
    private String m_tnsAdminDir;

    public InstallVerifyUserDialog() {
        super(RestArb.getString("VERIFY_DB_USERS_ACCT"), RestArb.getString("VERIFY_USER_DBA_PRIV_DESCRIP"), "install_verify_user_dba_credentials_html");
    }

    public boolean checkUser(Component component, String string, String[] stringArray, String string2) {
        this.m_url = string;
        this.m_usernames = stringArray;
        this.m_tnsAdminDir = string2;
        return this.runDialog(component);
    }

    public Map<String, String> getUserAccounts() {
        return this.m_userAccounts;
    }

    public String getErrorMessage() {
        return this.getErrMsg().toString();
    }

    @Override
    protected boolean validInfo() {
        if (super.validInfo()) {
            return this.verifyUsers();
        }
        return false;
    }

    private boolean verifyUsers() {
        Boolean bl;
        block2: {
            final WaitCursor waitCursor = new WaitCursor((Component)this.m_dialog);
            RaptorTask<Boolean> raptorTask = new RaptorTask<Boolean>(RestArb.getString("RETRIEVING"), true, IRaptorTaskRunMode.MODAL){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected Boolean doWork() throws TaskException {
                    String string = null;
                    String string2 = InstallVerifyUserDialog.this.m_tnsAdminDir;
                    if (!(InstallUtils.nullOrEmpty(string2) || !InstallUtils.nullOrEmpty(string = System.getProperty("oracle.net.tns_admin")) && string2.equalsIgnoreCase(string))) {
                        System.setProperty("oracle.net.tns_admin", string2);
                    }
                    boolean bl = false;
                    Connection connection = null;
                    String string3 = InstallDBUtils.getDBAUsername(InstallVerifyUserDialog.this.getUsername());
                    try {
                        connection = DriverManager.getConnection(InstallVerifyUserDialog.this.m_url, string3, new String(InstallVerifyUserDialog.this.getPassword()));
                        InstallVerifyUserDialog.this.m_userAccounts = InstallDBUtils.getUsersStatus(connection, InstallVerifyUserDialog.this.m_usernames);
                        bl = true;
                    }
                    catch (SQLException sQLException) {
                        if (InstallVerifyUserDialog.this.getErrMsg().length() > 0) {
                            InstallVerifyUserDialog.this.getErrMsg().append("\n");
                        }
                        InstallVerifyUserDialog.this.getErrMsg().append(RestArb.format("ERR_CONN_FAILED", string3, InstallVerifyUserDialog.this.m_url, sQLException.getLocalizedMessage()));
                        if (sQLException.getErrorCode() == 1017) {
                        } else {
                            bl = true;
                        }
                    }
                    catch (Exception exception) {
                        if (InstallVerifyUserDialog.this.getErrMsg().length() > 0) {
                            InstallVerifyUserDialog.this.getErrMsg().append("\n");
                        }
                        InstallVerifyUserDialog.this.getErrMsg().append(RestArb.format("ERR_CONN_FAILED", string3, InstallVerifyUserDialog.this.m_url, exception.getLocalizedMessage()));
                    }
                    finally {
                        try {
                            if (connection != null && !connection.isClosed()) {
                                connection.close();
                            }
                        }
                        catch (SQLException sQLException) {}
                        if (!InstallUtils.nullOrEmpty(string2)) {
                            if (InstallUtils.nullOrEmpty(string)) {
                                System.clearProperty("oracle.net.tns_admin");
                            } else if (!string2.equalsIgnoreCase(string)) {
                                System.setProperty("oracle.net.tns_admin", string);
                            }
                        }
                    }
                    return bl;
                }
            };
            raptorTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

                public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
                    this.cleanup();
                }

                public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
                    this.cleanup();
                }

                public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                    this.cleanup();
                }

                private void cleanup() {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            waitCursor.hide();
                        }
                    });
                }
            });
            waitCursor.show();
            RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
            bl = Boolean.FALSE;
            try {
                bl = (Boolean)raptorTask.getResult();
            }
            catch (Exception exception) {
                if (this.getErrMsg().length() != 0) break block2;
                this.getErrMsg().append(exception.getLocalizedMessage());
            }
        }
        return bl;
    }
}

