/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.install;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import oracle.dbtools.common.util.Passwords;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.RaptorVersionTracker;
import oracle.dbtools.rest.RestArb;
import oracle.dbtools.rest.install.InstallUtils;
import oracle.dbtools.rest.model.RestSchema;
import oracle.dbtools.rest.utils.version.VersionFormat;
import oracle.jdbc.OracleCallableStatement;

public class InstallDBUtils {
    private static Logger logger = Logger.getLogger(InstallDBUtils.class.getName());
    public static final String ORDS_3_0_5_VERSION = "3.0.5.0.0";
    public static final String ORDS_3_0_7_VERSION = "3.0.7.0.0";
    public static final String ORDS_17_4_0_VERSION = "17.4.0.0.0";
    public static final String ORDS_18_1_1_VERSION = "18.1.1.0.0";
    private static final String SYS_USER = "SYS";
    private static final String APEX = "APEX";
    private static final String LOOKUP_SEPARATOR = "-";
    private static final String GET_ORDS_VERSION_SQL = "select version from ords_metadata.ords_version";
    private static final String GET_ORDS_REGISTRY_SQL = "declare\nregistered varchar2(5) := 'false';\nreg_version varchar2(30);\nreg_status  varchar2(30);\nbegin\n  if sys.dbms_registry.is_in_registry('ORDS') then\n    :registered := 'true';\n  end if;\n  :reg_version := sys.dbms_registry.version('ORDS');\n  :reg_status  := sys.dbms_registry.status('ORDS');\nend;\n";
    private static final String GET_APEX_REGISTRY_SQL = "declare\nregistered varchar2(5) := 'false';\nreg_version varchar2(30);\nreg_status  varchar2(30);\nbegin\n  if sys.dbms_registry.is_in_registry('APEX') then\n    :registered := 'true';\n  end if;\n  :reg_version := sys.dbms_registry.version('APEX');\n  :reg_status  := sys.dbms_registry.status('APEX');\nend;\n";
    private static final String GET_APEX_USERS_SQL = "select username from sys.dba_users where username in ('APEX_LISTENER','APEX_REST_PUBLIC_USER')";
    private static final String GET_ORDS_USERS_SQL = "select username from sys.dba_users where username in ('ORDS_METADATA','ORDS_PUBLIC_USER')";
    private static final String GET_SYSDBA_PRIV_SQL = "select privilege from sys.session_privs where privilege = 'SYSDBA'";
    private static final String IS_CDB_ROOT_SQL = "declare\nl_is_root VARCHAR2(10) := 'false';\nbegin\n  if (sys.dbms_db_version.VERSION >= 12) then\n  if (sys_context('USERENV','CON_NAME') = 'CDB$ROOT') then\n     :l_is_root := 'true';\n     end if;\n  end if;\nend;";
    private static final String SCHEMA_INFO_SQL = "select parsing_schema, type, pattern, status, auto_rest_auth, ords.installed_version ords_version from user_ords_schemas";
    private static HashMap<String, String[]> lookUp_Version = new HashMap();

    public static String getBasicUrl(String string, String string2, String string3, String string4) {
        String string5 = !InstallUtils.nullOrEmpty(string4) ? "jdbc:oracle:thin:@//" + string + ":" + string2 + "/" + string4 : "jdbc:oracle:thin:@" + string + ":" + string2 + ":" + string3;
        return string5;
    }

    public static String getUrl(Properties properties) {
        String string = properties.getProperty("db.connectionType");
        if (string == null) {
            return null;
        }
        Object object = null;
        switch (string) {
            case "basic": {
                String string2 = properties.getProperty("db.hostname");
                String string3 = properties.getProperty("db.port");
                String string4 = properties.getProperty("db.servicename");
                String string5 = properties.getProperty("db.sid");
                if (InstallUtils.nullOrEmpty(string2) || InstallUtils.nullOrEmpty(string3) || InstallUtils.nullOrEmpty(string4) && InstallUtils.nullOrEmpty(string5)) break;
                object = InstallDBUtils.getBasicUrl(string2, string3, string5, string4);
                break;
            }
            case "tns": {
                String string6 = properties.getProperty("db.tnsAliasName");
                if (InstallUtils.nullOrEmpty(string6)) break;
                object = "jdbc:oracle:thin:@" + string6;
                break;
            }
            case "customurl": {
                String string7 = properties.getProperty("db.customURL");
                object = string7;
            }
        }
        return object;
    }

    public static String getORDSVersion(Connection connection) {
        String string = DBUtil.getInstance((Connection)connection).executeReturnOneCol(GET_ORDS_VERSION_SQL);
        if (string == null) {
            return "";
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getRegistryVersion(Connection connection, String string, boolean bl) throws Exception {
        boolean bl2;
        String string2;
        String string3;
        block15: {
            string3 = null;
            string2 = null;
            bl2 = false;
            OracleCallableStatement oracleCallableStatement = null;
            if (Connections.getInstance().lock(connection)) {
                try {
                    oracleCallableStatement = (OracleCallableStatement)connection.prepareCall(string);
                    oracleCallableStatement.registerOutParameter(1, 12);
                    oracleCallableStatement.registerOutParameter(2, 12);
                    oracleCallableStatement.registerOutParameter(3, 12);
                    oracleCallableStatement.execute();
                    bl2 = Boolean.parseBoolean(oracleCallableStatement.getString(1));
                    string3 = oracleCallableStatement.getString(2);
                    string2 = oracleCallableStatement.getString(3);
                    break block15;
                }
                finally {
                    Connections.getInstance().unlock(connection);
                    if (oracleCallableStatement != null) {
                        try {
                            oracleCallableStatement.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            logger.warning(RestArb.format("CONNECT_LOCK_FAILED", string));
            return null;
        }
        if (!bl2) {
            return "";
        }
        if (bl) {
            if (!InstallUtils.nullOrEmpty(string2) && string2.equalsIgnoreCase("VALID") && InstallDBUtils.validateVersion(string3)) {
                return string3;
            }
            String string4 = RestArb.format("ERR_ORDS_REGISTRY_VERSION_STATUS", string3, string2);
            throw new Exception(string4);
        }
        if (!InstallUtils.nullOrEmpty(string2) && string2.equalsIgnoreCase("VALID")) {
            return string3;
        }
        String string5 = RestArb.format("ERR_APEX_REGISTRY_VERSION_STATUS", string3, string2);
        throw new Exception(string5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isCDBRoot(Connection connection) throws Exception {
        boolean bl = false;
        if (RaptorVersionTracker.checkVersion((Connection)connection, null, (Version)new Version("12")) && Connections.getInstance().lock(connection)) {
            OracleCallableStatement oracleCallableStatement = null;
            try {
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall(IS_CDB_ROOT_SQL);
                oracleCallableStatement.registerOutParameter(1, 12);
                oracleCallableStatement.execute();
                bl = Boolean.parseBoolean(oracleCallableStatement.getString(1));
            }
            finally {
                Connections.getInstance().unlock(connection);
                if (oracleCallableStatement != null) {
                    try {
                        oracleCallableStatement.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return bl;
    }

    public static boolean userExist(Connection connection, String string) {
        String[] stringArray = new String[]{string};
        return InstallDBUtils.usersExists(connection, stringArray);
    }

    public static boolean usersExists(Connection connection, String[] stringArray) {
        Map<String, String> map = InstallDBUtils.getUsersStatus(connection, stringArray);
        for (String string : stringArray) {
            if (map.containsKey(string)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> getUserStatus(String string, String string2, String string3, String string4, String[] stringArray) throws Exception {
        Map<String, String> map;
        if (InstallUtils.nullOrEmpty(string) || InstallUtils.nullOrEmpty(string3) || InstallUtils.nullOrEmpty(string4)) {
            return null;
        }
        String string5 = string4;
        if (string4.startsWith("@")) {
            string5 = Passwords.comingIn((String)string5.substring(1));
        }
        String string6 = null;
        String string7 = string2;
        if (!(InstallUtils.nullOrEmpty(string7) || !InstallUtils.nullOrEmpty(string6 = System.getProperty("oracle.net.tns_admin")) && string7.equalsIgnoreCase(string6))) {
            System.setProperty("oracle.net.tns_admin", string7);
        }
        Connection connection = null;
        try {
            connection = DriverManager.getConnection(string, string3, string5);
            map = InstallDBUtils.getUsersStatus(connection, stringArray);
        }
        finally {
            try {
                if (connection != null && !connection.isClosed()) {
                    connection.close();
                }
            }
            catch (SQLException sQLException) {}
            string5 = null;
            if (!InstallUtils.nullOrEmpty(string7)) {
                if (InstallUtils.nullOrEmpty(string6)) {
                    System.clearProperty("oracle.net.tns_admin");
                } else if (!string7.equalsIgnoreCase(string6)) {
                    System.setProperty("oracle.net.tns_admin", string6);
                }
            }
        }
        return map;
    }

    public static Map<String, String> getUsersStatus(Connection connection, String[] stringArray) {
        String string = InstallDBUtils.buildUserQuery(stringArray, "account_status");
        return InstallDBUtils.getUsersInfo(connection, string);
    }

    public static Map<String, String> getUsersCommonIndicator(Connection connection, String[] stringArray) {
        String string = InstallDBUtils.buildUserQuery(stringArray, "common");
        return InstallDBUtils.getUsersInfo(connection, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> getUsersInfo(Connection connection, String string) {
        HashMap<String, String> hashMap;
        block5: {
            hashMap = new HashMap<String, String>();
            try {
                if (!Connections.getInstance().lock(connection)) break block5;
                ResultSet resultSet = null;
                try {
                    Map map = null;
                    resultSet = DBUtil.getInstance((Connection)connection).executeQuery(string, map);
                    while (resultSet.next()) {
                        String string2 = resultSet.getString(1);
                        String string3 = resultSet.getString(2);
                        hashMap.put(string2, string3);
                    }
                }
                catch (Throwable throwable) {
                    Connections.getInstance().unlock(connection);
                    DBUtil.closeResultSet(resultSet);
                    throw throwable;
                }
                Connections.getInstance().unlock(connection);
                DBUtil.closeResultSet((ResultSet)resultSet);
            }
            catch (SQLException sQLException) {
                logger.log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            }
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getNames(Connection connection, String string, Map<String, Object> map) {
        ArrayList<String> arrayList;
        block6: {
            arrayList = new ArrayList<String>();
            try {
                if (!Connections.getInstance().lock(connection)) break block6;
                ResultSet resultSet = null;
                try {
                    resultSet = DBUtil.getInstance((Connection)connection).executeQuery(string, map);
                    while (resultSet.next()) {
                        String string2 = resultSet.getString(1);
                        arrayList.add(string2);
                    }
                }
                finally {
                    Connections.getInstance().unlock(connection);
                    DBUtil.closeResultSet((ResultSet)resultSet);
                }
            }
            catch (SQLException sQLException) {
                logger.log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getNames(Connection connection, String string) {
        ArrayList<String> arrayList;
        block5: {
            arrayList = new ArrayList<String>();
            try {
                ResultSet resultSet;
                block6: {
                    if (!Connections.getInstance().lock(connection)) break block5;
                    resultSet = null;
                    try {
                        HashMap hashMap = new HashMap();
                        resultSet = DBUtil.getInstance((Connection)connection).executeQuery(string, hashMap);
                        if (resultSet == null) break block6;
                        while (resultSet.next()) {
                            String string2 = resultSet.getString(1);
                            arrayList.add(string2);
                        }
                    }
                    catch (Throwable throwable) {
                        Connections.getInstance().unlock(connection);
                        DBUtil.closeResultSet(resultSet);
                        throw throwable;
                    }
                }
                Connections.getInstance().unlock(connection);
                DBUtil.closeResultSet((ResultSet)resultSet);
            }
            catch (SQLException sQLException) {
                logger.log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, List<String>> getPdbsTablespaces(Connection connection, String string) {
        LinkedHashMap<String, List<String>> linkedHashMap;
        block7: {
            linkedHashMap = new LinkedHashMap<String, List<String>>();
            try {
                ResultSet resultSet;
                block8: {
                    if (!Connections.getInstance().lock(connection)) break block7;
                    resultSet = null;
                    try {
                        HashMap hashMap = new HashMap();
                        resultSet = DBUtil.getInstance((Connection)connection).executeQuery(string, hashMap);
                        ArrayList<String> arrayList = new ArrayList<String>();
                        String string2 = null;
                        String string3 = null;
                        String string4 = "";
                        while (resultSet.next()) {
                            string2 = resultSet.getString(1);
                            string3 = resultSet.getString(2);
                            if (!string4.equals(string2)) {
                                if (string4 != "") {
                                    linkedHashMap.put(string2, arrayList);
                                }
                                arrayList.clear();
                                string4 = string2;
                            }
                            arrayList.add(string3);
                        }
                        if (string2 == null) break block8;
                        linkedHashMap.put(string2, arrayList);
                    }
                    catch (Throwable throwable) {
                        Connections.getInstance().unlock(connection);
                        DBUtil.closeResultSet(resultSet);
                        throw throwable;
                    }
                }
                Connections.getInstance().unlock(connection);
                DBUtil.closeResultSet((ResultSet)resultSet);
            }
            catch (SQLException sQLException) {
                logger.log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            }
        }
        return linkedHashMap;
    }

    private static boolean validateVersion(String string) {
        if (!InstallUtils.nullOrEmpty(string)) {
            String string2 = "\\d{1,2}\\.\\d{1,2}\\.\\d{1,2}\\.[\\d]+\\.[\\d]+\\.[\\d]+";
            boolean bl = Pattern.matches(string2, string);
            return bl;
        }
        return false;
    }

    public static boolean isEarlierVersion(String string, String string2) throws Exception {
        return VersionFormat.isEarlierVersion(string, string2);
    }

    private static String getLookupKey(String string, String string2, String string3) {
        if (InstallUtils.nullOrEmpty(string) || InstallUtils.nullOrEmpty(string2) || InstallUtils.nullOrEmpty(string3)) {
            return null;
        }
        return string.toUpperCase() + LOOKUP_SEPARATOR + string2.toUpperCase() + LOOKUP_SEPARATOR + string3;
    }

    public static String getORDSRegistryVersion(Connection connection) throws Exception {
        return InstallDBUtils.getRegistryVersion(connection, GET_ORDS_REGISTRY_SQL, true);
    }

    public static String getAPEXRegistryVersion(Connection connection) throws Exception {
        return InstallDBUtils.getRegistryVersion(connection, GET_APEX_REGISTRY_SQL, false);
    }

    public static String getAPEXVersion(String string, String string2, String string3) {
        String[] stringArray;
        String string4 = InstallDBUtils.getLookupKey(string, string2, string3);
        if (string4 != null && (stringArray = lookUp_Version.get(string4)) != null && stringArray[0] == APEX) {
            return stringArray[1];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean canMigrateAPEXRest(String string, String string2, String string3, String string4, String string5) {
        int n;
        Object object;
        if (InstallUtils.nullOrEmpty(string) || InstallUtils.nullOrEmpty(string3) || InstallUtils.nullOrEmpty(string4)) {
            return false;
        }
        String string6 = InstallDBUtils.getLookupKey(string, string3, string5);
        if (string6 != null && (object = lookUp_Version.get(string6)) != null) {
            boolean bl = Boolean.parseBoolean(object[2]);
            return bl;
        }
        object = null;
        String string7 = string4;
        if (string4.startsWith("@")) {
            string7 = Passwords.comingIn((String)string7.substring(1));
        }
        String string8 = null;
        String string9 = string2;
        if (!(InstallUtils.nullOrEmpty(string9) || !InstallUtils.nullOrEmpty(string8 = System.getProperty("oracle.net.tns_admin")) && string9.equalsIgnoreCase(string8))) {
            System.setProperty("oracle.net.tns_admin", string9);
        }
        Connection connection = null;
        boolean bl = false;
        try {
            List<String> list;
            connection = DriverManager.getConnection(string, string3, string7);
            object = InstallDBUtils.getAPEXRegistryVersion(connection);
            if (object == null || ((String)object).isEmpty()) {
                String[] stringArray = new String[]{APEX, "", Boolean.toString(false)};
                lookUp_Version.put(string6, stringArray);
                boolean bl2 = false;
                return bl2;
            }
            int n2 = 0;
            n = string5.indexOf(46);
            if (n == -1) {
                boolean bl3 = false;
                return bl3;
            }
            n2 = Integer.parseInt(string5.substring(0, n));
            int n3 = 0;
            n = ((String)object).indexOf(46);
            if (n == -1) {
                boolean bl4 = false;
                return bl4;
            }
            n3 = Integer.parseInt(((String)object).substring(0, n));
            if (n2 >= 3 && (n3 >= 5 || ((String)object).startsWith("4.2."))) {
                bl = true;
            }
            if (bl && (list = InstallDBUtils.getNames(connection, GET_APEX_USERS_SQL)).contains("APEX_LISTENER") && list.contains("APEX_REST_PUBLIC_USER")) {
                String[] stringArray = new String[]{APEX, object, Boolean.toString(bl)};
                lookUp_Version.put(string6, stringArray);
                boolean bl5 = true;
                return bl5;
            }
            boolean bl6 = false;
            return bl6;
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            n = 0;
            return n != 0;
        }
        finally {
            try {
                if (connection != null && !connection.isClosed()) {
                    connection.close();
                }
            }
            catch (SQLException sQLException) {}
            string7 = null;
            if (!InstallUtils.nullOrEmpty(string9)) {
                if (InstallUtils.nullOrEmpty(string8)) {
                    System.clearProperty("oracle.net.tns_admin");
                } else if (!string9.equalsIgnoreCase(string8)) {
                    System.setProperty("oracle.net.tns_admin", string8);
                }
            }
        }
    }

    private static String buildUserQuery(String[] stringArray, String string) {
        if (stringArray != null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("select username, ").append(string).append(" from sys.dba_users where username in (");
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuilder.append("'").append(stringArray[i]).append("'");
                if (i + 1 >= stringArray.length) continue;
                stringBuilder.append(",");
            }
            stringBuilder.append(")");
            return stringBuilder.toString();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String validateConnection(String string, String string2, String string3, String string4) {
        String string5 = null;
        String string6 = string4;
        if (!(InstallUtils.nullOrEmpty(string6) || !InstallUtils.nullOrEmpty(string5 = System.getProperty("oracle.net.tns_admin")) && string6.equalsIgnoreCase(string5))) {
            System.setProperty("oracle.net.tns_admin", string6);
        }
        String string7 = null;
        String string8 = string3;
        if (string8.startsWith("@")) {
            string8 = Passwords.comingIn((String)string8.substring(1));
        }
        Connection connection = null;
        try {
            connection = DriverManager.getConnection(string, string2, string8);
        }
        catch (Exception exception) {
            string7 = exception.getLocalizedMessage();
        }
        finally {
            try {
                if (connection != null && !connection.isClosed()) {
                    connection.close();
                }
                connection = null;
            }
            catch (SQLException sQLException) {}
            string8 = null;
            if (!InstallUtils.nullOrEmpty(string6)) {
                if (InstallUtils.nullOrEmpty(string5)) {
                    System.clearProperty("oracle.net.tns_admin");
                } else if (!string6.equalsIgnoreCase(string5)) {
                    System.setProperty("oracle.net.tns_admin", string5);
                }
            }
        }
        return string7;
    }

    public static String getDBAUsername(String string) {
        String string2 = string.trim().toUpperCase();
        if (string2.equals(SYS_USER)) {
            return string + " AS SYSDBA";
        }
        return string;
    }

    public static List<String> getORDSDBUsers(Connection connection) {
        return InstallDBUtils.getNames(connection, GET_ORDS_USERS_SQL);
    }

    public static boolean hasSYSDBAPrivileges(Connection connection) {
        String string = DBUtil.getInstance((Connection)connection).executeReturnOneCol(GET_SYSDBA_PRIV_SQL);
        return string != null && string.equals("SYSDBA");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RestSchema getSchemaInfo(Connection connection) throws Exception {
        RestSchema restSchema;
        block17: {
            restSchema = null;
            String string = null;
            String string2 = null;
            String string3 = null;
            String string4 = null;
            String string5 = null;
            String string6 = null;
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            try {
                if (Connections.getInstance().lock(connection)) {
                    try {
                        preparedStatement = connection.prepareStatement(SCHEMA_INFO_SQL);
                        resultSet = preparedStatement.executeQuery();
                        while (resultSet.next()) {
                            string = resultSet.getString("parsing_schema");
                            string2 = resultSet.getString("type");
                            string3 = resultSet.getString("pattern");
                            string4 = resultSet.getString("status");
                            string5 = resultSet.getString("auto_rest_auth");
                            string6 = resultSet.getString("ords_version");
                        }
                        restSchema = new RestSchema(string, string2, string3, string4, string5, string6);
                        break block17;
                    }
                    finally {
                        if (resultSet != null) {
                            try {
                                resultSet.close();
                            }
                            catch (Exception exception) {}
                        }
                        if (preparedStatement != null) {
                            try {
                                preparedStatement.close();
                            }
                            catch (Exception exception) {}
                        }
                        Connections.getInstance().unlock(connection);
                    }
                }
                logger.warning(RestArb.format("CONNECT_LOCK_FAILED", SCHEMA_INFO_SQL));
                return null;
            }
            catch (SQLException sQLException) {
                logger.warning(RestArb.format("ERROR_REASON", RestArb.getString("TASK_RETRIEVE_SCHEMA"), sQLException.getLocalizedMessage()));
            }
        }
        return restSchema;
    }

    public static boolean isSysAsSysDba(String string) {
        return !InstallUtils.nullOrEmpty(string) && "SYS AS SYSDBA".equals(string.trim().toUpperCase());
    }
}

