/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.editor;

import java.awt.Component;
import java.awt.Container;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ide.util.MetaClass;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.utils.RaptorTaskWrapper;
import oracle.dbtools.rest.editor.RestWorksheetNode;
import oracle.dbtools.util.Resource;
import oracle.dbtools.worksheet.ActionProvider;
import oracle.dbtools.worksheet.WorksheetAction;
import oracle.dbtools.worksheet.WorksheetTaskWrapper;
import oracle.dbtools.worksheet.editor.Worksheet;
import oracle.dbtools.worksheet.editor.WorksheetGUI;
import oracle.dbtools.worksheet.extension.WorksheetHook;
import oracle.dbtools.worksheet.extension.WorksheetNode;
import oracle.ide.Context;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.help.HelpInfo;
import oracle.ide.model.Node;
import oracle.ide.view.View;

public class RestWorkSheet
extends Worksheet {
    private static final Logger LOGGER = Logger.getLogger(RestWorkSheet.class.getName());
    private Node m_node = null;
    private String m_dbConnName;
    private List<String> _currBindVars;
    private static final List<String> m_excludeProv = Arrays.asList("oracle.dbtools.worksheet.commands.TransactionControlProvider", "oracle.dbtools.worksheet.commands.UnsharedWorksheetActionProvider", "oracle.dbtools.worksheet.commands.CaseChangeActionProvider", "oracle.dbtools.worksheet.commands.sqltuningadvisor.SqlTuningAdvisorActionProvider");

    public RestWorkSheet(ArrayList<ActionProvider> arrayList, String string, List<String> arrayList2, String string2) {
        this.m_dbConnName = string2;
        ArrayList arrayList3 = this._currBindVars = arrayList2 == null ? new ArrayList() : arrayList2;
        if (arrayList == null) {
            arrayList = new ArrayList();
        }
        this.addActionProvider(arrayList);
        this.initContext(string2);
        Toolbar toolbar = this.getToolbar();
        Container container = (Container)this.getGUI();
        container.add((Component)toolbar, "North");
        if (string2 != null) {
            this.setComboConnection(string2);
        }
        if (!this._currBindVars.isEmpty()) {
            ((WorksheetGUI)this.getGUI()).setBindVariables(arrayList2);
        }
        this.setSQL(string);
    }

    protected void initContext(String string) {
        Context context = Context.newIdeContext((View)this.getViewWithoutDecoration());
        this.m_node = this.getTempNode(string);
        if (string != null) {
            context.setProperty("Connections.db_name", (Object)string);
        }
        context.setNode(this.m_node);
        this.setContext(context);
    }

    private WorksheetNode getTempNode(String string) {
        RestWorksheetNode restWorksheetNode = null;
        try {
            File file = File.createTempFile("rest", ".worksheet", Resource.RAPTOR_USER_TEMP);
            file.deleteOnExit();
            restWorksheetNode = new RestWorksheetNode(file.toURL());
            if (string != null) {
                restWorksheetNode.setConnectionName(string);
            }
        }
        catch (IOException iOException) {
            LOGGER.log(Level.WARNING, iOException.getLocalizedMessage());
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, exception.getLocalizedMessage());
        }
        return restWorksheetNode;
    }

    public void setSQL(String string) {
        String string2 = string != null ? string : "";
        this.createWorksheetContext().getEditor().setText(string2);
    }

    public String getText() {
        return this.getFocusedEditorPane().getText();
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_resthandler_html");
    }

    public void updateBindVariables(List<String> arrayList) {
        ArrayList<String> arrayList2;
        ArrayList<String> arrayList3 = arrayList2 = arrayList == null ? new ArrayList<String>() : arrayList;
        if (!this._currBindVars.equals(arrayList2)) {
            ((WorksheetGUI)this.getGUI()).setBindVariables(arrayList2);
            ((WorksheetGUI)this.getGUI()).invokeInsight(this.getConnectionName());
            this._currBindVars = arrayList2;
        }
    }

    public void saveHandler() {
        WorksheetTaskWrapper worksheetTaskWrapper;
        ActionProvider actionProvider = (ActionProvider)this.m_idMap.get("rest.SAVEHANDLER");
        if (actionProvider != null && (worksheetTaskWrapper = actionProvider.doAction("rest.SAVEHANDLER", this.createWorksheetContext())) != null) {
            RaptorTaskManager.getInstance().addTask((RaptorTaskWrapper)worksheetTaskWrapper);
        }
    }

    public String getDbConnectionName() {
        return this.m_dbConnName;
    }

    protected void initActions() {
        ActionProvider actionProvider;
        Iterator iterator = WorksheetHook.getProviders();
        while (iterator.hasNext()) {
            try {
                actionProvider = (ActionProvider)((MetaClass)iterator.next()).newInstance();
                if (m_excludeProv.contains(actionProvider.getClass().getName())) continue;
                this.m_providers.add(actionProvider);
                int n = actionProvider.getActionsCount();
                for (int i = 0; i < n; ++i) {
                    WorksheetAction.ActionType actionType;
                    WorksheetAction worksheetAction = actionProvider.getActionAt(i);
                    for (String string : actionType = worksheetAction.getIds()) {
                        this.m_idMap.put(string, actionProvider);
                        IdeAction ideAction = worksheetAction.getIdeAction(string);
                        this.m_actionMap.put(string, ideAction);
                    }
                    WorksheetAction.ActionType actionType2 = worksheetAction.getType();
                    if (actionType2.isToolbarAction()) {
                        this.m_toolbarActions.add(worksheetAction);
                    }
                    if (!actionType2.isContextMenuAction()) continue;
                    this.m_ctxMenuActions.add(worksheetAction);
                }
            }
            catch (InstantiationException instantiationException) {
                LOGGER.log(Level.WARNING, instantiationException.getStackTrace()[0].toString(), instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                LOGGER.log(Level.WARNING, illegalAccessException.getStackTrace()[0].toString(), illegalAccessException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                LOGGER.log(Level.WARNING, classNotFoundException.getStackTrace()[0].toString(), classNotFoundException);
            }
        }
        iterator = IdeAction.find((int)73);
        if (iterator != null) {
            iterator.addController(this.m_controller);
        }
        if ((actionProvider = IdeAction.find((int)74)) != null) {
            actionProvider.addController(this.m_controller);
        }
        IdeAction.find((String)"oracle.ide.ceditor.find.next").updateAction();
    }

    public void addActionProvider(ArrayList<ActionProvider> arrayList) {
        for (ActionProvider actionProvider : arrayList) {
            int n = actionProvider.getActionsCount();
            for (int i = 0; i < n; ++i) {
                WorksheetAction.ActionType actionType;
                WorksheetAction worksheetAction = actionProvider.getActionAt(i);
                for (String string : actionType = worksheetAction.getIds()) {
                    this.m_idMap.put(string, actionProvider);
                    IdeAction ideAction = worksheetAction.getIdeAction(string);
                    this.m_actionMap.put(string, ideAction);
                }
                WorksheetAction.ActionType actionType2 = worksheetAction.getType();
                if (actionType2.isToolbarAction()) {
                    this.m_toolbarActions.add(worksheetAction);
                    if (this.m_toolbar != null) {
                        // empty if block
                    }
                }
                if (!actionType2.isContextMenuAction()) continue;
                this.m_ctxMenuActions.add(worksheetAction);
            }
        }
    }
}

