/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.editor;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.utils.ConnectionDetails;
import oracle.dbtools.raptor.utils.ConnectionDisconnectListener;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DisconnectVetoException;
import oracle.dbtools.rest.RestArb;
import oracle.dbtools.rest.editor.RestEditor;
import oracle.dbtools.rest.editor.RestHandlerEditorPanel;
import oracle.dbtools.rest.editor.RestSaveHandlerActionProvider;
import oracle.dbtools.rest.model.RestResourceHandler;
import oracle.dbtools.rest.navigator.RestHandlerEditorNode;
import oracle.dbtools.rest.navigator.RestHandlerNode;
import oracle.dbtools.rest.utils.RestUtils;
import oracle.dbtools.worksheet.ActionProvider;
import oracle.ide.Ide;
import oracle.ide.cmd.ExitCommand;
import oracle.ide.cmd.ShutdownHook;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.help.HelpInfo;
import oracle.ide.model.UpdateMessage;
import oracle.ide.view.View;
import oracle.javatools.dialogs.MessageDialog;

public class RestHandlerEditor
extends RestEditor {
    private ConnectionDisconnectListener m_connDisconnListener = null;
    private ShutdownHook m_shutdownHook = null;
    private RestHandlerEditorPanel _gui = null;
    private boolean m_verifySave = true;

    public RestHandlerEditor() {
        this.init();
    }

    private void init() {
        this.m_connDisconnListener = new ConnectionDisconnectListener(){

            public void checkDisconnect(ConnectionDetails connectionDetails) throws DisconnectVetoException {
                if (RestHandlerEditor.this.isUsingRestApi()) {
                    String string = null;
                    Properties properties = connectionDetails.getConnectionProperties();
                    if (properties != null) {
                        string = properties.getProperty("Connections.db_name");
                    }
                    String string2 = RestHandlerEditor.this._gui.getRESTWorksheet().getDbConnectionName();
                    if (!RestUtils.nullOrEmpty(string) && !RestUtils.nullOrEmpty(string2) && string.equals(string2)) {
                        RestHandlerEditor.this.m_verifySave = true;
                        RestHandlerEditor.this.checkSaveHandler();
                        RestHandlerEditor.this.m_verifySave = false;
                    }
                }
            }

            public void connectionDisconnected(ConnectionDetails connectionDetails) {
                if (RestHandlerEditor.this.isUsingRestApi()) {
                    RestHandlerEditor.this.close();
                }
            }
        };
        Connections.getInstance().addConnectionDisconnectListener(this.m_connDisconnListener);
        this.m_shutdownHook = new ShutdownHook(){

            public boolean canShutdown() {
                if (RestHandlerEditor.this.isUsingRestApi()) {
                    RestHandlerEditor.this.checkSaveHandler();
                    RestHandlerEditor.this.m_verifySave = false;
                }
                return true;
            }

            public void shutdown() {
                RestHandlerEditor.this.close();
            }
        };
        ExitCommand.addShutdownHook((ShutdownHook)this.m_shutdownHook);
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_resthandlereditor_html");
    }

    public Component getGUI() {
        return this.getRESTfulHandlerGUI();
    }

    private RestHandlerEditorPanel getRESTfulHandlerGUI() {
        if (this._gui == null) {
            this._gui = this.initializeGUI();
            this.setUpUndoRedo();
        }
        return this._gui;
    }

    private boolean isUsingRestApi() {
        RestHandlerNode restHandlerNode = ((RestHandlerEditorNode)this.getContext().getNode()).getHandlerNode();
        return restHandlerNode.isUsingRestApi();
    }

    private RestHandlerEditorPanel initializeGUI() {
        RestHandlerNode restHandlerNode = ((RestHandlerEditorNode)this.getContext().getNode()).getHandlerNode();
        RestResourceHandler restResourceHandler = restHandlerNode.getUserObject();
        RestHandlerEditorPanel restHandlerEditorPanel = new RestHandlerEditorPanel(restResourceHandler);
        ArrayList<ActionProvider> arrayList = new ArrayList<ActionProvider>();
        ArrayList<IdeAction> arrayList2 = new ArrayList<IdeAction>();
        if (restHandlerNode.isUsingRestApi()) {
            RestSaveHandlerActionProvider restSaveHandlerActionProvider = new RestSaveHandlerActionProvider(restHandlerEditorPanel);
            arrayList.add(restSaveHandlerActionProvider);
            arrayList2.add(restSaveHandlerActionProvider.getActionAt(0).getIdeAction("rest.SAVEHANDLER"));
        } else {
            arrayList2.add(this.getPinAction());
        }
        restHandlerEditorPanel.initPanel(restHandlerNode, arrayList, arrayList2);
        return restHandlerEditorPanel;
    }

    public RestResourceHandler getResourceHandler() {
        return this._gui.getResourceHandler();
    }

    public int getNodeId() {
        RestHandlerEditorNode restHandlerEditorNode = (RestHandlerEditorNode)this.getContext().getNode();
        return restHandlerEditorNode != null ? restHandlerEditorNode.getHandlerNode().getNodeId() : 0;
    }

    public String getTemplateMethodId() {
        RestHandlerEditorNode restHandlerEditorNode = (RestHandlerEditorNode)this.getContext().getNode();
        return restHandlerEditorNode != null ? restHandlerEditorNode.getHandlerNode().getTemplateMethodId() : "";
    }

    public boolean refresh() {
        RestHandlerNode restHandlerNode;
        boolean bl = false;
        RestHandlerEditorNode restHandlerEditorNode = (RestHandlerEditorNode)this.getContext().getNode();
        if (restHandlerEditorNode != null && (restHandlerNode = restHandlerEditorNode.getHandlerNode()) != null) {
            bl = this._gui.refresh(restHandlerNode);
        }
        return bl;
    }

    public void saveResourceHandler() {
        RestHandlerNode restHandlerNode = ((RestHandlerEditorNode)this.getContext().getNode()).getHandlerNode();
        restHandlerNode.setUserObject(this._gui.getResourceHandler());
    }

    @Override
    public void open() {
        this.m_verifySave = true;
        super.open();
    }

    public void close() {
        try {
            if (this.m_verifySave) {
                this.checkSaveHandler();
            }
            this.saveResourceHandler();
        }
        catch (Exception exception) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        finally {
            Connections.getInstance().removeConnectionDisconnectListener(this.m_connDisconnListener);
            ExitCommand.removeShutdownHook((ShutdownHook)this.m_shutdownHook);
            this.m_connDisconnListener = null;
            this.m_shutdownHook = null;
        }
        super.close();
    }

    public boolean checkSaveHandler() {
        boolean bl = false;
        RestHandlerNode restHandlerNode = ((RestHandlerEditorNode)this.getContext().getNode()).getHandlerNode();
        if (restHandlerNode.isUsingRestApi()) {
            if (this._gui.isHandlerChanged()) {
                RestResourceHandler restResourceHandler = restHandlerNode.getHandler();
                bl = MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)RestArb.format("ASK_SAVE_HANDLER", restResourceHandler.getMethodType().getNLS(), restHandlerNode.getTemplateURI(), restHandlerNode.getModuleName()), (String)RestArb.getString("SAVE_HANDLER"), null);
                if (bl) {
                    this._gui.getRESTWorksheet().saveHandler();
                }
            }
        } else {
            return true;
        }
        return bl;
    }

    @Override
    public void update(Object object, UpdateMessage updateMessage) {
        RestHandlerNode restHandlerNode;
        RestHandlerEditorNode restHandlerEditorNode;
        if (updateMessage.getMessageID() == UpdateMessage.OBJECT_RENAMED && (restHandlerEditorNode = (RestHandlerEditorNode)this.getContext().getNode()) != null && (restHandlerNode = restHandlerEditorNode.getHandlerNode()) != null) {
            this._gui.refreshURI(restHandlerNode);
        }
    }

    public Controller getController() {
        return this.getRESTfulHandlerGUI().getRESTWorksheet().getController();
    }

    private void setUpUndoRedo() {
        ArrayList<IdeAction> arrayList = new ArrayList<IdeAction>();
        arrayList.add(IdeAction.find((int)5));
        arrayList.add(IdeAction.find((int)6));
        UIUtils.addChildViewController((View)this.getRESTfulHandlerGUI().getRESTWorksheet(), arrayList);
    }

    public void updateVisibleActions(UpdateMessage updateMessage) {
        this.getRESTfulHandlerGUI().getRESTWorksheet().updateVisibleActions(updateMessage);
    }
}

