/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.autorest.generator;

import java.io.InputStream;
import java.net.URL;
import java.sql.Connection;
import java.util.Hashtable;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.RaptorVersionTracker;
import oracle.javatools.db.DBException;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STGroup;
import org.stringtemplate.v4.STGroupFile;

public class AutoRestCodeGenerator {
    private static volatile AutoRestCodeGenerator _instance;
    public static final String MEMBER_LIST = "MEMBER_LIST";
    public static final String AUTO_REST_ENABLE_OBJECT = "AUTO_REST_ENABLE_OBJECT";
    public static final String AUTO_REST_ENABLE_SCHEMA = "AUTO_REST_ENABLE_SCHEMA";
    public static final String OBJECT_LIST = "OBJECT_LIST";
    public static final String COMPLETE_MEMBER_LIST = "COMPLETE_MEMBER_LIST";
    public static final String SCHEMA_METADATA = "SCHEMA_METADATA";
    public static final String OBJECT_METADATA = "OBJECT_METADATA";
    public static final String OBJECT_INVALID_MEMBERS = "OBJECT_INVALID_MEMBERS";
    public static final String SCHEMA_DROP_REST_SERVICE = "SCHEMA_DROP_REST_SERVICE";
    private Map<String, STGroup> templateGroups = new Hashtable<String, STGroup>();

    private AutoRestCodeGenerator() {
        this.initGroupLoader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AutoRestCodeGenerator getInstance() {
        if (_instance != null) return _instance;
        Class<AutoRestCodeGenerator> clazz = AutoRestCodeGenerator.class;
        synchronized (AutoRestCodeGenerator.class) {
            if (_instance != null) return _instance;
            _instance = new AutoRestCodeGenerator();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _instance;
        }
    }

    private void initGroupLoader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private STGroup getTemplateGroup(String string) {
        if (string == null || string.length() == 0) {
            STGroup sTGroup = this.fetchTemplateGroup("");
            return sTGroup;
        }
        STGroup sTGroup = this.templateGroups.get(string);
        if (sTGroup == null) {
            Map<String, STGroup> map = this.templateGroups;
            synchronized (map) {
                sTGroup = this.templateGroups.get(string);
                if (sTGroup == null) {
                    String[] stringArray = string.split("\\.");
                    for (int i = stringArray.length; i > 0; --i) {
                        String string2 = "_";
                        Object object = "";
                        for (int j = 0; j < i; ++j) {
                            object = (String)object + string2 + stringArray[j];
                            string2 = "_";
                        }
                        sTGroup = this.fetchTemplateGroup((String)object);
                        if (sTGroup != null) break;
                    }
                    if (sTGroup == null) {
                        sTGroup = this.fetchTemplateGroup("");
                    }
                }
                if (sTGroup != null) {
                    this.templateGroups.put(string, sTGroup);
                }
            }
        }
        return sTGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private STGroup fetchTemplateGroup(String string) {
        STGroup sTGroup = this.templateGroups.get(string);
        if (sTGroup == null) {
            Map<String, STGroup> map = this.templateGroups;
            synchronized (map) {
                sTGroup = this.templateGroups.get(string);
                if (sTGroup == null) {
                    String string2 = "oracle/dbtools/autorest/generator/templates/AUTOREST" + string + ".stg";
                    ClassLoader classLoader = this.getClass().getClassLoader();
                    InputStream inputStream = classLoader.getResourceAsStream(string2);
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        URL uRL = classLoader.getResource(string2);
                        sTGroup = new STGroupFile(uRL, "utf-8", '<', '>');
                    }
                    if (sTGroup == null) {
                        return null;
                    }
                    this.templateGroups.put(string, sTGroup);
                }
            }
        }
        return sTGroup;
    }

    public ST getTemplate(String string, String string2) {
        try {
            STGroup sTGroup = this.getTemplateGroup(string);
            if (sTGroup != null) {
                ST sT = sTGroup.getInstanceOf(string2);
                return sT;
            }
        }
        catch (Throwable throwable) {
            Logger.getLogger(AutoRestCodeGenerator.class.getName()).log(Level.SEVERE, throwable.getLocalizedMessage(), throwable);
        }
        return null;
    }

    public String generateForConnection(String string, String string2, Map<String, Object> map) {
        try {
            return this.generate(Connections.getInstance().getConnection(string), string2, map);
        }
        catch (DBException dBException) {
            return null;
        }
    }

    public String generate(Connection connection, String string, Map<String, Object> map) {
        String string2 = RaptorVersionTracker.getDbVersion((Connection)connection).toCanonicalString();
        return this.generate(string2, string, map);
    }

    public String generate(String string, String string2, Object ... objectArray) {
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length / 2; ++i) {
                treeMap.put(objectArray[i * 2].toString(), objectArray[i * 2 + 1]);
            }
        }
        String string3 = this.generate(string, string2, treeMap);
        return string3;
    }

    public String generate(String string, String string2, Map<String, Object> map) {
        String string3 = null;
        try {
            ST sT = this.getTemplate(string, string2);
            if (sT != null) {
                if (map != null) {
                    for (String string4 : map.keySet()) {
                        try {
                            sT.add(string4, map.get(string4));
                        }
                        catch (IllegalArgumentException illegalArgumentException) {}
                    }
                }
                string3 = sT.render();
                if (string.startsWith("10")) {
                    string3 = string3.replaceAll("\r\n", "\n");
                }
            }
        }
        catch (Throwable throwable) {
            Logger.getLogger(AutoRestCodeGenerator.class.getName()).log(Level.SEVERE, throwable.getLocalizedMessage(), throwable);
        }
        return string3;
    }

    public String getQuery(String string, String string2) {
        STGroup sTGroup = this.getTemplateGroup(string2);
        ST sT = sTGroup.getInstanceOf(string);
        if (sT == null) {
            return null;
        }
        return sT.render();
    }
}

