/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.migration.applications.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.net.URI;
import java.nio.CharBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.charset.Charset;
import java.util.logging.Logger;
import oracle.dbtools.raptor.migration.applications.cmdline.ScannerDetails;
import oracle.ide.Ide;

public class Utils {
    protected static final Logger LOGGER = Logger.getLogger(Utils.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyFile(File file, File file2) {
        block15: {
            Object object;
            block13: {
                FileChannel fileChannel = new FileInputStream(file).getChannel();
                if (!file2.exists()) {
                    file2.createNewFile();
                }
                object = new FileOutputStream(file2).getChannel();
                try {
                    fileChannel.transferTo(0L, fileChannel.size(), (WritableByteChannel)object);
                    if (fileChannel == null) break block13;
                }
                catch (IOException iOException) {
                    boolean bl;
                    block14: {
                        try {
                            bl = false;
                            if (fileChannel == null) break block14;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (fileChannel != null) {
                                    fileChannel.close();
                                }
                                if (object != null) {
                                    ((AbstractInterruptibleChannel)object).close();
                                }
                                throw throwable;
                            }
                            catch (IOException iOException2) {
                                object = new File(file2.getParentFile().getPath());
                                if (!((File)object).exists()) {
                                    ((File)object).mkdirs();
                                    Utils.copyFile(file, file2);
                                    break block15;
                                }
                                return false;
                            }
                        }
                        fileChannel.close();
                    }
                    if (object != null) {
                        ((AbstractInterruptibleChannel)object).close();
                    }
                    return bl;
                }
                fileChannel.close();
            }
            if (object != null) {
                ((AbstractInterruptibleChannel)object).close();
            }
        }
        return true;
    }

    public static File createOutputFile(File file, ScannerDetails scannerDetails) {
        assert (file != null);
        assert (scannerDetails != null);
        URI uRI = scannerDetails.getDirURI().relativize(file.toURI());
        URI uRI2 = scannerDetails.getOutputDirURI().resolve(uRI);
        File file2 = new File(uRI2);
        Utils.copyFile(file, file2);
        return file2;
    }

    public static CharSequence fromFile(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        FileChannel fileChannel = fileInputStream.getChannel();
        MappedByteBuffer mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, (int)fileChannel.size());
        CharBuffer charBuffer = Charset.forName(Ide.getEnvironOptions().getEncoding()).newDecoder().decode(mappedByteBuffer);
        fileInputStream.close();
        return charBuffer;
    }

    public static synchronized String getExtension(File file) {
        if (file.isDirectory()) {
            return "";
        }
        String string = file.getName();
        String string2 = "";
        int n = string.lastIndexOf(".");
        if (string.lastIndexOf(".") == -1) {
            return "";
        }
        string2 = string.substring(n + 1, string.length());
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isBinary(File file) {
        boolean bl = false;
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(file);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            char[] cArray = new char[255];
            bufferedReader.read(cArray, 0, 255);
            double d = 0.0;
            for (int i = 0; i < cArray.length; ++i) {
                char c = cArray[i];
                if (c >= ' ' && c <= '\u007f') continue;
                d += 1.0;
            }
            double d2 = d / 255.0;
            if (d2 > 0.5) {
                bl = true;
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        finally {
            if (fileReader != null) {
                try {
                    fileReader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return bl;
    }

    public static String getURI(File file, ScannerDetails scannerDetails) {
        URI uRI = null;
        String string = null;
        if (scannerDetails.isDirSpecified()) {
            uRI = scannerDetails.isInPlace() ? scannerDetails.getDirURI() : (scannerDetails.isOutputSpecified() ? scannerDetails.getOutputDirURI() : scannerDetails.getDirURI());
            string = uRI.relativize(file.toURI()).getRawPath();
        } else {
            string = file.getParentFile().toURI().getRawPath();
        }
        return string;
    }
}

