/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.migration.applications.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.dbtools.metadata.persistence.CloseableIterator;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdApplication;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.metadata.persistence.PersistenceUtility;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.raptor.migration.applications.AppScanArb;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;

public class AppDescriptionPanel
extends DefaultTraversablePanel {
    private static final long serialVersionUID = 6042240045799476950L;
    protected static final String APPLICATION_NAME = "APPLICATION_NAME";
    protected static final String APPLICATION_DESC = "APPLICATION_DESC";
    private JLabel lblAppName;
    private JTextField txtfAppName;
    private JTextPane textPaneAppDescription;
    private JLabel lblDescription;
    private ArrayList<String> names = new ArrayList();
    private TraversableContext ctx;

    public AppDescriptionPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        this.add((Component)new MultiLineLabel(AppScanArb.get("APP_DESC_LABEL")), new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 18, 0, new Insets(15, 15, 15, 15), 0, 0));
        this.add(this.getLblAppName(), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add(this.getTxtfAppName(), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add(this.getLblNewLabel(), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add(this.getTextPaneAppDescription(), new GridBagConstraints(0, 3, 2, 1, 1.0, 1.0, 18, 1, new Insets(5, 5, 15, 5), 0, 0));
        KeyListener keyListener = new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                AppDescriptionPanel.this.setButtons();
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                AppDescriptionPanel.this.setButtons();
            }
        };
        this.getTextPaneAppDescription().addKeyListener(keyListener);
        this.getTxtfAppName().addKeyListener(keyListener);
    }

    private JLabel getLblAppName() {
        if (this.lblAppName == null) {
            this.lblAppName = new JLabel();
            ResourceUtils.resLabel((JLabel)this.lblAppName, (Component)this.getTxtfAppName(), (String)AppScanArb.getString("APPSCAN_NAME"));
        }
        return this.lblAppName;
    }

    private JTextField getTxtfAppName() {
        if (this.txtfAppName == null) {
            this.txtfAppName = new JTextField();
            this.txtfAppName.setToolTipText(AppScanArb.getString("APPSCAN_NAME_TOOLTIP"));
        }
        return this.txtfAppName;
    }

    private JTextPane getTextPaneAppDescription() {
        if (this.textPaneAppDescription == null) {
            this.textPaneAppDescription = new JTextPane();
            this.textPaneAppDescription.setBorder(this.getTxtfAppName().getBorder());
        }
        return this.textPaneAppDescription;
    }

    private JLabel getLblNewLabel() {
        if (this.lblDescription == null) {
            this.lblDescription = new JLabel();
            ResourceUtils.resLabel((JLabel)this.lblDescription, (Component)this.getTextPaneAppDescription(), (String)AppScanArb.getString("APPSCAN_DESCRIPTION"));
        }
        return this.lblDescription;
    }

    private void setButtons() {
        if (this.txtfAppName.getText().length() == 0 || this.textPaneAppDescription.getText().length() == 0) {
            this.ctx.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false));
        } else {
            this.ctx.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
        }
    }

    public void onEntry(TraversableContext traversableContext) {
        this.ctx = traversableContext;
        if (this.ctx.get("project") != null) {
            try {
                PersistenceManager persistenceManager = MigrationAddin.getPersistenceManager();
                Long l = Long.parseLong((String)this.ctx.get("project"));
                DBObjectId dBObjectId = new DBObjectId(l.longValue());
                CloseableIterator closeableIterator = PersistenceUtility.getInstance((PersistenceManager)persistenceManager).getApplicationsForProject(dBObjectId);
                while (closeableIterator.hasNext()) {
                    MdApplication mdApplication = (MdApplication)closeableIterator.next();
                    this.names.add(mdApplication.getName());
                }
            }
            catch (PersistenceException persistenceException) {
                persistenceException.printStackTrace();
            }
        }
        if (traversableContext.get(APPLICATION_NAME) != null) {
            this.txtfAppName.setText((String)traversableContext.get(APPLICATION_NAME));
        }
        if (traversableContext.get(APPLICATION_DESC) != null) {
            this.textPaneAppDescription.setText((String)traversableContext.get(APPLICATION_DESC));
        }
        this.ctx.getWizardCallbacks().wizardSetInitialFocus((Component)this.getTxtfAppName());
        this.setButtons();
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        if (this.checkAppExists(traversableContext)) {
            throw new TraversalException("Application of this name exists");
        }
        if (this.txtfAppName.getText() != null) {
            String string = this.txtfAppName.getText();
            if (this.names.contains(string)) {
                throw new TraversalException(AppScanArb.getString("APPSCAN_DUPNAME"));
            }
            traversableContext.put(APPLICATION_NAME, (Object)string);
        }
        if (this.textPaneAppDescription.getText() != null) {
            traversableContext.put(APPLICATION_DESC, (Object)this.textPaneAppDescription.getText());
        }
    }

    private boolean checkAppExists(TraversableContext traversableContext) {
        return false;
    }
}

