/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.java.provider;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.buffer.ExpiredTextBufferException;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.parser.java.v2.JavaParser;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.JdkVersion;
import oracle.javatools.parser.java.v2.model.JavaFile;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.write.SourcePreferences;
import oracle.javatools.util.WeakCache;
import oracle.jdeveloper.java.provider.BaseFileProvider;
import oracle.jdeveloper.java.provider.ProviderConstants;

public class ProviderContext
implements ProviderConstants {
    protected static final String CLASS_SUFFIX = ".class";
    protected static final String SOURCE_SUFFIX = ".java";
    protected BaseFileProvider provider;
    private WeakCache<URL, TextBuffer> textBufferCache = new WeakCache();

    public void setProvider(BaseFileProvider providerIn) {
        this.provider = providerIn;
    }

    public BaseFileProvider getProvider() {
        return this.provider;
    }

    protected int getFileType(URL url) {
        String path = url.getFile();
        if (path.endsWith(SOURCE_SUFFIX)) {
            return 2;
        }
        if (path.endsWith(CLASS_SUFFIX)) {
            return 1;
        }
        return -1;
    }

    protected SourcePreferences getSourcePreferences() {
        return null;
    }

    public SourceFile createSourceFile(URL url, JdkVersion jdkVersion) throws IOException, IllegalArgumentException {
        if (URLFileSystem.exists((URL)url)) {
            return null;
        }
        if (!URLFileSystem.canCreate((URL)url)) {
            return null;
        }
        OutputStream os = URLFileSystem.openOutputStream((URL)url);
        os.close();
        return this.getSourceFileImpl(url, jdkVersion);
    }

    @Deprecated
    public SourceFile createSourceFile(URL url, int j2se) throws IOException, IllegalArgumentException {
        return this.createSourceFile(url, JdkVersion.getJdkVersion((byte)((byte)j2se)));
    }

    public SourceFile getSourceFile(URL url, JdkVersion jdkVersion) throws IllegalArgumentException {
        if (URLFileSystem.exists((URL)url)) {
            return this.getSourceFileImpl(url, jdkVersion);
        }
        return null;
    }

    @Deprecated
    public SourceFile getSourceFile(URL url, int j2se) throws IllegalArgumentException {
        return this.getSourceFile(url, JdkVersion.getJdkVersion((byte)((byte)j2se)));
    }

    protected SourceFile getSourceFileImpl(URL url, JdkVersion jdkVersion) throws IllegalArgumentException {
        int numberOfTries = 3;
        for (int x = 0; x < numberOfTries; ++x) {
            try {
                TextBuffer textBuffer = this.checkURLandGetTextBuffer(url);
                if (textBuffer == null) {
                    return null;
                }
                SourceFile file = this.getSourceFile(textBuffer, jdkVersion);
                if (file == null) {
                    return null;
                }
                file.setURL(url);
                return file;
            }
            catch (ExpiredTextBufferException ex) {
                if (x != numberOfTries - 1) continue;
                throw ex;
            }
        }
        return null;
    }

    @Deprecated
    protected SourceFile getSourceFileImpl(URL url, int j2se) throws IllegalArgumentException {
        return this.getSourceFileImpl(url, JdkVersion.getJdkVersion((byte)((byte)j2se)));
    }

    public JavaFile getLightSourceFile(URL url, JdkVersion jdkVersion) throws IllegalArgumentException {
        int numberOfTries = 3;
        for (int x = 0; x < numberOfTries; ++x) {
            TextBuffer textBuffer = this.checkURLandGetTextBuffer(url);
            if (textBuffer == null) {
                return null;
            }
            try {
                return this.getLightSourceFileImpl(textBuffer, url, jdkVersion);
            }
            catch (ExpiredTextBufferException ex) {
                if (x != numberOfTries - 1) continue;
                throw ex;
            }
        }
        return null;
    }

    @Deprecated
    public JavaFile getLightSourceFile(URL url, int j2se) throws IllegalArgumentException {
        return this.getLightSourceFile(url, JdkVersion.getJdkVersion((byte)((byte)j2se)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeSourceFile(SourceFile file) {
        URL url = file.getURL();
        if (url == null) {
            return true;
        }
        OutputStream os = null;
        try {
            os = URLFileSystem.openOutputStream((URL)url);
            OutputStreamWriter osw = new OutputStreamWriter(os);
            TextBuffer textBuffer = file.getTextBuffer();
            textBuffer.write((Writer)osw);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final SourceFile getSourceFile(TextBuffer textBuffer, JdkVersion jdkVersion) {
        textBuffer.readLock();
        try {
            SourceFile file = JavaParser.parse((ReadTextBuffer)textBuffer, (JdkVersion)jdkVersion);
            if (file == null) {
                SourceFile sourceFile = file;
                return sourceFile;
            }
            file.pinTextBuffer(textBuffer);
            file.setProvider((JavaProvider)this.provider);
            SourcePreferences p = this.getSourcePreferences();
            if (p != null) {
                file.setPreferences(p);
            }
            SourceFile sourceFile = file;
            return sourceFile;
        }
        finally {
            textBuffer.readUnlock();
        }
    }

    @Deprecated
    protected final SourceFile getSourceFile(TextBuffer textBuffer, int j2se) {
        return this.getSourceFile(textBuffer, JdkVersion.getJdkVersion((byte)((byte)j2se)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TextBuffer getTextBuffer(URL url) throws FileNotFoundException {
        WeakCache<URL, TextBuffer> weakCache = this.textBufferCache;
        synchronized (weakCache) {
            TextBuffer textBuffer = (TextBuffer)this.textBufferCache.get((Object)url);
            if (textBuffer != null) {
                return textBuffer;
            }
        }
        try {
            InputStream is = URLFileSystem.openInputStream((URL)url);
            InputStreamReader isr = new InputStreamReader(is);
            BufferedReader br = new BufferedReader(isr);
            TextBuffer textBuffer = TextBufferFactory.createTextBuffer();
            textBuffer.read((Reader)br);
            WeakCache<URL, TextBuffer> weakCache2 = this.textBufferCache;
            synchronized (weakCache2) {
                this.textBufferCache.put((Object)url, (Object)textBuffer);
            }
            return textBuffer;
        }
        catch (IOException e) {
            return null;
        }
    }

    private TextBuffer checkURLandGetTextBuffer(URL url) throws IllegalArgumentException {
        int fileType = this.getFileType(url);
        if (fileType == -1) {
            throw new IllegalArgumentException("Not a known java suffix");
        }
        try {
            return this.getTextBuffer(url);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final JavaFile getLightSourceFileImpl(TextBuffer textBuffer, URL url, JdkVersion jdkVersion) {
        textBuffer.readLock();
        try {
            JavaFile javaFile = JavaParser.lightParse((ReadTextBuffer)textBuffer, (URL)url, (JavaProvider)this.provider, (JdkVersion)jdkVersion);
            return javaFile;
        }
        finally {
            textBuffer.readUnlock();
        }
    }

    protected void startTracking(URL url) {
    }

    public void clearTracking() {
    }
}

