/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.java.locator;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import oracle.ide.net.JarIndex;
import oracle.ide.net.JarIndexEntry;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLKey;
import oracle.ide.net.URLPath;
import oracle.ide.util.FileUtilities;
import oracle.javatools.util.ArraySortedSet;
import oracle.jdeveloper.java.locator.ModularizedJdkBaseLocator;
import oracle.jdeveloper.java.locator.ModularizedJdkURLFileSystemHelper;
import oracle.jdeveloper.java.locator.ModularizedPackageEntry;

public class ModularizedJdkSourceLocator
extends ModularizedJdkBaseLocator {
    private static final Map<String, ModularizedJdkSourceLocator> INSTANCES = new HashMap<String, ModularizedJdkSourceLocator>();
    private URL _srcZip;
    private Map<String, String> _relativeSourceLocations;

    private ModularizedJdkSourceLocator(URL srcZip) {
        this._srcZip = URLFactory.intern((URL)srcZip);
        this._lastModified = URLFileSystem.lastModified((URL)srcZip);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ModularizedJdkSourceLocator getInstance(URL jdk9OrHigherSrcZip) {
        String filePath = ModularizedJdkSourceLocator.getSrcZipFilePath(jdk9OrHigherSrcZip);
        ModularizedJdkSourceLocator locator = ModularizedJdkSourceLocator.getInstance(filePath);
        if (locator != null) {
            return locator;
        }
        Map<String, ModularizedJdkSourceLocator> map = INSTANCES;
        synchronized (map) {
            locator = new ModularizedJdkSourceLocator(jdk9OrHigherSrcZip);
            INSTANCES.put(filePath, locator);
            return locator;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ModularizedJdkSourceLocator getInstance(String filePath) {
        Map<String, ModularizedJdkSourceLocator> map = INSTANCES;
        synchronized (map) {
            ModularizedJdkSourceLocator locator = INSTANCES.get(filePath);
            return locator;
        }
    }

    private static String getSrcZipFilePath(URL srcZip) {
        return URLFileSystem.getPath((URL)srcZip);
    }

    @Override
    protected String getUrlLocatorFilePath() {
        return ModularizedJdkSourceLocator.getSrcZipFilePath(this._srcZip);
    }

    private URL getFileSystemSourceUrl(URL moduleInfoURL, String relativeSpec, String className) {
        URL moduleRoot = URLFileSystem.getParent((URL)moduleInfoURL);
        URL sourceDir = relativeSpec == null ? moduleRoot : URLFactory.newURL((URL)moduleRoot, (String)relativeSpec);
        return URLFactory.newURL((URL)sourceDir, (String)(className + ".java"));
    }

    private URL getFileSystemSourceUrl(String moduleIndex, String className) {
        URL moduleInfoUrl;
        String moduleName = this.getModuleName(moduleIndex);
        if (moduleName == null) {
            moduleIndex = this.getModuleIndexForClass(className.replace('\\', '.').replace('/', '.'));
            if (moduleIndex == null) {
                return null;
            }
            moduleName = this.getModuleName(moduleIndex);
        }
        if (moduleName != null && (moduleInfoUrl = this.getSourceModuleInfoURL(moduleName)) != null) {
            return this.getFileSystemSourceUrl(moduleInfoUrl, this._relativeSourceLocations.get(moduleIndex), className);
        }
        return null;
    }

    @Override
    protected byte[] getBytes(String moduleIndex, String className) throws IOException {
        this.buildIndex();
        URL sourceUrl = this.getFileSystemSourceUrl(moduleIndex, className);
        if (sourceUrl != null) {
            return FileUtilities.readFile((URL)sourceUrl);
        }
        return new byte[0];
    }

    @Override
    protected long getLength(String moduleIndex, String className) throws IOException {
        this.buildIndex();
        if ("module-info".equals(className)) {
            URL sourceUrl = this.getFileSystemSourceUrl(moduleIndex, className);
            if (sourceUrl != null) {
                return URLFileSystem.getLength((URL)sourceUrl);
            }
            return -1L;
        }
        return this.getLengthForClass(className.replace('\\', '.').replace('/', '.'));
    }

    @Override
    protected URL getURLImpl(String fqClassName) {
        this.buildIndex();
        String moduleIndex = this.getModuleIndexForClass(fqClassName);
        if (moduleIndex != null) {
            String locatorFilePath = this.getUrlLocatorFilePath();
            return ModularizedJdkURLFileSystemHelper.createSourceURL(locatorFilePath, this.getLocatorType(), moduleIndex, fqClassName);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void buildIndexImpl(boolean checkInterrupt) throws InterruptedException {
        if (this._packageMap != null) {
            return;
        }
        ModularizedJdkSourceLocator modularizedJdkSourceLocator = this;
        synchronized (modularizedJdkSourceLocator) {
            block19: {
                if (this._packageMap != null) {
                    return;
                }
                if (checkInterrupt) {
                    ModularizedJdkSourceLocator.checkInterrupt();
                }
                this._moduleNames = new ArrayList();
                this._relativeSourceLocations = new HashMap<String, String>();
                try {
                    HashMap<String, Map<String, ModularizedJdkBaseLocator.ClassDetails>> packageToClassDetails = new HashMap<String, Map<String, ModularizedJdkBaseLocator.ClassDetails>>(512);
                    HashMap<String, Collection<String>> packageToSubMap = new HashMap<String, Collection<String>>(512);
                    final ArrayList sourcesThruJarIndex = new ArrayList(32768);
                    JarIndex jarIndex = JarIndex.getInstance((URL)this._srcZip);
                    jarIndex.visit(new JarIndex.Visitor(){

                        public boolean visit(JarIndexEntry entry) {
                            String name = entry.getName();
                            if (name.endsWith(".java")) {
                                sourcesThruJarIndex.add(entry);
                            }
                            return true;
                        }
                    });
                    if (checkInterrupt) {
                        ModularizedJdkSourceLocator.checkInterrupt();
                    }
                    Collections.sort(sourcesThruJarIndex, new Comparator<JarIndexEntry>(){

                        @Override
                        public int compare(JarIndexEntry o1, JarIndexEntry o2) {
                            return o1.getName().compareTo(o2.getName());
                        }
                    });
                    if (checkInterrupt) {
                        ModularizedJdkSourceLocator.checkInterrupt();
                    }
                    int moduleSourceRootCount = 0;
                    String moduleSourceRootIndex = null;
                    int lastModuleStart = 0;
                    int lastModuleInfoIndex = -1;
                    String moduleName = null;
                    HashMap<URLKey, String> moduleSourceRootToIndex = new HashMap<URLKey, String>();
                    for (int x = 0; x < sourcesThruJarIndex.size(); ++x) {
                        if (checkInterrupt) {
                            ModularizedJdkSourceLocator.checkInterrupt();
                        }
                        String name = ((JarIndexEntry)sourcesThruJarIndex.get(x)).getName();
                        if (moduleName == null) {
                            if (!name.endsWith("module-info.java")) continue;
                            moduleSourceRootIndex = Integer.toHexString(moduleSourceRootCount);
                            ++moduleSourceRootCount;
                            moduleName = name.substring(0, name.length() - 17);
                            this._moduleNames.add(moduleName);
                            URL moduleSourceRootUrl = URLFactory.newJarURL((URL)this._srcZip, (String)name.substring(0, name.length() - 16));
                            moduleSourceRootToIndex.put(URLKey.getInstance((URL)moduleSourceRootUrl), moduleSourceRootIndex);
                            URL moduleInfoUrl = URLFactory.newJarURL((URL)this._srcZip, (String)name);
                            this._moduleInfoURLs.put(moduleName, moduleInfoUrl);
                            lastModuleInfoIndex = x;
                            x = lastModuleStart - 1;
                            continue;
                        }
                        if (name.startsWith(moduleName)) {
                            if (x == lastModuleInfoIndex) continue;
                            String fullName = name;
                            String currentModuleSourceRootIndex = moduleSourceRootIndex;
                            int srcIndex = (name = name.substring(moduleName.length() + 1)).replace('\\', '/').indexOf("/src/");
                            if (srcIndex >= 0) {
                                name = name.substring(srcIndex + 5);
                                String srcSourceRoot = fullName.substring(0, moduleName.length() + 1 + srcIndex + 5);
                                URL srcSourceRootUrl = URLFactory.newJarURL((URL)this._srcZip, (String)srcSourceRoot);
                                URLKey srcSourceRootKey = URLKey.getInstance((URL)srcSourceRootUrl);
                                String srcModuleSourceRootIndex = (String)moduleSourceRootToIndex.get(srcSourceRootKey);
                                if (srcModuleSourceRootIndex == null) {
                                    srcModuleSourceRootIndex = Integer.toHexString(moduleSourceRootCount);
                                    ++moduleSourceRootCount;
                                    this._moduleNames.add(moduleName);
                                    currentModuleSourceRootIndex = srcModuleSourceRootIndex;
                                    this._relativeSourceLocations.put(srcModuleSourceRootIndex, srcSourceRoot.substring(moduleName.length() + 1));
                                }
                            }
                            this.indexClassMaps(currentModuleSourceRootIndex, moduleName, name, ((JarIndexEntry)sourcesThruJarIndex.get(x)).getSize(), packageToClassDetails, packageToSubMap);
                            continue;
                        }
                        moduleName = null;
                        lastModuleStart = x--;
                    }
                    ArraySortedSet allKeys = new ArraySortedSet(100);
                    allKeys.addAll(packageToClassDetails.keySet());
                    allKeys.addAll(packageToSubMap.keySet());
                    HashMap<String, ModularizedPackageEntry> finalPackageMap = new HashMap<String, ModularizedPackageEntry>(allKeys.size());
                    for (String packageName : allKeys) {
                        if (checkInterrupt) {
                            ModularizedJdkSourceLocator.checkInterrupt();
                        }
                        Map classNamesToDetails = (Map)packageToClassDetails.get(packageName);
                        Collection subs = (Collection)packageToSubMap.get(packageName);
                        if ((classNamesToDetails == null || classNamesToDetails.isEmpty()) && (subs == null || subs.isEmpty())) continue;
                        finalPackageMap.put(packageName, new ModularizedPackageEntry(packageName, classNamesToDetails, (Collection<String>)subs));
                    }
                    ArrayList<String> packedModuleNames = new ArrayList<String>(this._moduleNames.size());
                    for (String oneModuleName : this._moduleNames) {
                        packedModuleNames.add(oneModuleName);
                    }
                    this._moduleNames = packedModuleNames;
                    this._packageMap = finalPackageMap;
                }
                catch (Exception ex) {
                    if ($assertionsDisabled) break block19;
                    throw new AssertionError();
                }
            }
        }
    }

    @Override
    public URL getSourceURL(String fqClassName) {
        this.buildIndex();
        return this.getURLImpl(fqClassName);
    }

    @Override
    public URL getSourceURLInterruptibly(String fqClassName) throws InterruptedException {
        this.buildIndexInterruptibly();
        return this.getURLImpl(fqClassName);
    }

    @Override
    public URL getSourceModuleInfoURL(String moduleName) {
        this.buildIndex();
        return this.getModuleInfoURL(moduleName);
    }

    @Override
    public URL getSourceModuleInfoURLInterruptibly(String moduleName) throws InterruptedException {
        this.buildIndexInterruptibly();
        return this.getModuleInfoURL(moduleName);
    }

    @Override
    protected boolean isLocal() {
        return URLFileSystem.isLocal((URL)this._srcZip);
    }

    @Override
    protected ModularizedJdkURLFileSystemHelper.LocatorType getLocatorType() {
        return ModularizedJdkURLFileSystemHelper.LocatorType.SRC_LOCATOR;
    }

    public URLPath getSourcePath() {
        this.buildIndex();
        URL rootURL = ModularizedJdkURLFileSystemHelper.createDirURL(this.getUrlLocatorFilePath(), this.getLocatorType(), "");
        return rootURL == null ? new URLPath() : new URLPath(rootURL);
    }

    private void getModuleRoots(URLKey parent, Map<URLKey, List<URL>> moduleRoots, URLKey moduleInfoRoot) {
        String name;
        URL parentUrl = parent.toURL();
        URL[] children = URLFileSystem.list((URL)parentUrl);
        boolean addedParentSourceDir = false;
        URLKey currentModuleInfoRoot = moduleInfoRoot;
        if (moduleInfoRoot == null) {
            for (URL child : children) {
                name = URLFileSystem.getFileName((URL)child);
                if (!"module-info.java".equals(name)) continue;
                moduleRoots.put(parent, new ArrayList());
                currentModuleInfoRoot = parent;
            }
        }
        for (URL child : children) {
            List<URL> list;
            name = URLFileSystem.getFileName((URL)child);
            if (name.indexOf(46) >= 0) {
                this.getModuleRoots(URLKey.getInstance((URL)child), moduleRoots, currentModuleInfoRoot);
                continue;
            }
            if (currentModuleInfoRoot == null) continue;
            if ("src".equals(name)) {
                if (moduleInfoRoot == null) continue;
                list = moduleRoots.get(currentModuleInfoRoot);
                list.add(child);
                continue;
            }
            if (addedParentSourceDir) continue;
            addedParentSourceDir = true;
            list = moduleRoots.get(currentModuleInfoRoot);
            list.add(parentUrl);
        }
    }

    @Override
    protected Collection<String> getAllModulesImpl() {
        return new HashSet<String>(this._moduleNames);
    }

    public URLPath getExpandedSourcePath() {
        URL rootDir = URLFactory.newJarURL((URL)this._srcZip, (String)"");
        LinkedHashMap<URLKey, List<URL>> moduleRoots = new LinkedHashMap<URLKey, List<URL>>();
        this.getModuleRoots(URLKey.getInstance((URL)rootDir), moduleRoots, null);
        URLPath path = new URLPath();
        for (List moduleRootList : moduleRoots.values()) {
            for (URL moduleRoot : moduleRootList) {
                path.add(moduleRoot);
            }
        }
        return path;
    }
}

