/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.java.locator;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import oracle.javatools.util.ArraySortedSet;
import oracle.jdeveloper.java.filter.ClassNameFilter;
import oracle.jdeveloper.java.filter.PackageNameFilter;
import oracle.jdeveloper.java.locator.BaseClassLocator;
import oracle.jdeveloper.java.locator.ModularizedJdkURLFileSystemHelper;
import oracle.jdeveloper.java.locator.ModularizedPackageEntry;

public abstract class ModularizedJdkBaseLocator
extends BaseClassLocator {
    protected volatile Map<String, ModularizedPackageEntry> _packageMap;
    protected List<String> _moduleNames;
    protected Map<String, URL> _moduleInfoURLs = new HashMap<String, URL>();
    protected long _lastModified;

    protected ModularizedJdkBaseLocator() {
    }

    protected abstract void buildIndexImpl(boolean var1) throws InterruptedException;

    protected abstract String getUrlLocatorFilePath();

    protected abstract boolean isLocal();

    protected abstract byte[] getBytes(String var1, String var2) throws IOException;

    protected abstract URL getURLImpl(String var1);

    protected abstract ModularizedJdkURLFileSystemHelper.LocatorType getLocatorType();

    protected abstract long getLength(String var1, String var2) throws IOException;

    long getLastModified() {
        return this._lastModified;
    }

    @Override
    public void buildIndex() {
        try {
            this.buildIndexImpl(false);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException();
        }
    }

    @Override
    public void buildIndexInterruptibly() throws InterruptedException {
        this.buildIndexImpl(true);
    }

    @Override
    public void getPackages(String packagePrefix, Collection<String> out) {
        this.buildIndex();
        ModularizedPackageEntry entry = this.findPackage(packagePrefix);
        if (entry != null) {
            entry.getSubpackageNames(out);
        }
    }

    @Override
    public void getPackagesInterruptibly(String packagePrefix, Collection<String> out) throws InterruptedException {
        this.buildIndexInterruptibly();
        ModularizedJdkBaseLocator.checkInterrupt();
        ModularizedPackageEntry entry = this.findPackage(packagePrefix);
        if (entry != null) {
            entry.getSubpackageNames(out);
        }
    }

    private ModularizedPackageEntry findPackage(String packageName) {
        return this._packageMap.get(packageName);
    }

    @Override
    public void getClassesInPackage(String packagePrefix, Collection<String> out) {
        this.buildIndex();
        this.getClassesInPackageImpl(packagePrefix, out);
    }

    @Override
    public void getClassesInPackageInterruptibly(String packagePrefix, Collection<String> out) throws InterruptedException {
        this.buildIndexInterruptibly();
        this.getClassesInPackageImpl(packagePrefix, out);
    }

    private void getClassesInPackageImpl(String packagePrefix, Collection<String> out) {
        ModularizedPackageEntry entry = this.findPackage(packagePrefix);
        if (entry != null) {
            entry.getTopLevelClasses(out);
        }
    }

    @Override
    public void getAllClasses(Collection<String> out, ClassNameFilter filter) {
        this.buildIndex();
        try {
            this.getAllClassesImpl(out, filter, false);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException();
        }
    }

    @Override
    public void getAllClassesInterruptibly(Collection<String> out, ClassNameFilter filter) throws InterruptedException {
        this.buildIndexInterruptibly();
        this.getAllClassesImpl(out, filter, true);
    }

    private void getAllClassesImpl(Collection<String> out, ClassNameFilter filter, boolean checkInterrupt) throws InterruptedException {
        for (ModularizedPackageEntry entry : this._packageMap.values()) {
            String[] classNames;
            if (checkInterrupt) {
                ModularizedJdkBaseLocator.checkInterrupt();
            }
            String packageName = entry._packageName;
            for (String className : classNames = entry.getClasses()) {
                if (className.indexOf(36) >= 0) continue;
                if (checkInterrupt) {
                    ModularizedJdkBaseLocator.checkInterrupt();
                }
                boolean acceptName = true;
                if (filter != null) {
                    acceptName = filter.acceptClassName(className, packageName);
                }
                if (!acceptName) continue;
                String fqName = ModularizedJdkBaseLocator.buildFQName(packageName, className);
                out.add(fqName);
            }
        }
    }

    @Override
    public void getAllPackages(Collection<String> out, PackageNameFilter filter) {
        this.buildIndex();
        try {
            this.getAllPackagesImpl(out, filter, false);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException();
        }
    }

    @Override
    public void getAllPackagesInterruptibly(Collection<String> out, PackageNameFilter filter) throws InterruptedException {
        this.buildIndexInterruptibly();
        this.getAllPackagesImpl(out, filter, true);
    }

    private void getAllPackagesImpl(Collection<String> out, PackageNameFilter filter, boolean checkInterrupt) throws InterruptedException {
        for (String packagePrefix : this._packageMap.keySet()) {
            if (checkInterrupt) {
                ModularizedJdkBaseLocator.checkInterrupt();
            }
            if (packagePrefix.length() <= 0 || filter != null && !filter.acceptPackageName(packagePrefix)) continue;
            out.add(packagePrefix);
        }
    }

    @Override
    public URL getURL(String fqClassName) {
        this.buildIndex();
        return this.getURLImpl(fqClassName);
    }

    @Override
    public URL getURLInterruptibly(String fqClassName) throws InterruptedException {
        this.buildIndexInterruptibly();
        return this.getURLImpl(fqClassName);
    }

    @Override
    public URL getSourceURL(String fqClassName) {
        return null;
    }

    @Override
    public URL getSourceURLInterruptibly(String fqClassName) throws InterruptedException {
        return null;
    }

    @Override
    public URL getClassURL(String fqClassName) {
        return null;
    }

    @Override
    public URL getClassURLInterruptibly(String fqClassName) throws InterruptedException {
        return null;
    }

    @Override
    public URL getResourceURL(String resourceName) {
        return null;
    }

    @Override
    public String getModuleNameOfClass(String fqClassName) {
        this.buildIndex();
        return this.getModuleNameOfClassImpl(fqClassName);
    }

    @Override
    public String getModuleNameOfClassInterruptibly(String fqClassName) throws InterruptedException {
        this.buildIndex();
        return this.getModuleNameOfClassImpl(fqClassName);
    }

    @Override
    public Collection<String> getClassesDirectly() {
        return this.getAllClasses();
    }

    private String getModuleNameOfClassImpl(String fqClassName) {
        String moduleIndex = this.getModuleIndexForClass(fqClassName);
        return moduleIndex != null ? this.getModuleName(moduleIndex) : null;
    }

    protected String getModuleIndexForClass(String fqClassName) {
        BiFunction<ModularizedPackageEntry, String, String> function = (pckEntry, className) -> pckEntry.getModuleIndexForClass((String)className);
        return this.getPackageClassDetail(fqClassName, function);
    }

    private <T> T getPackageClassDetail(String fqClassName, BiFunction<ModularizedPackageEntry, String, T> getDetail) {
        int countCascades;
        String[] nameCascades = ModularizedJdkBaseLocator.getNameCascades(fqClassName);
        int countParts = countCascades = nameCascades.length;
        if (countCascades > 0) {
            String packagePrefix = countCascades > 1 ? nameCascades[countCascades - 2] : "";
            ModularizedPackageEntry foundEntry = this.findPackage(packagePrefix);
            if (foundEntry == null) {
                return null;
            }
            String[] nameParts = ModularizedJdkBaseLocator.getNameParts(fqClassName);
            String className = nameParts[countParts - 1];
            return getDetail.apply(foundEntry, className);
        }
        return null;
    }

    protected long getLengthForClass(String fqClassName) {
        BiFunction<ModularizedPackageEntry, String, Long> function = (pckEntry, className) -> pckEntry.getLengthForClass((String)className);
        Long result = this.getPackageClassDetail(fqClassName, function);
        if (result != null) {
            return result;
        }
        return -1L;
    }

    protected String getModuleName(String moduleIndex) {
        if (moduleIndex == null) {
            return null;
        }
        try {
            int x = Integer.parseUnsignedInt(moduleIndex, 16);
            if (x == -1) {
                return null;
            }
            return this._moduleNames.get(x);
        }
        catch (Exception ex) {
            assert (false);
            return null;
        }
    }

    @Override
    public Collection<String> getAllModules() {
        this.buildIndex();
        return this.getAllModulesImpl();
    }

    @Override
    public Collection<String> getAllModulesInterruptibly() throws InterruptedException {
        this.buildIndexInterruptibly();
        return this.getAllModulesImpl();
    }

    protected Collection<String> getAllModulesImpl() {
        return Collections.unmodifiableCollection(this._moduleNames);
    }

    protected URL getModuleInfoURL(String moduleName) {
        if (moduleName == null) {
            return null;
        }
        return this._moduleInfoURLs.get(moduleName);
    }

    public boolean packageExists(String name) {
        this.buildIndex();
        return this.findPackage(name) != null;
    }

    boolean classExists(String moduleIndex, String className) {
        this.buildIndex();
        String moduleNameOfIndex = this.getModuleName(moduleIndex);
        String moduleNameOfClass = this.getModuleNameOfClass(className.replace('\\', '.').replace('/', '.'));
        if (moduleNameOfClass != null && (moduleNameOfIndex == null || moduleNameOfIndex.equals(moduleNameOfClass))) {
            return true;
        }
        return moduleNameOfIndex != null && "module-info".equals(className);
    }

    protected void indexClassMaps(String moduleIndex, String moduleName, String classEntry, long classLength, Map<String, Map<String, ClassDetails>> packageToClassDetails, Map<String, Collection<String>> packageToSubMap) {
        String packagePrefix;
        URL classURL;
        if (classEntry.replace('\\', '/').endsWith("module-info.class") && (classURL = ModularizedJdkURLFileSystemHelper.createClassURL(this.getUrlLocatorFilePath(), this.getLocatorType(), moduleIndex, "module-info")) != null) {
            this._moduleInfoURLs.put(moduleName, classURL);
        }
        int suffixDot = classEntry.lastIndexOf(46);
        String fqName = classEntry.substring(0, suffixDot).replace('\\', '.').replace('/', '.');
        int lastDot = fqName.lastIndexOf(46);
        boolean defaultPackage = false;
        if (lastDot != -1) {
            packagePrefix = fqName.substring(0, lastDot);
        } else {
            packagePrefix = "";
            defaultPackage = true;
        }
        String className = lastDot != -1 ? fqName.substring(lastDot + 1) : fqName;
        boolean existingPackage = true;
        Map<String, ClassDetails> classNamesToDetails = packageToClassDetails.get(packagePrefix);
        if (classNamesToDetails == null) {
            classNamesToDetails = new HashMap<String, ClassDetails>();
            packageToClassDetails.put(packagePrefix, classNamesToDetails);
            existingPackage = false;
        }
        ClassDetails classDetails = new ClassDetails(moduleIndex, classLength);
        classNamesToDetails.put(new String(className), classDetails);
        if (existingPackage || defaultPackage) {
            return;
        }
        ModularizedJdkBaseLocator.indexPackageMaps(packagePrefix, packageToSubMap);
    }

    private static void indexPackageMaps(String packagePrefix, Map<String, Collection<String>> packageToSubMap) {
        String outer = "";
        int pos = 0;
        boolean done = false;
        while (!done) {
            int nextDot = packagePrefix.indexOf(46, pos);
            if (nextDot == -1) {
                done = true;
                nextDot = packagePrefix.length();
            }
            String sub = packagePrefix.substring(pos, nextDot);
            ArraySortedSet subList = packageToSubMap.get(outer);
            if (subList == null) {
                subList = new ArraySortedSet(20);
                packageToSubMap.put(outer, (Collection<String>)subList);
            }
            subList.add((String)sub);
            outer = packagePrefix.substring(0, nextDot);
            pos = nextDot + 1;
        }
    }

    protected static class ClassDetails {
        String moduleIndex;
        long length;

        protected ClassDetails(String moduleIndex, long length) {
            this.moduleIndex = moduleIndex;
            this.length = length;
        }
    }
}

