/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.java.locator;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedList;
import oracle.jdeveloper.java.classpath.ClasspathTreeVisitOptions;
import oracle.jdeveloper.java.filter.ClassNameFilter;
import oracle.jdeveloper.java.filter.PackageNameFilter;
import oracle.jdeveloper.java.locator.BaseClassLocator;

public class ArrayClassLocator
extends BaseClassLocator
implements Iterable<BaseClassLocator> {
    protected final BaseClassLocator[] _locators;

    public ArrayClassLocator(BaseClassLocator[] locators) {
        if (locators == null) {
            throw new IllegalArgumentException("null locators argument");
        }
        ArrayList<BaseClassLocator> list = new ArrayList<BaseClassLocator>(locators.length);
        for (BaseClassLocator locator : locators) {
            if (locator == null) continue;
            list.add(locator);
        }
        this._locators = list.toArray(new BaseClassLocator[list.size()]);
    }

    @Override
    public void buildIndex() {
        int count = this._locators.length;
        for (int i = 0; i < count; ++i) {
            this._locators[i].buildIndex();
        }
    }

    @Override
    public void buildIndexInterruptibly() throws InterruptedException {
        for (BaseClassLocator locator : this._locators) {
            ArrayClassLocator.checkInterrupt();
            locator.buildIndexInterruptibly();
        }
    }

    @Override
    public void getPackages(String packagePrefix, Collection<String> out) {
        for (BaseClassLocator locator : this._locators) {
            locator.getPackages(packagePrefix, out);
        }
    }

    @Override
    public void getPackagesInterruptibly(String packagePrefix, Collection<String> out) throws InterruptedException {
        for (BaseClassLocator locator : this._locators) {
            ArrayClassLocator.checkInterrupt();
            locator.getPackagesInterruptibly(packagePrefix, out);
        }
    }

    @Override
    public void getClassesInPackage(String packagePrefix, Collection<String> out) {
        for (BaseClassLocator locator : this._locators) {
            locator.getClassesInPackage(packagePrefix, out);
        }
    }

    @Override
    public void getClassesInPackageInterruptibly(String packagePrefix, Collection<String> out) throws InterruptedException {
        for (BaseClassLocator locator : this._locators) {
            ArrayClassLocator.checkInterrupt();
            locator.getClassesInPackageInterruptibly(packagePrefix, out);
        }
    }

    @Override
    public void getAllClasses(Collection<String> out, ClassNameFilter filter) {
        for (BaseClassLocator locator : this._locators) {
            locator.getAllClasses(out, filter);
        }
    }

    @Override
    public void getAllClassesInterruptibly(Collection<String> out, ClassNameFilter filter) throws InterruptedException {
        for (BaseClassLocator locator : this._locators) {
            ArrayClassLocator.checkInterrupt();
            locator.getAllClassesInterruptibly(out, filter);
        }
    }

    @Override
    public void getAllPackages(Collection<String> out, PackageNameFilter filter) {
        for (BaseClassLocator locator : this._locators) {
            locator.getAllPackages(out, filter);
        }
    }

    @Override
    public void getAllPackagesInterruptibly(Collection<String> out, PackageNameFilter filter) throws InterruptedException {
        for (BaseClassLocator locator : this._locators) {
            ArrayClassLocator.checkInterrupt();
            locator.getAllPackagesInterruptibly(out, filter);
        }
    }

    @Override
    public URL getURL(String fqClassName) {
        for (BaseClassLocator locator : this._locators) {
            URL url = locator.getURL(fqClassName);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    @Override
    public URL getURLInterruptibly(String fqClassName) throws InterruptedException {
        for (BaseClassLocator locator : this._locators) {
            ArrayClassLocator.checkInterrupt();
            URL url = locator.getURLInterruptibly(fqClassName);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    @Override
    public URL getSourceURL(String fqClassName) {
        for (BaseClassLocator locator : this._locators) {
            URL url = locator.getSourceURL(fqClassName);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    @Override
    public URL getSourceURLInterruptibly(String fqClassName) throws InterruptedException {
        for (BaseClassLocator locator : this._locators) {
            ArrayClassLocator.checkInterrupt();
            URL url = locator.getSourceURLInterruptibly(fqClassName);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    @Override
    public URL getClassURL(String fqClassName) {
        for (BaseClassLocator locator : this._locators) {
            URL url = locator.getClassURL(fqClassName);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    @Override
    public URL getClassURLInterruptibly(String fqClassName) throws InterruptedException {
        for (BaseClassLocator locator : this._locators) {
            ArrayClassLocator.checkInterrupt();
            URL url = locator.getClassURLInterruptibly(fqClassName);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    @Override
    public URL getResourceURL(String resourceName) {
        for (BaseClassLocator locator : this._locators) {
            URL url = locator.getResourceURL(resourceName);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    @Override
    public Collection<URL> getResourceURLs(String resourceName) {
        LinkedList<URL> urls = new LinkedList<URL>();
        for (BaseClassLocator locator : this._locators) {
            urls.addAll(locator.getResourceURLs(resourceName));
        }
        return urls;
    }

    @Override
    public Iterator<BaseClassLocator> iterator() {
        return Arrays.asList(this._locators).iterator();
    }

    @Override
    protected Collection<BaseClassLocator> getChildLocators(EnumSet<ClasspathTreeVisitOptions> options) {
        return Arrays.asList(this._locators);
    }

    @Override
    public String getModuleNameOfClass(String fqClassName) {
        int count = this._locators.length;
        for (int i = 0; i < count; ++i) {
            String result = this._locators[i].getModuleNameOfClass(fqClassName);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public String getModuleNameOfClassInterruptibly(String fqClassName) throws InterruptedException {
        int count = this._locators.length;
        for (int i = 0; i < count; ++i) {
            ArrayClassLocator.checkInterrupt();
            String result = this._locators[i].getModuleNameOfClassInterruptibly(fqClassName);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public void setContainsModuleClasses(boolean containsModuleClasses) {
        int count = this._locators.length;
        for (int i = 0; i < count; ++i) {
            this._locators[i].setContainsModuleClasses(containsModuleClasses);
        }
    }
}

