/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scriptrunner.commands;

import java.sql.Connection;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.IHelp;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.HelpMessages;
import oracle.dbtools.raptor.newscriptrunner.commands.IStoreCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;

public class SetCodescan
extends CommandListener
implements IHelp,
IShowCommand,
IStoreCommand {
    private static final String OFF = "off";
    private static final String ON = "on";
    private static final String CODESCAN = "codescan";
    private static final String SQLINJECTION = "sqlinjection";
    private static final String SQLPERFORMANCE = "sqlperformance";
    boolean bad = false;

    @Override
    public String getCommand() {
        return "CODESCAN";
    }

    @Override
    public String getHelp() {
        return HelpMessages.getString("SETCODESCAN");
    }

    @Override
    public boolean isSqlPlus() {
        return false;
    }

    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        String[] bits = cmd.getSql().split("\\s+");
        if (bits.length < 2) {
            return false;
        }
        if (!bits[0].toLowerCase().equals("set")) {
            return false;
        }
        if (!(bits[1].toLowerCase().equals("code") || bits[1].toLowerCase().equals(CODESCAN) || bits[1].toLowerCase().equals(SQLINJECTION) || bits[1].toLowerCase().equals(SQLPERFORMANCE))) {
            return false;
        }
        String bits1 = bits[1].toLowerCase();
        int recognized = 2;
        try {
            if (recognized < bits.length) {
                switch (bits[recognized].toLowerCase()) {
                    case "on": {
                        ++recognized;
                        ctx.removeProperty("sqlcl.codescan.all");
                        if (CODESCAN.equals(bits1) || SQLINJECTION.equals(bits1)) {
                            ctx.putProperty("sqlcl.codescan.SQLINJECTION", Boolean.TRUE);
                        }
                        if (CODESCAN.equals(bits1) || SQLPERFORMANCE.equals(bits1)) {
                            ctx.putProperty("sqlcl.codescan.PSRCHECKS", Boolean.TRUE);
                        }
                        return true;
                    }
                    case "off": {
                        ++recognized;
                        ctx.removeProperty("sqlcl.codescan.all");
                        if (CODESCAN.equals(bits1) || SQLINJECTION.equals(bits1)) {
                            ctx.putProperty("sqlcl.codescan.SQLINJECTION", Boolean.FALSE);
                        }
                        if (CODESCAN.equals(bits1) || SQLPERFORMANCE.equals(bits1)) {
                            ctx.putProperty("sqlcl.codescan.PSRCHECKS", Boolean.FALSE);
                        }
                        return true;
                    }
                    case "sqlinjection": {
                        ++recognized;
                        ctx.removeProperty("sqlcl.codescan.all");
                        String last = bits[3].toLowerCase();
                        if (ON.equals(last)) {
                            ctx.putProperty("sqlcl.codescan.SQLINJECTION", Boolean.TRUE);
                        } else {
                            ctx.putProperty("sqlcl.codescan.SQLINJECTION", Boolean.FALSE);
                        }
                        return true;
                    }
                    case "sqlperformance": {
                        ++recognized;
                        ctx.removeProperty("sqlcl.codescan.all");
                        String last = bits[3].toLowerCase();
                        if (ON.equals(last)) {
                            ctx.putProperty("sqlcl.codescan.PSRCHECKS", Boolean.TRUE);
                        } else {
                            ctx.putProperty("sqlcl.codescan.PSRCHECKS", Boolean.FALSE);
                        }
                        return true;
                    }
                }
                ctx.write("Invalid SET CODESCAN option\n");
                ctx.write(this.getHelp());
                return true;
            }
            return true;
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            ctx.write("Invalid SET CODESCAN option\n");
            ctx.write(this.getHelp());
            return true;
        }
    }

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public String[] getShowAliases() {
        return new String[]{"code", CODESCAN};
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        Object sqlinjObj = ctx.getProperty("sqlcl.codescan.SQLINJECTION");
        boolean sqlinj = sqlinjObj == null ? true : Boolean.parseBoolean(sqlinjObj.toString());
        ctx.write("CODESCAN SQLINJECTION " + (sqlinj ? ON : OFF) + "\n");
        Object o = ctx.getProperty("sqlcl.codescan.PSRCHECKS");
        boolean oo = o == null ? true : Boolean.parseBoolean(o.toString());
        ctx.write("CODESCAN SQLPERFORMANCE " + (oo ? ON : OFF) + "\n");
        return true;
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return true;
    }

    @Override
    public String getStoreCommand(ScriptRunnerContext ctx) {
        Object sqlinjObj = ctx.getProperty("sqlcl.codescan.SQLINJECTION");
        boolean sqlinj = sqlinjObj == null ? true : Boolean.parseBoolean(sqlinjObj.toString());
        return "set codescan " + (sqlinj ? ON : OFF) + "\n";
    }
}

