/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scriptrunner.cmdline.handlers;

import java.awt.Component;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.utils.IMessageHandler;

public class SQLCliMessageHandler
implements IMessageHandler {
    @Override
    public boolean confirm(Component parent, String msg, String title, String help, String details) {
        this.print(title);
        this.print(details);
        Object prompt = msg;
        ScriptRunnerContext ctx = ScriptRunnerContext.getCurrentContext();
        if (ctx.getProperty("script.runner.sqlplus.silent") != null) {
            prompt = (String)prompt + "(N)";
            this.print((String)prompt);
            return false;
        }
        prompt = (String)prompt + "(Y/N)";
        String response = ctx.getPromptedFieldProvider().getPromptedField(ctx, (String)prompt, false);
        return response.toLowerCase().equals("y");
    }

    @Override
    public int confirmOrCancel(Component parent, String msg, String title, String help) {
        this.print(title);
        Object prompt = msg;
        ScriptRunnerContext ctx = ScriptRunnerContext.getCurrentContext();
        if (ctx.getProperty("script.runner.sqlplus.silent") != null) {
            prompt = (String)prompt + "(N)";
            this.print((String)prompt);
            return 0;
        }
        prompt = (String)prompt + "(Y/N/C)";
        String response = ctx.getPromptedFieldProvider().getPromptedField(ctx, (String)prompt, false);
        switch (response.toLowerCase()) {
            case "y": {
                return 1;
            }
            case "n": {
                return 0;
            }
            case "c": {
                return -1;
            }
        }
        return 0;
    }

    @Override
    public void information(Component parent, String msg, String title, String help, String details) {
        this.print(msg, title, help, details);
    }

    @Override
    public void error(Component parent, String msg, String title, String help, String details) {
        this.print(msg, title, help, details);
    }

    @Override
    public void critical(Component parent, String msg, String title, String help, String details) {
        this.print(msg, title, help, details);
    }

    protected String readLine() {
        return System.console().readLine();
    }

    protected void print(String msg, String title, String help, String details) {
        ScriptRunnerContext ctx = ScriptRunnerContext.getCurrentContext();
        this.print(title);
        this.print(msg);
        this.print(details);
    }

    protected void print(String line) {
        if (line != null) {
            System.out.println(line);
        }
    }
}

