/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.plusplus.connections.db.imp;

import java.text.MessageFormat;
import oracle.dbtools.common.utils.ModelUtil;
import oracle.dbtools.connections.db.DatabaseProvider;
import oracle.dbtools.plusplus.connections.db.MessageLogger;
import oracle.dbtools.plusplus.connections.db.imp.BaseOracleConverter;
import oracle.dbtools.plusplus.connections.db.imp.ConnectionsConverter;
import oracle.dbtools.plusplus.connections.db.imp.ConnectionsConverterFactory;

public class LDAPConverterFactory
implements ConnectionsConverterFactory {
    public static final String LDAP_CONTEXT = "LDAP_CONTEXT";
    public static final String LDAP_SERVER = "LDAP_SERVER";
    public static final String LDAP_NETWORK_ALIAS = "LDAP_NETWORK_ALIAS";
    public static final String LDAP_FORMAT = "ldap://{0}/{1},{2}";
    public static final String LDAPS_FORMAT = "ldaps://{0}/{1},{2}";

    @Override
    public boolean canConvert(DatabaseProvider provider) {
        return "oraJDBC".equals(provider.getProperty("subtype")) && "LDAP".equals(provider.getProperty("OracleConnectionType"));
    }

    @Override
    public ConnectionsConverter createConverter(DatabaseProvider provider, MessageLogger logging) {
        return new LDAPConverter(provider, logging);
    }

    private static class LDAPConverter
    extends BaseOracleConverter {
        LDAPConverter(DatabaseProvider provider, MessageLogger logging) {
            super(provider, logging);
        }

        @Override
        protected String processConnectionSpec() {
            String spec;
            String server = this.definition.getProperty(LDAPConverterFactory.LDAP_SERVER);
            String networkAlias = this.definition.getProperty(LDAPConverterFactory.LDAP_NETWORK_ALIAS);
            String context = this.definition.getProperty(LDAPConverterFactory.LDAP_CONTEXT);
            if (ModelUtil.hasLength(server) && ModelUtil.hasLength(networkAlias) && ModelUtil.hasLength(context)) {
                spec = MessageFormat.format(LDAPConverterFactory.LDAP_FORMAT, server, networkAlias, context);
                this.addDBToolsProperty("type", "ORACLE_DATABASE");
                this.addDBToolsProperty("connectionString", spec);
            } else {
                spec = this.processCustomURL();
                if (spec != null) {
                    this.addDBToolsProperty("type", "ORACLE_DATABASE");
                } else {
                    spec = this.processBasicConfiguration();
                    if (spec != null) {
                        this.addDBToolsProperty("type", "ORACLE_BASIC");
                    } else {
                        this.logger.logUserMessage("Warning: incomplete LDAP connection definition");
                    }
                }
            }
            return spec;
        }
    }
}

