/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.plusplus.connections.db.imp;

import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.ServiceLoader;
import oracle.dbtools.plusplus.connections.db.ConnectionStoreResources;
import oracle.dbtools.plusplus.connections.db.DuplicatesPolicy;
import oracle.dbtools.plusplus.connections.db.MessageLogger;
import oracle.dbtools.plusplus.connections.db.imp.Importer;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;

public interface ImporterFactory {
    public static final ServiceLoader<ImporterFactory> LOADER = ServiceLoader.load(ImporterFactory.class);

    public boolean canHandle(Path var1);

    public Importer create(Path var1, DuplicatesPolicy var2, Collection<String> var3, ScriptRunnerContext var4, MessageLogger var5);

    public static Importer getImporter(Path path, DuplicatesPolicy duplicatesPolicy, Collection<String> existingConnections, ScriptRunnerContext ctx, MessageLogger logger) {
        Importer importer = null;
        for (ImporterFactory factory : LOADER) {
            if (!factory.canHandle(path)) continue;
            importer = factory.create(path, duplicatesPolicy, existingConnections, ctx, logger);
            break;
        }
        if (importer == null) {
            importer = ImporterFactory.createFallbackImporter(path, duplicatesPolicy, existingConnections, ctx, logger);
        }
        return importer;
    }

    public static Importer createFallbackImporter(Path path, DuplicatesPolicy duplicatesPolicy, Collection<String> existingConnections, ScriptRunnerContext ctx, MessageLogger logger) {
        return new Importer(path, duplicatesPolicy, (Collection)existingConnections, ctx, logger){

            protected Map loadConnections() {
                this.logger.logUserMessage(ConnectionStoreResources.format("UNSUPPORTED_IMPORT_LOCATION", this.importPath));
                return Collections.emptyMap();
            }

            protected String getConnectionName(Object connectionDefinition) {
                return null;
            }
        };
    }
}

