/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.plusplus.connections.db.helpers.ora;

import java.io.File;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.Objects;
import java.util.Properties;
import oracle.dbtools.common.utils.ModelUtil;
import oracle.dbtools.plusplus.connections.db.MessageLogger;
import oracle.dbtools.plusplus.connections.db.helpers.BaseConnectionHelper;
import oracle.dbtools.plusplus.connections.db.helpers.ora.Constants;
import oracle.dbtools.plusplus.connections.db.storage.NamedConnectionDefinition;
import oracle.dbtools.plusplus.connections.db.storage.Wallet;
import oracle.dbtools.raptor.newscriptrunner.ConnectionDetails;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.jdbc.datasource.impl.OracleDataSource;

public abstract class BaseOracleConnectionHelper
extends BaseConnectionHelper
implements Constants {
    private static final String TEST_QUERY = "select banner from v$version";

    protected BaseOracleConnectionHelper(NamedConnectionDefinition definition, ScriptRunnerContext ctx, MessageLogger logger) {
        super(definition, ctx, logger);
    }

    protected String getDriverType() {
        return "thin";
    }

    @Override
    public String getURL() {
        return MessageFormat.format("jdbc:oracle:{0}:@//{1}", this.getDriverType(), this.getConnectionSpec());
    }

    @Override
    public void completeConnectionDetails(ConnectionDetails cd) {
        char[] walletPassword;
        String walletUser;
        String spec;
        Wallet wallet;
        Wallet.Credentials creds;
        String pwd;
        String username = cd.getConnectName();
        String storedUser = this.getUsername();
        if (!ModelUtil.hasLength(username)) {
            cd.setConnectName(storedUser);
            username = storedUser;
        }
        if (!ModelUtil.hasLength(pwd = cd.getConnectPassword()) && (creds = (wallet = this.definition.getWallet()).getCredentials(spec = this.getConnectionSpec())) != null && Objects.equals(walletUser = creds.getUsername(), username) && (walletPassword = creds.password()).length > 0) {
            cd.setConnectPassword(new String(walletPassword));
        }
        cd.setConnectDB(this.getURL());
    }

    protected String getUsername() {
        Properties dbtoolsProperties = this.definition.getDbtoolsProperties();
        return dbtoolsProperties.getProperty("userName");
    }

    protected String getDbtoolsProperty(String key) {
        return this.definition.getDbtoolsProperties().getProperty(key);
    }

    protected String getAdvancedProperty(String key) {
        return this.definition.getOjdbcProperties().getProperty(key);
    }

    @Override
    public void configureDataSource(oracle.jdbc.datasource.OracleDataSource datasource) throws SQLException {
        Path connectionDir = this.definition.getConnectionDirectory();
        Object dirName = connectionDir.toString();
        if (!((String)dirName).endsWith(File.separator)) {
            dirName = (String)dirName + File.separator;
        }
        datasource.setConnectionProperty("oracle.net.tns_admin", (String)dirName);
    }

    @Override
    public void testConnection(String user) throws SQLException {
        ConnectionDetails cd = new ConnectionDetails(this.getConnectionSpec(), false, user, null, this.getConnectionSpec(), null, false, -1, -1, null);
        this.completeConnectionDetails(cd);
        ConnectionDetails updatedDetails = this.ctx.getConnectFieldsProvider().get3Fields(this.ctx, cd, false);
        if (updatedDetails != null) {
            String connectUser = updatedDetails.getConnectName();
            String connectPwd = updatedDetails.getConnectPassword();
            OracleDataSource ds = new OracleDataSource();
            ds.setURL(this.getURL());
            ds.setUser(connectUser);
            ds.setPassword(connectPwd);
            this.configureDataSource((oracle.jdbc.datasource.OracleDataSource)ds);
            try (Connection conn = ds.getConnection();
                 Statement stmt = conn.createStatement();
                 ResultSet rs = stmt.executeQuery(TEST_QUERY);){
                if (rs.next()) {
                    this.logger.logUserMessage(rs.getString(1));
                }
            }
        }
    }

    @Override
    public Properties getDisplayProperties() {
        Properties properties = new Properties();
        Properties ojdbProperties = this.definition.getOjdbcProperties();
        ojdbProperties.stringPropertyNames().forEach(k -> properties.put(k, ojdbProperties.getProperty((String)k)));
        BaseOracleConnectionHelper.setPropertyForDisplay(properties, "USER", this.getUsername());
        BaseOracleConnectionHelper.setPropertyForDisplay(properties, "URL", this.getURL());
        return properties;
    }
}

