/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.plusplus.connections.db;

import oracle.dbtools.common.utils.ModelUtil;
import oracle.dbtools.plusplus.connections.db.NamedConnections;
import oracle.dbtools.plusplus.connections.db.NamedConnectionsConnector;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.Connector;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.ConnectorArgs;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.ParseConnectionSpecArgs;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.PasswordProperty;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.StandardFormConnectorType;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.URLProperty;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.UserProperty;

public class NamedConnectionsConnectorType
extends StandardFormConnectorType {
    static final String NAME = "NAME";

    @Override
    public void parseConnectionSpec(ParseConnectionSpecArgs args) {
        String name;
        String spec = args.getConnectionSpec();
        if (!ModelUtil.hasLength(spec)) {
            args.addError("Connection name required");
            return;
        }
        String user = null;
        String pwd = null;
        int idx = spec.indexOf(64);
        if (idx == -1) {
            name = spec;
        } else {
            String first = spec.substring(0, idx);
            name = spec.substring(idx + 1);
            if (first.length() > 0) {
                idx = first.indexOf(47);
                if (idx == -1) {
                    user = first;
                } else {
                    user = first.substring(0, idx);
                    pwd = first.substring(idx + 1);
                }
            }
        }
        if (name == null || !NamedConnections.instance().listConnections().contains(name)) {
            args.addError("Unknown connection " + name);
        } else {
            args.setPropertyValue(URLProperty.URL, name);
            args.setPropertyValue(UserProperty.USER, user);
            args.setPropertyValue(PasswordProperty.PASSWORD, pwd);
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getShortName() {
        return "N";
    }

    @Override
    protected boolean isSelectorMandatory() {
        return true;
    }

    @Override
    public Connector createConnector(ConnectorArgs args) {
        return new NamedConnectionsConnector(args);
    }
}

