/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.plusplus.connections.db;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Properties;
import oracle.dbtools.connections.api.Connections;
import oracle.dbtools.plusplus.connections.db.ConnectionStoreCommand;
import oracle.dbtools.plusplus.connections.db.MessageLogger;
import oracle.dbtools.plusplus.connections.db.NamedConnections;
import oracle.dbtools.plusplus.connections.db.helpers.ConnectionHelper;
import oracle.dbtools.plusplus.connections.db.helpers.ConnectionHelperFactory;
import oracle.dbtools.plusplus.connections.db.storage.NamedConnectionDefinition;
import oracle.dbtools.raptor.newscriptrunner.ConnectionDetails;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.ConnectorArgs;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.OracleStandardFormConnector;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.StandardFormConnector;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.URLProperty;
import oracle.jdbc.datasource.OracleDataSource;

class NamedConnectionsConnector
extends OracleStandardFormConnector {
    private final Connections.Identifier id;
    private final ConnectionHelper creator;
    private final ScriptRunnerContext ctx;
    private final MessageLogger logger;

    NamedConnectionsConnector(ConnectorArgs args) {
        super(args);
        this.ctx = args.getScriptRunnerContext();
        MessageLogger.DefaultLoggerWrapper wrapper = MessageLogger.logger(ConnectionStoreCommand.class);
        this.logger = MessageLogger.builder().interactiveLogger(this.ctx::writeln).errorLogger(wrapper::error).traceLogger(wrapper::trace).build();
        String name = args.getPropertyValues().getValueOf(URLProperty.URL);
        this.id = NamedConnections.instance().lookupConnectionIdentifier(name);
        NamedConnectionDefinition def = NamedConnections.instance().getConnectionDefinition(this.id);
        this.creator = this.id != null ? ConnectionHelperFactory.findHelper(def, this.ctx, this.logger) : ConnectionHelperFactory.createFallbackHelper();
    }

    @Override
    protected StandardFormConnector.ConnectionRec createOracleStandardFormConnection(List<String> urlMessage, String connectDB, Properties props) {
        Connection conn = null;
        String successfulAttempt = null;
        try {
            conn = this.logConnectionURL(urlMessage, "user", this.creator.getURL(), props, true);
            successfulAttempt = connectDB;
        }
        catch (Throwable e) {
            urlMessage.add(e.getLocalizedMessage());
        }
        return new StandardFormConnector.ConnectionRec(this, conn, successfulAttempt);
    }

    @Override
    protected boolean completeConnectionDetails(Connection conn, ConnectionDetails cd) {
        boolean complete = false;
        this.creator.completeConnectionDetails(cd);
        ConnectionDetails updatedDetails = this.ctx.getConnectFieldsProvider().get3Fields(this.ctx, cd, false);
        if (updatedDetails != null) {
            cd.cloneFrom(updatedDetails);
            complete = true;
        }
        return complete;
    }

    @Override
    protected void configureDataSource(OracleDataSource datasource, String url, Properties filteredProps) throws SQLException {
        datasource.setURL(url);
        datasource.setConnectionProperties(filteredProps);
        this.creator.configureDataSource(datasource);
    }
}

