/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.plusplus.connections.db;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import oracle.dbtools.db.ConnectionDetails;
import oracle.dbtools.plusplus.connections.db.DatabaseConnection;

final class ImplicitConnection
implements DatabaseConnection {
    private static Map<String, String> typeMap = new HashMap<String, String>();
    private final String name;
    private final ConnectionDetails details;

    ImplicitConnection(ConnectionDetails details) {
        String url = details.getUrl();
        this.name = "\"" + url + "\"";
        this.details = details;
    }

    @Override
    public Connection getConnection(boolean force) throws SQLException {
        return this.details.getConn(force);
    }

    @Override
    public boolean matchConnection(Connection conn) {
        return conn == this.details.getConn(false);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getType() {
        String type = this.details.getType();
        String connType = type != null ? typeMap.get(type) : null;
        return connType != null ? connType : "Generic";
    }

    @Override
    public Properties getConnectionInfo() {
        return new Properties();
    }

    @Override
    public Connection getUniqueConnection() {
        ConnectionDetails clone = new ConnectionDetails(this.details);
        return clone.getConn(true);
    }

    @Override
    public String getURL() {
        return this.details.getUrl();
    }

    static {
        typeMap.put("jdbc:oracle:thin:", "Oracle");
        typeMap.put("jdbc:oracle:oci:", "Oracle");
        typeMap.put("jdbc:oracle:oci8:", "Oracle");
        typeMap.put("jdbc:oracle:orest:", "Oracle");
        typeMap.put("jdbc:oracle:orest", "Oracle");
        typeMap.put("http:", "Oracle");
        typeMap.put("https:", "Oracle");
    }
}

