/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.plusplus.connections.db;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import oracle.dbtools.plusplus.connections.db.DuplicatesPolicy;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.Help.AbstractCommandConstants;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.parameter.StandardParameter;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.validators.BooleanValidator;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.validators.FileExistsValidator;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.validators.StringValidator;

public class ConnectionStoreOptions
extends AbstractCommandConstants {
    static final String CMD_PARAMS = "connections.params";
    static final String BASE_COMMAND = "connections";
    static final String BASE_COMMAND_S = "conns";
    static final String IMPORT = "import";
    private static final String IMPORT_S = "i";
    static final String LIST = "list";
    private static final String LIST_S = "l";
    static final String SHOW = "show";
    private static final String SHOW_S = "s";
    static final String TEST = "test";
    private static final String TEST_S = "t";
    static final String ADD = "add";
    private static final String ADD_S = "a";
    static final String CLONE = "clone";
    private static final String CLONE_S = "c";
    static final String SAVE = "save";
    private static final Map<String, String> commandAliases = new HashMap<String, String>(Map.of("i", "import", "l", "list", "s", "show", "t", "test", "a", "add", "c", "clone"));
    public static final String DUPLICATES = "duplicates";
    static final String DUPLICATES_S = "dup";
    public static final String PATH = "path";
    public static final String TYPE = "type";
    private static final String TYPE_S = "t";
    public static final String CONNECTION_NAME = "name";
    private static final String CONNECTION_NAME_S = "n";
    public static final String USERNAME = "user";
    private static final String USERNAME_S = "u";
    public static final String HOST = "host";
    private static final String HOST_S = "h";
    public static final String PORT = "port";
    private static final String PORT_S = "p";
    public static final String SNAME = "servicename";
    private static final String SNAME_S = "svc";
    public static final String SID = "sid";
    public static final String DESC = "descriptor";
    private static final String DESC_s = "d";
    public static final String NOPWD = "nopwd";
    public static final String ORIGINAL = "original";
    private static final String ORIGINAL_S = "o";
    static final Map<String, Map<String, StandardParameter>> commandModel;
    static final Map<String, String> parameterAlias;
    static final Map<String, String> aliasLookup;

    @Override
    public String getBackupHelpPropertiesFilename() {
        return null;
    }

    @Override
    public String getBaseCommandName() {
        return BASE_COMMAND;
    }

    @Override
    public String getBaseCommandShortName() {
        return BASE_COMMAND_S;
    }

    @Override
    public Map<String, String> getCommandAliases() {
        return commandAliases;
    }

    @Override
    public Map<String, Map<String, StandardParameter>> getCommandModel() {
        return commandModel;
    }

    @Override
    public String getHelpPropertiesFilename() {
        return this.getClass().getPackageName() + ".Help";
    }

    @Override
    public Map<String, String> getParameterAliases() {
        return parameterAlias;
    }

    @Override
    public String getParameterSetName() {
        return CMD_PARAMS;
    }

    static {
        HashMap importParameters = new HashMap(Map.ofEntries(Map.entry(DUPLICATES, StandardParameter.withValidator(StringValidator.class).isStandard().isRequired(false).defaultValue(DuplicatesPolicy.DEFAULT_DUPLICATE_OPTION.valueName()).allowedValues(DuplicatesPolicy.asOptionsList()).build()), Map.entry(PATH, StandardParameter.withValidator(FileExistsValidator.class).isPositional().singleValue(true).paramCase(StandardParameter.CASE.PERSIST).isRequired(true).build())));
        Map listParameters = Collections.emptyMap();
        HashMap showParameters = new HashMap(Map.ofEntries(Map.entry(CONNECTION_NAME, StandardParameter.withValidator(StringValidator.class).isPositional().singleValue(true).paramCase(StandardParameter.CASE.PERSIST).isRequired(true).build())));
        HashMap testParameters = new HashMap(Map.ofEntries(Map.entry(USERNAME, StandardParameter.withValidator(StringValidator.class).isStandard().isRequired(false).paramCase(StandardParameter.CASE.UPPER).build()), Map.entry(CONNECTION_NAME, StandardParameter.withValidator(StringValidator.class).isPositional().singleValue(true).paramCase(StandardParameter.CASE.PERSIST).isRequired(true).build())));
        HashMap addParameters = new HashMap(Map.ofEntries(Map.entry(CONNECTION_NAME, StandardParameter.withValidator(StringValidator.class).isStandard().paramCase(StandardParameter.CASE.PERSIST).isRequired(true).build()), Map.entry(TYPE, StandardParameter.withValidator(StringValidator.class).isStandard().isRequired(false).defaultValue(ConnectionType.ADVANCED.valueName()).allowedValues(ConnectionType.asOptionsList()).build()), Map.entry(USERNAME, StandardParameter.withValidator(StringValidator.class).isStandard().paramCase(StandardParameter.CASE.PERSIST).isRequired(false).allowNull(true).build()), Map.entry(NOPWD, StandardParameter.withValidator(BooleanValidator.class).isStandard().isRequired(false).allowNull(true).build()), Map.entry(DESC, StandardParameter.withValidator(StringValidator.class).isStandard().paramCase(StandardParameter.CASE.PERSIST).isRequired(false).build()), Map.entry(HOST, StandardParameter.withValidator(StringValidator.class).isStandard().isRequired(false).build()), Map.entry(PORT, StandardParameter.withValidator(StringValidator.class).isStandard().isRequired(false).build()), Map.entry(SNAME, StandardParameter.withValidator(StringValidator.class).isStandard().paramCase(StandardParameter.CASE.PERSIST).isRequired(false).build()), Map.entry(SID, StandardParameter.withValidator(StringValidator.class).isStandard().paramCase(StandardParameter.CASE.PERSIST).isRequired(false).build())));
        HashMap cloneParameters = new HashMap(Map.ofEntries(Map.entry(CONNECTION_NAME, StandardParameter.withValidator(StringValidator.class).isStandard().paramCase(StandardParameter.CASE.PERSIST).isRequired(true).build()), Map.entry(ORIGINAL, StandardParameter.withValidator(StringValidator.class).isStandard().paramCase(StandardParameter.CASE.PERSIST).isRequired(true).build()), Map.entry(USERNAME, StandardParameter.withValidator(StringValidator.class).isStandard().paramCase(StandardParameter.CASE.PERSIST).isRequired(false).allowNull(true).build()), Map.entry(NOPWD, StandardParameter.withValidator(BooleanValidator.class).isStandard().isRequired(false).allowNull(true).build())));
        HashMap saveParameters = new HashMap(Map.ofEntries(Map.entry(CONNECTION_NAME, StandardParameter.withValidator(StringValidator.class).isStandard().paramCase(StandardParameter.CASE.PERSIST).isRequired(true).build()), Map.entry(USERNAME, StandardParameter.withValidator(StringValidator.class).isStandard().paramCase(StandardParameter.CASE.PERSIST).isRequired(false).allowNull(true).build()), Map.entry(NOPWD, StandardParameter.withValidator(BooleanValidator.class).isStandard().isRequired(false).allowNull(true).build())));
        commandModel = new HashMap<String, HashMap<String, Map<String, StandardParameter>>>(Map.of(IMPORT, importParameters, LIST, listParameters, SHOW, showParameters, TEST, testParameters, ADD, addParameters, CLONE, cloneParameters, SAVE, saveParameters));
        parameterAlias = new HashMap<String, String>(Map.ofEntries(Map.entry(DUPLICATES_S, DUPLICATES), Map.entry("t", TYPE), Map.entry(USERNAME_S, USERNAME), Map.entry(CLONE_S, CLONE), Map.entry(HOST_S, HOST), Map.entry(PORT_S, PORT), Map.entry(SNAME_S, SNAME), Map.entry(DESC_s, DESC), Map.entry(CONNECTION_NAME_S, CONNECTION_NAME), Map.entry(ORIGINAL_S, ORIGINAL)));
        aliasLookup = parameterAlias.entrySet().stream().collect(HashMap::new, (m, e) -> m.put((String)e.getValue(), (String)e.getKey()), HashMap::putAll);
    }

    public static enum ConnectionType {
        BASIC,
        ADVANCED;


        String valueName() {
            return this.name().toLowerCase();
        }

        static String asOptionsList() {
            StringBuilder list = new StringBuilder();
            ConnectionType[] values = ConnectionType.values();
            if (values.length > 0) {
                list.append(values[0].valueName());
                for (int i = 1; i < values.length; ++i) {
                    list.append(',').append(values[i].valueName());
                }
            }
            return list.toString();
        }

        public static ConnectionType asConnectionType(String value) {
            ConnectionType type;
            try {
                type = ConnectionType.valueOf(value.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                type = ADVANCED;
            }
            return type;
        }
    }
}

