/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.plusplus.connections.db;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import oracle.dbtools.common.utils.ModelUtil;
import oracle.dbtools.connections.api.Connections;
import oracle.dbtools.plusplus.connections.db.AdvancedDefinitionCreator;
import oracle.dbtools.plusplus.connections.db.BasicDefinitionCreator;
import oracle.dbtools.plusplus.connections.db.ConnectionSaverFactory;
import oracle.dbtools.plusplus.connections.db.ConnectionStoreOptions;
import oracle.dbtools.plusplus.connections.db.ConnectionStoreResources;
import oracle.dbtools.plusplus.connections.db.DuplicatesPolicy;
import oracle.dbtools.plusplus.connections.db.MessageLogger;
import oracle.dbtools.plusplus.connections.db.NamedConnections;
import oracle.dbtools.plusplus.connections.db.NewConnectionDefinitionCreator;
import oracle.dbtools.plusplus.connections.db.helpers.ConnectionHelper;
import oracle.dbtools.plusplus.connections.db.helpers.ConnectionHelperFactory;
import oracle.dbtools.plusplus.connections.db.imp.ImportedConnectionResult;
import oracle.dbtools.plusplus.connections.db.imp.ImporterFactory;
import oracle.dbtools.plusplus.connections.db.storage.ConnectionCloner;
import oracle.dbtools.plusplus.connections.db.storage.NamedConnectionDefinition;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.CommonServices;
import oracle.dbtools.raptor.newscriptrunner.IHelp;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.ConnectionContext;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.ConnectorType;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.ConnectorTypeCache;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.PropertyValues;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.CommandParserConstants;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.Help.CommandHelp;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.exception.CommandHelpClassException;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.exception.CommandOptionsClassException;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.exception.ConnectionNotValidException;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.exception.ExtraParameterException;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.exception.InvalidCommandException;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.exception.MissingRequiredParameterException;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.exception.ParameterFailedValidationException;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.parameter.StandardParameter;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.parser.CommandParser;
import oracle.dbtools.raptor.newscriptrunner.restricted.Restricted;
import oracle.dbtools.raptor.newscriptrunner.util.help.HelpPagesBuilder;
import oracle.dbtools.raptor.newscriptrunner.util.parser.OptionBuilder;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParameterBuilder;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Type;
import oracle.dbtools.raptor.newscriptrunner.util.parser.TypeBuilder;

@Restricted(level=Restricted.Level.R4)
public class ConnectionStoreCommand
extends CommandListener
implements IHelp {
    private static final Map<String, SubCommand> subcommands = new HashMap<String, SubCommand>();

    @Override
    public String getCommand() {
        return "connections";
    }

    @Override
    public Optional<String> getHelp(ScriptRunnerContext ctx, String pagePath) {
        int lineSize = Integer.parseInt(ctx.getProperty("script.runner.setlinesize").toString());
        HelpPagesBuilder helpPagesBuilder = new HelpPagesBuilder().lineSize(lineSize).addHelpContainerFor(this).addPagesFor(this.getCommandHelpType());
        return helpPagesBuilder.build().get(pagePath);
    }

    private Type getCommandHelpType() {
        TypeBuilder typeBuilder = new TypeBuilder("connections").truncations("conns");
        Map<String, Map<String, StandardParameter>> cmds = ConnectionStoreOptions.commandModel;
        for (String cmd : subcommands.keySet()) {
            Map<String, StandardParameter> parameters;
            TypeBuilder subtypeBuilder = new TypeBuilder(cmd);
            String alias = ConnectionStoreOptions.aliasLookup.get(cmd);
            if (alias != null) {
                subtypeBuilder.truncations(alias);
            }
            if ((parameters = ConnectionStoreOptions.commandModel.get(cmd.toLowerCase())) != null) {
                for (Map.Entry<String, StandardParameter> parameterEntry : parameters.entrySet()) {
                    String pName = parameterEntry.getKey();
                    StandardParameter param = parameterEntry.getValue();
                    if (param.isPositional()) {
                        subtypeBuilder.add(((ParameterBuilder)new ParameterBuilder(String.class, pName).helpKey(this.createHelpKey(cmd, pName))).build());
                        continue;
                    }
                    OptionBuilder optionBuilder = (OptionBuilder)new OptionBuilder(param.isBoolean() ? Boolean.class : String.class, pName).helpKey(this.createHelpKey(cmd, pName));
                    subtypeBuilder.add(optionBuilder.build());
                }
            }
            typeBuilder.add(subtypeBuilder.build());
        }
        return typeBuilder.build();
    }

    private String createHelpKey(String cmd, String param) {
        return cmd.toUpperCase() + "_" + param.toUpperCase() + "_P";
    }

    @Override
    public boolean isSqlPlus() {
        return false;
    }

    private static SubCommand getSubcommand(String command) {
        return subcommands.get(command);
    }

    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (!this.startsWithAlias(cmd.getSql(), new String[]{"connections", "conns"})) {
            return false;
        }
        MessageLogger.DefaultLoggerWrapper wrapper = MessageLogger.logger(ConnectionStoreCommand.class);
        MessageLogger logger = MessageLogger.builder().interactiveLogger(ctx::writeln).errorLogger(wrapper).traceLogger(wrapper).build();
        try {
            CommandHelp help = new CommandHelp(ctx, ConnectionStoreOptions.class);
            CommandParser.loadParams("connections.params", cmd.getSql(), ctx, ConnectionStoreOptions.class, true, true, true);
            ScriptRunnerContext.Parameters params = ctx.getParameterInstance();
            String baseCommand = params.getParameterAsString("connections.params", CommandParserConstants.BASE_COMMAND).toLowerCase();
            if (ModelUtil.areEqual(baseCommand, "connections") || ModelUtil.areEqual(baseCommand, "conns")) {
                if (params.getParameterAsBoolean("connections.params", CommandParserConstants.HELP).booleanValue()) {
                    logger.logUserMessage(help.getCommandHelp());
                } else {
                    String command = params.getParameterAsString("connections.params", CommandParserConstants.COMMAND);
                    SubCommand subCommand = ConnectionStoreCommand.getSubcommand(command);
                    assert (subCommand != null);
                    subCommand.handleSubcommand(ctx, params, logger);
                }
            }
        }
        catch (CommandHelpClassException | CommandOptionsClassException e) {
            logger.logUserMessage(ConnectionStoreResources.getString("ERROR_IMPROPER_COMFIGURATION"));
        }
        catch (InvalidCommandException e) {
            logger.logUserMessage(e.getLocalizedMessage());
        }
        catch (ParameterFailedValidationException e) {
            logger.logUserMessage(e.getLocalizedMessage());
        }
        catch (ConnectionNotValidException e) {
            logger.logUserMessage(e.getLocalizedMessage());
        }
        catch (MissingRequiredParameterException e) {
            logger.logUserMessage(e.getLocalizedMessage());
        }
        catch (ExtraParameterException e) {
            logger.logUserMessage(e.getLocalizedMessage());
        }
        return true;
    }

    private static void handleImportCommand(ScriptRunnerContext ctx, ScriptRunnerContext.Parameters params, MessageLogger logger) {
        logger.traceMessage("CONNECTIONS IMPORT");
        String duplicates = ConnectionStoreCommand.getParameterValue(params, "duplicates");
        logger.traceMessage("Duplicate options = " + duplicates);
        String path = ConnectionStoreCommand.getParameterValue(params, "path");
        logger.traceMessage("import path = " + path);
        Path importPath = Paths.get(path, new String[0]);
        ImporterFactory.getImporter(importPath, DuplicatesPolicy.valueOf(duplicates.toUpperCase()), NamedConnections.instance().listConnections(), ctx, logger).importConnections().forEach(p -> ((ImportedConnectionResult)p).logResult(logger));
        NamedConnections.instance().refreshConnections();
    }

    private static void handleListCommand(ScriptRunnerContext ctx, ScriptRunnerContext.Parameters params, MessageLogger logger) {
        NamedConnections.instance().listConnections().forEach(logger::logUserMessage);
    }

    private static void handleShowCommand(ScriptRunnerContext ctx, ScriptRunnerContext.Parameters params, MessageLogger logger) {
        String cName = ConnectionStoreCommand.getParameterValue(params, "name");
        logger.traceMessage("Connection name: " + cName);
        NamedConnectionDefinition definition = ConnectionStoreCommand.getConnectionDefinition(cName, logger);
        if (definition == null) {
            return;
        }
        ConnectionHelper helper = ConnectionHelperFactory.findHelper(definition, ctx, logger);
        Properties props = helper.getDisplayProperties();
        if (props == null) {
            logger.logUserMessage(ConnectionStoreResources.getString("ERROR_PROCESSING_CONNECTION_SHOW"));
            return;
        }
        for (String key : props.stringPropertyNames()) {
            logger.logUserMessage(key + ": " + props.getProperty(key));
        }
    }

    private static void handleTestCommand(ScriptRunnerContext ctx, ScriptRunnerContext.Parameters params, MessageLogger logger) {
        NamedConnectionDefinition definition;
        String cName = ConnectionStoreCommand.getParameterValue(params, "name");
        logger.traceMessage("Connection name: " + cName);
        String user = ConnectionStoreCommand.getParameterValue(params, "user");
        if (user != null) {
            logger.traceMessage("Override username with " + user);
        }
        if ((definition = ConnectionStoreCommand.getConnectionDefinition(cName, logger)) == null) {
            return;
        }
        ConnectionHelper creator = ConnectionHelperFactory.findHelper(definition, ctx, logger);
        try {
            creator.testConnection(user);
            logger.logUserMessage(ConnectionStoreResources.getString("TEST_SUCCESS"));
        }
        catch (SQLException ex) {
            logger.logUserMessage(ConnectionStoreResources.format("TEST_FAILURE", ex.getLocalizedMessage()));
        }
    }

    private static void handleAddCommand(ScriptRunnerContext ctx, ScriptRunnerContext.Parameters params, MessageLogger logger) {
        NewConnectionDefinitionCreator creator;
        String connTypeValue = ConnectionStoreCommand.getParameterValue(params, "type");
        ConnectionStoreOptions.ConnectionType connType = ConnectionStoreOptions.ConnectionType.asConnectionType(connTypeValue);
        switch (connType) {
            case BASIC: {
                creator = new BasicDefinitionCreator(ctx, logger);
                break;
            }
            default: {
                creator = new AdvancedDefinitionCreator(ctx, logger);
            }
        }
        if (creator != null) {
            try {
                creator.processParameters(params);
                NamedConnectionDefinition newConn = creator.createDefinition();
                if (newConn != null) {
                    NamedConnections.instance().addConnection(newConn);
                }
            }
            catch (IOException | ExtraParameterException | MissingRequiredParameterException | ParameterFailedValidationException e) {
                logger.logUserMessage(e.getLocalizedMessage());
            }
        } else {
            logger.logUserMessage(ConnectionStoreResources.format("ERROR_UNSUPPORTED_TYPE", new Object[]{connType}));
        }
    }

    private static void handleCloneCommand(ScriptRunnerContext ctx, ScriptRunnerContext.Parameters params, MessageLogger logger) {
        ConnectionCloner cloner = ConnectionCloner.createCloner(ctx, logger);
        try {
            String origName = ConnectionStoreCommand.getParameterValue(params, "original");
            NamedConnectionDefinition origDef = ConnectionStoreCommand.getConnectionDefinition(origName, logger);
            cloner.setOrigin(origDef);
            String dest = ConnectionStoreCommand.getParameterValue(params, "name");
            cloner.setDestination(dest);
            cloner.cloneConnection();
            String username = ConnectionStoreCommand.getParameterValue(params, "user");
            if (ModelUtil.hasLength(username)) {
                boolean skipPwd = ConnectionStoreCommand.getBooleanParameterValue(params, "nopwd");
                cloner.updateUser(username, !skipPwd);
            }
            cloner.saveConnection();
            NamedConnections.instance().refreshConnections();
        }
        catch (IOException ex) {
            logger.logUserMessage(ex.getMessage());
        }
    }

    private static void handleSaveCommand(ScriptRunnerContext ctx, ScriptRunnerContext.Parameters params, MessageLogger logger) {
        ConnectorTypeCache cache = CommonServices.get(ConnectorTypeCache.class);
        ConnectionContext cc = cache.getConnectionContext(ctx);
        ConnectorType connectorType = cc.getCurrentConnectorType();
        if (connectorType == null) {
            logger.logUserMessage(ConnectionStoreResources.getString("ERROR_NO_CURRENT_CONNECTION"));
            return;
        }
        String name = ConnectionStoreCommand.getParameterValue(params, "name");
        Set<String> existingConns = Set.copyOf(NamedConnections.instance().listConnections());
        if (existingConns.contains(name)) {
            logger.logUserMessage(ConnectionStoreResources.format("ERROR_EXISTING_CONNECTION", name));
            return;
        }
        String userOverride = ConnectionStoreCommand.getParameterValue(params, "user");
        boolean skipPwd = ConnectionStoreCommand.getBooleanParameterValue(params, "nopwd");
        ConnectionSaverFactory.ConnectionSaver saver = ConnectionSaverFactory.finderSaver(connectorType.getName(), ctx, logger);
        PropertyValues propertyValues = cc.getCurrentPropertyValues();
        boolean saved = false;
        try {
            saved = saver.saveConnection(name, propertyValues, userOverride, skipPwd);
        }
        catch (IOException ex) {
            logger.logError("error saving connection", ex);
            logger.logUserMessage(ex.getLocalizedMessage());
        }
        if (saved) {
            NamedConnections.instance().refreshConnections();
        }
    }

    static NamedConnectionDefinition getConnectionDefinition(String cName, MessageLogger logger) {
        Connections.Identifier ci = NamedConnections.instance().lookupConnectionIdentifier(cName);
        if (ci == null) {
            logger.logUserMessage(ConnectionStoreResources.format("ERROR_UNKNOWN_CONNECTION", cName));
            return null;
        }
        NamedConnectionDefinition definition = NamedConnections.instance().getConnectionDefinition(ci);
        if (definition == null) {
            logger.logUserMessage(ConnectionStoreResources.format("ERROR_LOADING_CONNECTION", cName));
            return null;
        }
        return definition;
    }

    static String getParameterValue(ScriptRunnerContext.Parameters params, String paramName) {
        return params.getParameterAsString("connections.params", paramName);
    }

    static boolean getBooleanParameterValue(ScriptRunnerContext.Parameters params, String paramName) {
        Boolean b = params.getParameterAsBoolean("connections.params", paramName);
        return b != null && b != false;
    }

    static Integer getIntegerParameterValue(ScriptRunnerContext.Parameters params, String paramName) {
        return params.getParameterAsInt("connections.params", paramName);
    }

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    static {
        subcommands.put("import", ConnectionStoreCommand::handleImportCommand);
        subcommands.put("list", ConnectionStoreCommand::handleListCommand);
        subcommands.put("show", ConnectionStoreCommand::handleShowCommand);
        subcommands.put("test", ConnectionStoreCommand::handleTestCommand);
        subcommands.put("add", ConnectionStoreCommand::handleAddCommand);
        subcommands.put("clone", ConnectionStoreCommand::handleCloneCommand);
        subcommands.put("save", ConnectionStoreCommand::handleSaveCommand);
    }

    private static interface SubCommand {
        public void handleSubcommand(ScriptRunnerContext var1, ScriptRunnerContext.Parameters var2, MessageLogger var3);
    }
}

