/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.plusplus.connections.db;

import oracle.dbtools.common.utils.ModelUtil;
import oracle.dbtools.plusplus.connections.db.ConnectionStoreCommand;
import oracle.dbtools.plusplus.connections.db.ConnectionStoreResources;
import oracle.dbtools.plusplus.connections.db.MessageLogger;
import oracle.dbtools.plusplus.connections.db.NewConnectionDefinitionCreator;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.ParmResources;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.exception.ExtraParameterException;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.exception.MissingRequiredParameterException;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.exception.ParameterFailedValidationException;

class BasicDefinitionCreator
extends NewConnectionDefinitionCreator {
    BasicDefinitionCreator(ScriptRunnerContext ctx, MessageLogger logger) {
        super(ctx, logger);
    }

    @Override
    protected String processTypeSpecificParameters(ScriptRunnerContext.Parameters params) throws MissingRequiredParameterException, ParameterFailedValidationException, ExtraParameterException {
        StringBuilder sb = new StringBuilder();
        this.setDbToolsPropertyValue("type", "ORACLE_BASIC");
        String host = ConnectionStoreCommand.getParameterValue(params, "host");
        if (!ModelUtil.hasLength(host)) {
            throw new MissingRequiredParameterException(ParmResources.format("REQUIRED_PARM_MISSING", "host"));
        }
        this.setDbToolsPropertyValue("host", host);
        sb.append(host).append(":");
        Integer port = ConnectionStoreCommand.getIntegerParameterValue(params, "port");
        if (port == null) {
            throw new MissingRequiredParameterException(ParmResources.format("REQUIRED_PARM_MISSING", "port"));
        }
        if (port.compareTo(0) <= 0) {
            throw new ParameterFailedValidationException(ParmResources.format("BAD_PARM_VALUE", "port"));
        }
        this.setDbToolsPropertyValue("port", port.toString());
        sb.append(port);
        String svcName = ConnectionStoreCommand.getParameterValue(params, "servicename");
        String sid = ConnectionStoreCommand.getParameterValue(params, "sid");
        if (ModelUtil.hasLength(svcName)) {
            if (ModelUtil.hasLength(sid)) {
                throw new ExtraParameterException(ConnectionStoreResources.getString("ERROR_CONFLICTING_SERVICE_AND_SID"));
            }
            this.setDbToolsPropertyValue("serviceName", svcName);
            sb.append("/").append(svcName);
        } else {
            if (!ModelUtil.hasLength(sid)) {
                throw new MissingRequiredParameterException(ConnectionStoreResources.getString("ERROR_MISSING_SERVICE_OR_SID"));
            }
            this.setDbToolsPropertyValue("sid", sid);
            sb.append(":").append(sid);
        }
        return sb.toString();
    }
}

