/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.reports;

import com.oracle.premigration.commons.lang.Language;
import com.oracle.premigration.dbinspector.Check;
import com.oracle.premigration.dbinspector.CheckResult;
import com.oracle.premigration.helpers.Utilities;
import com.oracle.premigration.reports.ReportData;
import com.oracle.premigration.reports.json.CpatJsonIgnore;
import com.oracle.premigration.reports.json.CpatJsonPropertyDescription;
import com.oracle.premigration.reports.text.TextProperty;
import com.oracle.premigration.reports.text.TextReportSectionName;
import com.oracle.premigration.reports.text.TextValueHint;
import com.oracle.premigration.reports.text.serialization.TextReportLabeledValue;
import java.util.List;

public final class ChecksSummary {
    @CpatJsonIgnore
    private final Language lang = Language.getInstance();
    @CpatJsonPropertyDescription(value="Number & names of schemas analyzed")
    private final String analyzedSchemaSummary;
    @TextProperty(labelKey="CHECK_NUMBER_RUN_LABEL", section=TextReportSectionName.CHECK_SUMMARY, serializationClass=TextReportLabeledValue.class, valueHint=TextValueHint.METADATA)
    @CpatJsonPropertyDescription(value="Number of checks run")
    private final String totalNumberOfChecksPerformed;
    @TextProperty(labelKey="CHECK_SUMMARY_0_FATAL_LABEL", section=TextReportSectionName.CHECK_SUMMARY, serializationClass=TextReportLabeledValue.class, valueHint=TextValueHint.NATURAL_LANGUAGE)
    @CpatJsonPropertyDescription(value="The number and names of checks for result type FATAL. This string will look like: There were X FATAL checks: one_check_name, another_check_name...")
    private final String fatalChecks;
    @TextProperty(labelKey="CHECK_SUMMARY_1_BLOCKER_LABEL", section=TextReportSectionName.CHECK_SUMMARY, serializationClass=TextReportLabeledValue.class, valueHint=TextValueHint.NATURAL_LANGUAGE)
    @CpatJsonPropertyDescription(value="The number and names of checks for result type BLOCKER. This string will look like: There were X BLOCKER checks: one_check_name, another_check_name...")
    private final String blockerChecks;
    @TextProperty(labelKey="CHECK_SUMMARY_2_WARNING_LABEL", section=TextReportSectionName.CHECK_SUMMARY, serializationClass=TextReportLabeledValue.class, valueHint=TextValueHint.NATURAL_LANGUAGE)
    @CpatJsonPropertyDescription(value="The number and names of checks for result type WARNING. This string will look like: There were X WARNING checks: one_check_name, another_check_name...")
    private final String warningChecks;
    @TextProperty(labelKey="CHECK_SUMMARY_3_INFORMATIONAL_LABEL", section=TextReportSectionName.CHECK_SUMMARY, serializationClass=TextReportLabeledValue.class, valueHint=TextValueHint.NATURAL_LANGUAGE)
    @CpatJsonPropertyDescription(value="The number and names of checks for result type INFORMATIONAL. This string will look like: There were X INFORMATIONAL checks: one_check_name, another_check_name...")
    private final String infoChecks;
    @TextProperty(labelKey="CHECK_SUMMARY_4_PASS_LABEL", section=TextReportSectionName.CHECK_SUMMARY, serializationClass=TextReportLabeledValue.class, valueHint=TextValueHint.NATURAL_LANGUAGE)
    @CpatJsonPropertyDescription(value="The number and names of checks for result type PASS. This string will look like: There were X PASS checks: one_check_name, another_check_name...")
    private final String passingChecks;

    public ChecksSummary(ReportData reportData) {
        this.analyzedSchemaSummary = this.lang.txt("CHECK_SUMMARY_SCHEMAS", reportData.getSrcNumSchemasAnalyzed(), Utilities.join(",", reportData.getSrcSchemasAnalyzed()));
        this.totalNumberOfChecksPerformed = this.lang.txt("CHECK_SUMMARY_CHECK_COUNT", reportData.getCheckList().size());
        this.fatalChecks = this.formatCheckResultGroup(reportData.getCheckList(), CheckResult.FATAL);
        this.blockerChecks = this.formatCheckResultGroup(reportData.getCheckList(), CheckResult.BLOCKER);
        this.warningChecks = this.formatCheckResultGroup(reportData.getCheckList(), CheckResult.WARNING);
        this.infoChecks = this.formatCheckResultGroup(reportData.getCheckList(), CheckResult.INFORMATIONAL);
        this.passingChecks = this.formatCheckResultGroup(reportData.getCheckList(), CheckResult.PASS);
    }

    private String formatCheckResultGroup(List<Check> checkList, CheckResult result) {
        StringBuilder resultSummary = new StringBuilder();
        int resultCount = 0;
        for (Check check : checkList) {
            if (!check.getResult().equals((Object)result)) continue;
            int relObjCnt = check.getRelevantObjectsData().size();
            int omittedObjects = check.getOmittedRelevantObjectsCount();
            String perCheckSummary = omittedObjects < 1 ? this.lang.txt("CHECK_SUMMARY_RESULT_INNER", check.getName(), relObjCnt) : this.lang.txt("CHECK_SUMMARY_RESULT_INNER_CAPPED", check.getName(), relObjCnt);
            resultSummary.append(resultCount > 0 ? ", " : "").append(perCheckSummary);
            ++resultCount;
        }
        String formatConstant = resultCount == 0 ? "CHECK_SUMMARY_EMPTY_RESULT_GROUP" : "CHECK_SUMMARY_RESULT_GROUP";
        return this.lang.txt(formatConstant, resultCount, result.toString(), resultSummary.toString());
    }

    public String getAnalyzedSchemaSummary() {
        return this.analyzedSchemaSummary;
    }

    public String getTotalNumberOfChecksPerformed() {
        return this.totalNumberOfChecksPerformed;
    }

    public String getFatalChecks() {
        return this.fatalChecks;
    }

    public String getBlockerChecks() {
        return this.blockerChecks;
    }

    public String getWarningChecks() {
        return this.warningChecks;
    }

    public String getInfoChecks() {
        return this.infoChecks;
    }

    public String getPassingChecks() {
        return this.passingChecks;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChecksSummary)) {
            return false;
        }
        ChecksSummary other = (ChecksSummary)o;
        Language this$lang = this.getLang();
        Language other$lang = other.getLang();
        if (this$lang == null ? other$lang != null : !this$lang.equals(other$lang)) {
            return false;
        }
        String this$analyzedSchemaSummary = this.getAnalyzedSchemaSummary();
        String other$analyzedSchemaSummary = other.getAnalyzedSchemaSummary();
        if (this$analyzedSchemaSummary == null ? other$analyzedSchemaSummary != null : !this$analyzedSchemaSummary.equals(other$analyzedSchemaSummary)) {
            return false;
        }
        String this$totalNumberOfChecksPerformed = this.getTotalNumberOfChecksPerformed();
        String other$totalNumberOfChecksPerformed = other.getTotalNumberOfChecksPerformed();
        if (this$totalNumberOfChecksPerformed == null ? other$totalNumberOfChecksPerformed != null : !this$totalNumberOfChecksPerformed.equals(other$totalNumberOfChecksPerformed)) {
            return false;
        }
        String this$fatalChecks = this.getFatalChecks();
        String other$fatalChecks = other.getFatalChecks();
        if (this$fatalChecks == null ? other$fatalChecks != null : !this$fatalChecks.equals(other$fatalChecks)) {
            return false;
        }
        String this$blockerChecks = this.getBlockerChecks();
        String other$blockerChecks = other.getBlockerChecks();
        if (this$blockerChecks == null ? other$blockerChecks != null : !this$blockerChecks.equals(other$blockerChecks)) {
            return false;
        }
        String this$warningChecks = this.getWarningChecks();
        String other$warningChecks = other.getWarningChecks();
        if (this$warningChecks == null ? other$warningChecks != null : !this$warningChecks.equals(other$warningChecks)) {
            return false;
        }
        String this$infoChecks = this.getInfoChecks();
        String other$infoChecks = other.getInfoChecks();
        if (this$infoChecks == null ? other$infoChecks != null : !this$infoChecks.equals(other$infoChecks)) {
            return false;
        }
        String this$passingChecks = this.getPassingChecks();
        String other$passingChecks = other.getPassingChecks();
        return !(this$passingChecks == null ? other$passingChecks != null : !this$passingChecks.equals(other$passingChecks));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Language $lang = this.getLang();
        result = result * 59 + ($lang == null ? 43 : $lang.hashCode());
        String $analyzedSchemaSummary = this.getAnalyzedSchemaSummary();
        result = result * 59 + ($analyzedSchemaSummary == null ? 43 : $analyzedSchemaSummary.hashCode());
        String $totalNumberOfChecksPerformed = this.getTotalNumberOfChecksPerformed();
        result = result * 59 + ($totalNumberOfChecksPerformed == null ? 43 : $totalNumberOfChecksPerformed.hashCode());
        String $fatalChecks = this.getFatalChecks();
        result = result * 59 + ($fatalChecks == null ? 43 : $fatalChecks.hashCode());
        String $blockerChecks = this.getBlockerChecks();
        result = result * 59 + ($blockerChecks == null ? 43 : $blockerChecks.hashCode());
        String $warningChecks = this.getWarningChecks();
        result = result * 59 + ($warningChecks == null ? 43 : $warningChecks.hashCode());
        String $infoChecks = this.getInfoChecks();
        result = result * 59 + ($infoChecks == null ? 43 : $infoChecks.hashCode());
        String $passingChecks = this.getPassingChecks();
        result = result * 59 + ($passingChecks == null ? 43 : $passingChecks.hashCode());
        return result;
    }

    public String toString() {
        return "ChecksSummary(lang=" + this.getLang() + ", analyzedSchemaSummary=" + this.getAnalyzedSchemaSummary() + ", totalNumberOfChecksPerformed=" + this.getTotalNumberOfChecksPerformed() + ", fatalChecks=" + this.getFatalChecks() + ", blockerChecks=" + this.getBlockerChecks() + ", warningChecks=" + this.getWarningChecks() + ", infoChecks=" + this.getInfoChecks() + ", passingChecks=" + this.getPassingChecks() + ")";
    }

    @CpatJsonIgnore
    public Language getLang() {
        return this.lang;
    }
}

