/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.checks;

import com.oracle.premigration.commons.enums.LockdownProfile;
import com.oracle.premigration.commons.enums.MigrationMethod;
import com.oracle.premigration.commons.enums.TargetCloud;
import com.oracle.premigration.dbinspector.Check;
import com.oracle.premigration.dbinspector.CheckResult;
import com.oracle.premigration.dbinspector.ExecutionContext;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class has_trusted_server_entries
extends Check {
    public has_trusted_server_entries() {
        this.getLockdownProfiles().addAll(Arrays.asList(LockdownProfile.NONE, LockdownProfile.NOT_AUTONOMOUS));
        this.getTargetCloud().addAll(Arrays.asList(TargetCloud.ATPD, TargetCloud.ATPS, TargetCloud.ADWD, TargetCloud.ADWS));
        this.getMigrationMethods().addAll(Arrays.asList(MigrationMethod.DATAPUMP, MigrationMethod.DATAPUMP_DBLINK, MigrationMethod.GOLDENGATE));
        this.setScope(Check.Scope.INSTANCE);
    }

    @Override
    public void prepare(ExecutionContext exeCtx) {
        this.setSqlQuery("SELECT TRUST, NAME FROM SYS.TRUSTED_SERVERS");
    }

    @Override
    public CheckResult determineResult() {
        Map<String, String> singleEntry;
        List<Map<String, String>> relevantObjectsData = this.getRelevantObjectsData();
        if (relevantObjectsData == null || relevantObjectsData.isEmpty()) {
            return CheckResult.PASS;
        }
        if (relevantObjectsData.size() == 1 && "TRUSTED".equalsIgnoreCase((singleEntry = relevantObjectsData.get(0)).get("TRUST")) && "ALL".equalsIgnoreCase(singleEntry.get("NAME"))) {
            return CheckResult.INFORMATIONAL;
        }
        return CheckResult.WARNING;
    }
}

