/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.checks;

import com.oracle.premigration.commons.enums.LockdownProfile;
import com.oracle.premigration.commons.enums.MigrationMethod;
import com.oracle.premigration.commons.enums.TargetCloud;
import com.oracle.premigration.commons.enums.TargetInstanceProp;
import com.oracle.premigration.dbinspector.Check;
import com.oracle.premigration.dbinspector.CheckResult;
import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.dbinspector.FilterableCheck;
import com.oracle.premigration.helpers.SqlUtils;
import com.oracle.premigration.logger.PremigrationLogger;
import com.oracle.premigration.reports.CheckFiltrationMetadata;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class has_role_privileges
extends FilterableCheck {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(has_role_privileges.class.getName());

    public has_role_privileges() {
        this.getLockdownProfiles().addAll(Arrays.asList(LockdownProfile.PAAS_ATPD, LockdownProfile.ADW_ADWD, LockdownProfile.OLTP_ATPS, LockdownProfile.DWCS_ADWS, LockdownProfile.ADB_UNSUPPORTED, LockdownProfile.NONE, LockdownProfile.NOT_AUTONOMOUS));
        this.getTargetCloud().addAll(Arrays.asList(TargetCloud.ATPD, TargetCloud.ATPS, TargetCloud.ADWD, TargetCloud.ADWS));
        this.getMigrationMethods().addAll(Arrays.asList(MigrationMethod.DATAPUMP, MigrationMethod.DATAPUMP_DBLINK, MigrationMethod.GOLDENGATE));
        this.setScope(Check.Scope.SCHEMA);
        this.setDeclarativeResult(CheckResult.BLOCKER);
    }

    @Override
    public void initFiltrationMetadata() {
        this.setFiltrationMetadata(CheckFiltrationMetadata.builder().schemaOwnerColumn("GRANTEE").objectNameColumn("GRANTED_ROLE").objectTypeFixed("ROLE GRANT").build());
    }

    @Override
    public void prepare(ExecutionContext exeCtx) {
        String sqlQuery;
        ArrayList<String> prohibitedRoleList = new ArrayList<String>(Collections.singletonList("DBA"));
        boolean hasTargetRoleProperty = true;
        String targetRoleProperty = exeCtx.getAnalysisProperty(TargetInstanceProp.ROLEPRIVILEGE.getKey());
        if (targetRoleProperty == null || targetRoleProperty.trim().isEmpty()) {
            hasTargetRoleProperty = false;
        }
        String granteeWhereClause = SqlUtils.createWhereClauseForColumn(exeCtx, "GRANTEE");
        String srcRolesQuery = "SELECT DISTINCT GRANTED_ROLE FROM SYS.DBA_ROLE_PRIVS " + granteeWhereClause;
        List<Object> srcRoleList = new ArrayList();
        try {
            srcRoleList = SqlUtils.getStringList(srcRolesQuery, exeCtx);
        }
        catch (SQLException e) {
            log.severe("Exception calling SqlUtils.getStringList with '" + srcRolesQuery + "'", e);
        }
        if (hasTargetRoleProperty) {
            ArrayList<String> targetRoleList = new ArrayList<String>(Arrays.asList(targetRoleProperty.split(",")));
            srcRoleList.removeAll(targetRoleList);
            String grantedRoleClause = srcRoleList.isEmpty() ? SqlUtils.createAndClause("GRANTED_ROLE", false, targetRoleList) : SqlUtils.createAndClause("GRANTED_ROLE", true, srcRoleList);
            sqlQuery = "SELECT GRANTEE, GRANTED_ROLE FROM SYS.DBA_ROLE_PRIVS " + granteeWhereClause + " AND GRANTEE IN (SELECT USERNAME FROM SYS.DBA_USERS)  AND GRANTED_ROLE <> 'SQLT_USER_ROLE' " + grantedRoleClause;
        } else {
            srcRoleList.retainAll(prohibitedRoleList);
            if (!srcRoleList.isEmpty()) {
                sqlQuery = "SELECT GRANTEE, GRANTED_ROLE FROM SYS.DBA_ROLE_PRIVS " + granteeWhereClause + " AND GRANTED_ROLE <> 'SQLT_USER_ROLE' " + SqlUtils.createAndClause("GRANTED_ROLE", true, srcRoleList);
            } else {
                this.skipCheck(this.lang.txt("CHECK_SKIPPED_BECAUSE_ROLE_MISSING", this.getName()), CheckResult.WARNING);
                return;
            }
        }
        this.setSqlQuery(sqlQuery);
    }
}

