/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.checks;

import com.oracle.premigration.commons.enums.LockdownProfile;
import com.oracle.premigration.commons.enums.MigrationMethod;
import com.oracle.premigration.commons.enums.TargetCloud;
import com.oracle.premigration.commons.enums.TargetInstanceProp;
import com.oracle.premigration.dbinspector.Check;
import com.oracle.premigration.dbinspector.CheckResult;
import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.dbinspector.FilterableCheck;
import com.oracle.premigration.helpers.SqlUtils;
import com.oracle.premigration.logger.PremigrationLogger;
import com.oracle.premigration.reports.CheckFiltrationMetadata;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class has_profile_not_default
extends FilterableCheck {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(has_profile_not_default.class.getName());
    private boolean hasProfileProperty = true;

    public has_profile_not_default() {
        this.getLockdownProfiles().addAll(Arrays.asList(LockdownProfile.PAAS_ATPD, LockdownProfile.ADW_ADWD, LockdownProfile.OLTP_ATPS, LockdownProfile.DWCS_ADWS, LockdownProfile.ADB_UNSUPPORTED, LockdownProfile.NONE, LockdownProfile.NOT_AUTONOMOUS));
        this.getTargetCloud().addAll(Arrays.asList(TargetCloud.ATPD, TargetCloud.ATPS, TargetCloud.ADWD, TargetCloud.ADWS, TargetCloud.DEFAULT));
        this.getMigrationMethods().addAll(Arrays.asList(MigrationMethod.DATAPUMP, MigrationMethod.DATAPUMP_DBLINK, MigrationMethod.GOLDENGATE));
        this.setScope(Check.Scope.SCHEMA_ONLY);
    }

    @Override
    public void initFiltrationMetadata() {
        this.setFiltrationMetadata(CheckFiltrationMetadata.builder().schemaOwnerColumn("USERNAME").objectNameColumn("USERNAME").objectTypeFixed("USER").build());
    }

    @Override
    public void prepare(ExecutionContext exeCtx) {
        String sqlQuery;
        String whereClause = SqlUtils.createWhereClauseForColumn(exeCtx, "USERNAME");
        String targetProfileProperty = exeCtx.getAnalysisProperty(TargetInstanceProp.PROFILES.getKey());
        if (targetProfileProperty == null || targetProfileProperty.trim().length() == 0) {
            this.hasProfileProperty = false;
        }
        if (this.hasProfileProperty) {
            List<Object> sourceProfilesList = new ArrayList();
            try {
                String getSourceProfilesQuery = "SELECT DISTINCT PROFILE FROM SYS.DBA_USERS " + whereClause;
                sourceProfilesList = SqlUtils.getStringList(getSourceProfilesQuery, exeCtx);
            }
            catch (SQLException e) {
                log.severe("Failed to fetch source profiles", e);
            }
            ArrayList<String> targetProfilesList = new ArrayList<String>(Arrays.asList(targetProfileProperty.trim().split(",")));
            ArrayList<String> missingProfiles = new ArrayList<String>();
            for (String string : sourceProfilesList) {
                if (string.trim().length() == 0 || targetProfilesList.contains(string)) continue;
                missingProfiles.add(string);
            }
            sqlQuery = !missingProfiles.isEmpty() ? "SELECT USERNAME, PROFILE FROM SYS.DBA_USERS " + whereClause + SqlUtils.createAndClause("PROFILE", true, missingProfiles) : "SELECT USERNAME, PROFILE FROM SYS.DBA_USERS " + whereClause + SqlUtils.createAndClause("PROFILE", false, sourceProfilesList);
        } else {
            sqlQuery = "SELECT USERNAME, PROFILE FROM SYS.DBA_USERS " + whereClause + " AND PROFILE != 'DEFAULT'";
        }
        this.setSqlQuery(sqlQuery);
    }

    @Override
    public CheckResult determineResult() {
        if (this.hasProfileProperty) {
            return super.blockerIfAnyValidator();
        }
        return super.warningIfAnyValidator();
    }
}

