/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.checks;

import com.oracle.premigration.commons.enums.LockdownProfile;
import com.oracle.premigration.commons.enums.MigrationMethod;
import com.oracle.premigration.dbinspector.Check;
import com.oracle.premigration.dbinspector.CheckResult;
import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.dbinspector.FilterableCheck;
import com.oracle.premigration.helpers.SqlUtils;
import com.oracle.premigration.logger.PremigrationLogger;
import com.oracle.premigration.reports.CheckFiltrationMetadata;
import java.util.Arrays;

public abstract class has_columns_with_media_data_types
extends FilterableCheck {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(has_columns_with_media_data_types.class.getName());

    protected has_columns_with_media_data_types() {
        this.getLockdownProfiles().addAll(Arrays.asList(LockdownProfile.NONE, LockdownProfile.NOT_AUTONOMOUS));
        this.getMigrationMethods().addAll(Arrays.asList(MigrationMethod.DATAPUMP, MigrationMethod.DATAPUMP_DBLINK, MigrationMethod.GOLDENGATE));
        this.setScope(Check.Scope.SCHEMA);
        this.setDeclarativeResult(CheckResult.BLOCKER);
    }

    @Override
    public void initFiltrationMetadata() {
        this.setFiltrationMetadata(CheckFiltrationMetadata.builder().schemaOwnerColumn("OWNER").objectNameColumn("TABLE_NAME").objectTypeFixed("TABLE").build());
    }

    @Override
    public void prepare(ExecutionContext exeCtx) {
        String whereClause = SqlUtils.createWhereClauseForOwnerColumn(exeCtx);
        String mediaTypeSql = "SELECT OWNER, TABLE_NAME, COLUMN_NAME, DATA_TYPE FROM SYS.DBA_TAB_COLUMNS " + whereClause + " AND DATA_TYPE IN ('ORDIMAGE','ORDIMAGESIGNATURE','ORDAUDIO','ORDVIDEO', 'ORDDOC','ORDSOURCE','ORDDICOM','ORDDATASOURCE', 'SI_STILLIMAGE','SI_COLOR','SI_AVERAGECOLOR', 'SI_POSITIONALCOLOR','SI_TEXTURE','SI_COLORHISTOGRAM', 'SI_FEATURELIST')  AND DATA_TYPE_OWNER IN ('ORDSYS', 'PUBLIC') ORDER BY 1,2,3";
        this.setSqlQuery(mediaTypeSql);
    }
}

